/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.media.IMuxer;
import com.serenegiant.media.MediaMuxerWrapper;
import com.serenegiant.media.exceptions.TimeoutException;
import com.serenegiant.mediastore.MediaStoreOutputStream;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.UriHelper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;

@Keep
public final class VideoMuxer
implements IMuxer {
    private static final boolean DEBUG = false;
    private static final String TAG = VideoMuxer.class.getSimpleName();
    private static boolean isLoaded = false;
    protected long mNativePtr;
    private volatile boolean mIsStarted;
    private boolean mReleased;
    private int mLastTrackIndex = -1;

    public VideoMuxer(String path) {
        this.mNativePtr = this.nativeCreate(path);
    }

    public VideoMuxer(int fd) {
        this.mNativePtr = this.nativeCreateFromFD(fd);
    }

    public void release() {
        if (this.mNativePtr != 0L) {
            this.mReleased = true;
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @SuppressLint(value={"InlinedApi"})
    public int addTrack(@NonNull MediaFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("format must not be null.");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (format.containsKey("mime")) {
            map.put("mime", format.getString("mime"));
        }
        if (format.containsKey("width")) {
            map.put("width", format.getInteger("width"));
        }
        if (format.containsKey("height")) {
            map.put("height", format.getInteger("height"));
        }
        if (format.containsKey("bitrate")) {
            map.put("bitrate", format.getInteger("bitrate"));
        }
        if (format.containsKey("color-format")) {
            map.put("color-format", format.getInteger("color-format"));
        }
        if (format.containsKey("frame-rate")) {
            map.put("frame-rate", format.getInteger("frame-rate"));
        }
        if (format.containsKey("i-frame-interval")) {
            map.put("i-frame-interval", format.getInteger("i-frame-interval"));
        }
        if (format.containsKey("max-input-size")) {
            map.put("max-input-size", format.getInteger("max-input-size"));
        }
        if (format.containsKey("durationUs")) {
            map.put("durationUs", format.getInteger("durationUs"));
        }
        if (format.containsKey("what")) {
            map.put("what", format.getInteger("what"));
        }
        if (format.containsKey("csd-0")) {
            map.put("csd-0", format.getByteBuffer("csd-0"));
        }
        if (format.containsKey("csd-1")) {
            map.put("csd-1", format.getByteBuffer("csd-1"));
        }
        Object[] ks = map.keySet().toArray();
        int n = ks.length;
        String[] keys = new String[n];
        for (int i = 0; i < n; ++i) {
            keys[i] = (String)ks[i];
        }
        Collection values = map.values();
        int trackIndex = VideoMuxer.nativeAddTrack(this.mNativePtr, keys, values.toArray());
        if (this.mLastTrackIndex >= trackIndex) {
            throw new IllegalArgumentException("Invalid format.");
        }
        this.mLastTrackIndex = trackIndex;
        return trackIndex;
    }

    public void start() {
        int res = -1;
        if (this.mNativePtr != 0L) {
            res = VideoMuxer.nativeStart(this.mNativePtr);
        }
        if (res != 0) {
            throw new IllegalStateException("failed to start muxer");
        }
        this.mIsStarted = true;
    }

    public void stop() {
        int res;
        this.mIsStarted = false;
        if (this.mNativePtr != 0L && (res = VideoMuxer.nativeStop(this.mNativePtr)) != 0) {
            throw new RuntimeException("failed to stop muxer");
        }
    }

    public void writeSampleData(int trackIndex, @NonNull ByteBuffer buf, @NonNull MediaCodec.BufferInfo bufferInfo) {
        int res = 1;
        if (!this.mReleased && this.mNativePtr != 0L) {
            res = VideoMuxer.nativeWriteSampleData(this.mNativePtr, trackIndex, buf, bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs, bufferInfo.flags);
        }
        if (res != 0) {
            switch (res) {
                case -2000: {
                    throw new TimeoutException();
                }
                case 1: {
                    throw new IllegalStateException("muxer already released.");
                }
            }
            throw new IllegalArgumentException("writeSampleData:err=" + res);
        }
    }

    private native long nativeCreate(String var1);

    private native long nativeCreateFromFD(int var1);

    private native void nativeDestroy(long var1);

    private static native int nativeAddTrack(long var0, String[] var2, Object[] var3);

    private static native int nativeStart(long var0);

    private static native int nativeStop(long var0);

    private static native int nativeWriteSampleData(long var0, int var2, ByteBuffer var3, int var4, int var5, long var6, int var8);

    public boolean isStarted() {
        return this.mIsStarted && !this.mReleased;
    }

    static {
        if (!isLoaded) {
            System.loadLibrary("c++_shared");
            System.loadLibrary("common");
            System.loadLibrary("media-utils");
            System.loadLibrary("media-backport");
            isLoaded = true;
        }
    }

    public static class DefaultFactory
    implements IMuxer.IMuxerFactory {
        @Deprecated
        @SuppressLint(value={"InlinedApi"})
        public IMuxer createMuxer(boolean useMediaMuxer, String output_oath) throws IOException {
            VideoMuxer result = useMediaMuxer && BuildCheck.isAPI18() ? new MediaMuxerWrapper(output_oath, 0) : new VideoMuxer(output_oath);
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @SuppressLint(value={"NewApi"})
        public IMuxer createMuxer(boolean useMediaMuxer, int fd) throws IOException {
            if (!useMediaMuxer) return new VideoMuxer(fd);
            if (!BuildCheck.isAPI18()) return new VideoMuxer(fd);
            if (BuildCheck.isAPI29()) {
                throw new UnsupportedOperationException("createMuxer from fd does not support on API29 and later devices");
            }
            if (!BuildCheck.isAPI26()) throw new UnsupportedOperationException("createMuxer from fd does not support on API<26");
            ParcelFileDescriptor pfd = ParcelFileDescriptor.fromFd((int)fd);
            return new MediaMuxerWrapper(pfd.getFileDescriptor(), 0);
        }

        @SuppressLint(value={"NewApi"})
        public IMuxer createMuxer(@NonNull Context context, boolean useMediaMuxer, @NonNull DocumentFile file) throws IOException {
            Uri uri = file.getUri();
            VideoMuxer result = null;
            if (useMediaMuxer && BuildCheck.isAPI18()) {
                if (BuildCheck.isAPI29() && UriHelper.isContentUri((Uri)uri)) {
                    result = new MediaMuxerWrapper(new MediaStoreOutputStream(context, file), 0);
                } else if (BuildCheck.isAPI26()) {
                    result = new MediaMuxerWrapper(context.getContentResolver().openFileDescriptor(uri, "rw").getFileDescriptor(), 0);
                } else {
                    String path = UriHelper.getPath((Context)context, (Uri)uri);
                    File f = new File(path);
                    if (f.canWrite()) {
                        result = new MediaMuxerWrapper(path, 0);
                    } else {
                        Log.w((String)"IMuxer", (String)"can't write to the file, try to use VideoMuxer instead");
                    }
                }
            }
            if (result == null) {
                result = new VideoMuxer(context.getContentResolver().openFileDescriptor(file.getUri(), "rw").getFd());
            }
            return result;
        }
    }
}

