/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.camera.Size;
import com.serenegiant.system.Stacktrace;
import com.serenegiant.usb.uvc.PreviewFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SizeUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = SizeUtils.class.getSimpleName();

    private SizeUtils() {
    }

    @Deprecated
    @NonNull
    public static Collection<RawFrameType> getSupportedFrameTypes() {
        HashSet<RawFrameType> result = new HashSet<RawFrameType>();
        result.add(RawFrameType.RAW_FRAME_UNCOMPRESSED_YUYV);
        result.add(RawFrameType.RAW_FRAME_MJPEG);
        result.add(RawFrameType.RAW_FRAME_H264);
        result.add(RawFrameType.RAW_FRAME_VP8);
        return result;
    }

    @NonNull
    public static Collection<PreviewFormat> getSupportedFrameFormats() {
        HashSet<PreviewFormat> result = new HashSet<PreviewFormat>();
        result.add(PreviewFormat.PREVIEW_FORMAT_YUY2);
        result.add(PreviewFormat.PREVIEW_FORMAT_MJPEG);
        result.add(PreviewFormat.PREVIEW_FORMAT_H264);
        result.add(PreviewFormat.PREVIEW_FORMAT_VP8);
        return result;
    }

    public static RawFrameType getFrameType(PreviewFormat format) {
        switch (format) {
            case PREVIEW_FORMAT_YUY2: {
                return RawFrameType.RAW_FRAME_UNCOMPRESSED_YUYV;
            }
            case PREVIEW_FORMAT_MJPEG: {
                return RawFrameType.RAW_FRAME_MJPEG;
            }
            case PREVIEW_FORMAT_H264: {
                return RawFrameType.RAW_FRAME_H264;
            }
            case PREVIEW_FORMAT_VP8: {
                return RawFrameType.RAW_FRAME_VP8;
            }
        }
        return RawFrameType.RAW_FRAME_UNKNOWN;
    }

    @NonNull
    public static PreviewFormat getPreviewFormat(RawFrameType frameType) {
        switch (frameType) {
            case RAW_FRAME_UNCOMPRESSED_YUYV: {
                return PreviewFormat.PREVIEW_FORMAT_YUY2;
            }
            case RAW_FRAME_MJPEG: {
                return PreviewFormat.PREVIEW_FORMAT_MJPEG;
            }
            case RAW_FRAME_H264: {
                return PreviewFormat.PREVIEW_FORMAT_H264;
            }
            case RAW_FRAME_VP8: {
                return PreviewFormat.PREVIEW_FORMAT_VP8;
            }
        }
        return PreviewFormat.PREVIEW_FORMAT_UNSPECIFIED;
    }

    @NonNull
    public static String toJsonString(@NonNull List<Size> sizeList) {
        String result = "";
        SparseArray resolutions = new SparseArray();
        for (Size size : sizeList) {
            ArrayList<Size> format = (ArrayList<Size>)resolutions.get(size.frameType.getValue());
            if (format == null) {
                format = new ArrayList<Size>();
                resolutions.put(size.frameType.getValue(), format);
            }
            format.add(size.index, size);
        }
        int n = resolutions.size();
        if (n > 0) {
            JSONArray formats = new JSONArray();
            for (int i = 0; i < n; ++i) {
                int frameType = resolutions.keyAt(i);
                List sizes = (List)resolutions.valueAt(i);
                JSONArray resolutionArray = new JSONArray();
                JSONArray frameRateArray = new JSONArray();
                for (Size size : sizes) {
                    try {
                        frameRateArray.put((Object)new JSONArray(size.getSupportedFrameRateString()));
                        resolutionArray.put((Object)String.format(Locale.US, "%dx%d", size.width, size.height));
                    }
                    catch (JSONException jSONException) {}
                }
                JSONObject format = new JSONObject();
                try {
                    format.put("frame_type", frameType);
                    format.put("default", 1);
                    format.put("size", (Object)resolutionArray);
                    format.put("frameRate", (Object)frameRateArray);
                    formats.put(i, (Object)format);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            JSONObject json = new JSONObject();
            try {
                json.put("formats", (Object)formats);
                result = json.toString();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    @NonNull
    public static Collection<RawFrameType> getFrameTypes(@Nullable String sizeListString) {
        return SizeUtils.getFrameTypes(SizeUtils.getSizeList(sizeListString));
    }

    @NonNull
    public static Collection<RawFrameType> getFrameTypes(@NonNull List<Size> sizeList) {
        HashSet<RawFrameType> result = new HashSet<RawFrameType>();
        for (Size sz : sizeList) {
            result.add(sz.frameType);
        }
        return result;
    }

    @NonNull
    public static List<Size> getSizeListFromPreviewFormats(@Nullable String sizeListString, @Nullable PreviewFormat[] formats) {
        List<Object> result = null;
        PreviewFormat[] _formats = formats == null || formats.length == 0 ? new PreviewFormat[]{PreviewFormat.PREVIEW_FORMAT_H264, PreviewFormat.PREVIEW_FORMAT_MJPEG, PreviewFormat.PREVIEW_FORMAT_YUY2} : formats;
        int n = _formats.length;
        for (int i = 0; i < n && (_formats[i].getValue() < 0 || (result = SizeUtils.getSizeListFromPreviewFormat(sizeListString, _formats[i])) == null || result.isEmpty()); ++i) {
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    @NonNull
    public static List<Size> getSizeListFromPreviewFormat(@Nullable String sizeListString, PreviewFormat format) {
        List<Size> result = null;
        try {
            RawFrameType frameTypeRequired = SizeUtils.getFrameType(format);
            result = SizeUtils.getSizeList(sizeListString, frameTypeRequired);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null || result.isEmpty()) {
            if (format == PreviewFormat.PREVIEW_FORMAT_H264) {
                result = SizeUtils.getSizeList(sizeListString, RawFrameType.RAW_FRAME_FRAME_H264);
            } else if (format == PreviewFormat.PREVIEW_FORMAT_VP8) {
                result = SizeUtils.getSizeList(sizeListString, RawFrameType.RAW_FRAME_FRAME_VP8);
            }
        }
        return result;
    }

    @Nullable
    public static Size getVideoSize(@Nullable String sizeListString, RawFrameType frameType, int index) {
        if (!TextUtils.isEmpty((CharSequence)sizeListString)) {
            try {
                JSONObject json = new JSONObject(sizeListString);
                JSONArray formats = json.getJSONArray("formats");
                int format_nums = formats.length();
                for (int i = 0; i < format_nums; ++i) {
                    String[] sz;
                    JSONObject format = formats.getJSONObject(i);
                    if (!SizeUtils.matchType(format, frameType)) continue;
                    int _frameType = format.optInt("frame_type", RawFrameType.RAW_FRAME_UNKNOWN.getValue());
                    JSONArray size = format.getJSONArray("size");
                    int size_nums = size.length();
                    if (size_nums <= 0) continue;
                    if (index >= 0 && index < size_nums) {
                        sz = size.getString(index).split("x");
                        try {
                            return new Size(RawFrameType.from(_frameType), index, Integer.parseInt(sz[0]), Integer.parseInt(sz[1]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    sz = size.getString(0).split("x");
                    try {
                        return new Size(RawFrameType.from(_frameType), 0, Integer.parseInt(sz[0]), Integer.parseInt(sz[1]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (JSONException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        Log.w((String)TAG, (String)String.format("preview size not found:frameType=%d", frameType.getValue()));
        Stacktrace.print();
        return null;
    }

    @Nullable
    public static Size findSize(@Nullable String sizeListString, RawFrameType frameType, int width, int height) {
        Size result = null;
        if (!TextUtils.isEmpty((CharSequence)sizeListString)) {
            try {
                RawFrameType matchedFrameType;
                JSONObject format;
                JSONObject json = new JSONObject(sizeListString);
                JSONArray formats = json.getJSONArray("formats");
                int format_nums = formats.length();
                for (int i = 0; !(i >= format_nums || SizeUtils.matchType(format = formats.getJSONObject(i), frameType) && (result = SizeUtils.getSize(format, matchedFrameType = RawFrameType.from(format.optInt("frame_type", RawFrameType.RAW_FRAME_UNKNOWN.getValue())), width, height, false)) != null); ++i) {
                }
            }
            catch (JSONException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return result;
    }

    public static int findSizeIndex(@Nullable String sizeListString, RawFrameType frameType, int width, int height) {
        Size result = SizeUtils.findSize(sizeListString, frameType, width, height);
        return result != null ? result.index : -1;
    }

    @NonNull
    public static List<Size> getSizeList(@Nullable String sizeListString) {
        ArrayList<Size> result = new ArrayList<Size>();
        if (!TextUtils.isEmpty((CharSequence)sizeListString)) {
            try {
                JSONObject json = new JSONObject(sizeListString);
                JSONArray formats = json.getJSONArray("formats");
                int formatNums = formats.length();
                block5: for (int i = 0; i < formatNums; ++i) {
                    JSONObject format = formats.getJSONObject(i);
                    RawFrameType frameType = RawFrameType.from(format.optInt("frame_type", RawFrameType.RAW_FRAME_UNKNOWN.getValue()));
                    switch (frameType) {
                        case RAW_FRAME_UNCOMPRESSED_YUYV: 
                        case RAW_FRAME_MJPEG: 
                        case RAW_FRAME_H264: 
                        case RAW_FRAME_VP8: 
                        case RAW_FRAME_FRAME_H264: 
                        case RAW_FRAME_FRAME_VP8: {
                            SizeUtils.addSize(format, frameType, result, false);
                            continue block5;
                        }
                    }
                }
            }
            catch (JSONException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return result;
    }

    @NonNull
    public static List<Size> getSizeList(@Nullable String sizeListString, RawFrameType frameType) {
        ArrayList<Size> result = new ArrayList<Size>();
        if (!TextUtils.isEmpty((CharSequence)sizeListString)) {
            try {
                JSONObject json = new JSONObject(sizeListString);
                JSONArray formats = json.getJSONArray("formats");
                int formatNums = formats.length();
                for (int i = 0; i < formatNums; ++i) {
                    JSONObject format = formats.getJSONObject(i);
                    if (!SizeUtils.matchType(format, frameType)) continue;
                    RawFrameType matchedFrameType = RawFrameType.from(format.optInt("frame_type", RawFrameType.RAW_FRAME_UNKNOWN.getValue()));
                    SizeUtils.addSize(format, matchedFrameType, result, false);
                }
            }
            catch (JSONException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return result;
    }

    public static int findStillSizeIndex(@Nullable String sizeListString, int width, int height) {
        int result = -1;
        if (!TextUtils.isEmpty((CharSequence)sizeListString)) {
            try {
                JSONObject json = new JSONObject(sizeListString);
                JSONArray formats = json.getJSONArray("stills");
                int format_nums = formats.length();
                for (int i = 0; i < format_nums; ++i) {
                    Size sz = SizeUtils.getSize(formats.getJSONObject(i), RawFrameType.RAW_FRAME_STILL, width, height, true);
                    if (sz == null) continue;
                    result = sz.index;
                    break;
                }
            }
            catch (JSONException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return result;
    }

    @NonNull
    public static List<Size> getStillSizeList(@Nullable String sizeListString) {
        ArrayList<Size> result = new ArrayList<Size>();
        if (!TextUtils.isEmpty((CharSequence)sizeListString)) {
            try {
                JSONObject json = new JSONObject(sizeListString);
                JSONArray formats = json.getJSONArray("stills");
                int format_nums = formats.length();
                for (int i = 0; i < format_nums; ++i) {
                    SizeUtils.addSize(formats.getJSONObject(i), RawFrameType.RAW_FRAME_STILL, result, true);
                }
            }
            catch (JSONException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return result;
    }

    private static final boolean matchType(JSONObject format, RawFrameType frameTypeRequired) {
        RawFrameType frameType = RawFrameType.from(format.optInt("frame_type", RawFrameType.RAW_FRAME_UNKNOWN.getValue()));
        return frameTypeRequired != RawFrameType.RAW_FRAME_UNKNOWN && frameType == frameTypeRequired || frameTypeRequired == RawFrameType.RAW_FRAME_UNKNOWN && frameType != RawFrameType.RAW_FRAME_UNKNOWN;
    }

    private static final void addSize(JSONObject format, RawFrameType frameType, @NonNull List<Size> resultSizeList, boolean isStill) throws JSONException {
        JSONArray frameIntervals = format.getJSONArray("intervals");
        JSONArray size = format.getJSONArray("size");
        int sizeNums = size.length();
        for (int j = 0; j < sizeNums; ++j) {
            String[] sz = size.getString(j).split("x");
            try {
                if (sz == null || sz.length < 2) continue;
                resultSizeList.add(SizeUtils.createSize(frameType, j, Integer.parseInt(sz[0]), Integer.parseInt(sz[1]), frameIntervals, isStill));
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Nullable
    private static final Size getSize(JSONObject format, RawFrameType rawFrameType, int width, int height, boolean isStill) throws JSONException {
        JSONArray frameIntervals = format.optJSONArray("frameRate");
        JSONArray size = format.getJSONArray("size");
        int size_nums = size.length();
        for (int j = 0; j < size_nums; ++j) {
            String[] sz = size.getString(j).split("x");
            try {
                if (Integer.parseInt(sz[0]) != width || Integer.parseInt(sz[1]) != height) continue;
                return SizeUtils.createSize(rawFrameType, j, width, height, frameIntervals, isStill);
            }
            catch (Exception e) {
                break;
            }
        }
        return null;
    }

    @NonNull
    private static Size createSize(RawFrameType rawFrameType, int index, int width, int height, @Nullable JSONArray frameIntervals, boolean isStill) throws JSONException {
        Size result;
        Object _Frameintervals;
        Object object = _Frameintervals = frameIntervals != null ? frameIntervals.get(index) : null;
        if (_Frameintervals instanceof JSONArray) {
            JSONArray intervals = (JSONArray)_Frameintervals;
            int n = intervals.length();
            int[] intervals_array = new int[n];
            for (int k = 0; k < n; ++k) {
                intervals_array[k] = intervals.getInt(k);
            }
            result = new Size(rawFrameType, index, width, height, intervals_array);
        } else if (_Frameintervals instanceof JSONObject) {
            JSONObject intervals = (JSONObject)_Frameintervals;
            int minFrameInterval = intervals.optInt("minFrameInterval", 333333);
            int maxFrameInterval = intervals.optInt("maxFrameInterval", 10000000);
            int frameIntervalStep = intervals.optInt("frameIntervalStep", 0);
            result = new Size(rawFrameType, index, width, height, minFrameInterval, maxFrameInterval, frameIntervalStep);
        } else {
            result = isStill ? new Size(index, width, height) : new Size(rawFrameType, index, width, height);
        }
        return result;
    }
}

