/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.AbsSavedState;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.common.R;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.view.IViewTransformer;
import com.serenegiant.view.MeasureSpecDelegater;
import com.serenegiant.view.ViewTransformDelegater;
import com.serenegiant.widget.IScaledView;
import com.serenegiant.widget.TransformTextureView;

public class ZoomAspectScaledTextureView2
extends TransformTextureView
implements IMirror,
TextureView.SurfaceTextureListener,
ViewTransformDelegater.ViewTransformListener,
IScaledView {
    private static final boolean DEBUG = false;
    private static final String TAG = ZoomAspectScaledTextureView2.class.getSimpleName();
    private volatile boolean mHasSurface;
    private TextureView.SurfaceTextureListener mListener;
    private int mMirrorMode = 0;
    private boolean mNeedResizeToKeepAspect;
    private double mRequestedAspect = -1.0;

    public ZoomAspectScaledTextureView2(Context context) {
        this(context, null, 0);
    }

    public ZoomAspectScaledTextureView2(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZoomAspectScaledTextureView2(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int handleTouchEvent;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IScaledView, defStyleAttr, 0);
        double requestedAspect = -1.0;
        int scaleMode = 0;
        try {
            requestedAspect = a.getFloat(R.styleable.IScaledView_aspect_ratio, -1.0f);
            scaleMode = a.getInt(R.styleable.IScaledView_scale_mode, 0);
            this.mNeedResizeToKeepAspect = a.getBoolean(R.styleable.IScaledView_resize_to_keep_aspect, true);
        }
        catch (UnsupportedOperationException e) {
            Log.d((String)TAG, (String)TAG, (Throwable)e);
        }
        finally {
            a.recycle();
        }
        a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ZoomAspectScaledTextureView, defStyleAttr, 0);
        try {
            handleTouchEvent = a.getInteger(R.styleable.ZoomAspectScaledTextureView_handle_touch_event, 7);
        }
        catch (UnsupportedOperationException e) {
            Log.d((String)TAG, (String)TAG, (Throwable)e);
            boolean b = a.getBoolean(R.styleable.ZoomAspectScaledTextureView_handle_touch_event, true);
            handleTouchEvent = b ? 7 : 0;
        }
        finally {
            a.recycle();
        }
        super.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        ViewTransformDelegater delegater = new ViewTransformDelegater((View)this){

            @Override
            protected void setTransform(@NonNull View view, @Nullable Matrix transform) {
                ZoomAspectScaledTextureView2.this.superSetTransform(transform);
            }

            @Override
            @NonNull
            protected Matrix getTransform(@NonNull View view, @Nullable Matrix transform) {
                return ZoomAspectScaledTextureView2.this.superGetTransform(transform);
            }

            @Override
            public RectF getContentBounds() {
                return ZoomAspectScaledTextureView2.this.getContentBounds();
            }

            @Override
            public void onInit() {
            }
        };
        delegater.setScaleMode(scaleMode);
        delegater.setEnableHandleTouchEvent(handleTouchEvent);
        this.setViewTransformer(delegater);
        this.setAspectRatio(requestedAspect);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecDelegater.MeasureSpec spec = MeasureSpecDelegater.onMeasure((View)this, this.getAspectRatio(), this.getScaleMode(), this.mNeedResizeToKeepAspect, widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(spec.widthMeasureSpec, spec.heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.init();
    }

    protected void onDetachedFromWindow() {
        IViewTransformer transformer = this.getViewTransformer();
        if (transformer instanceof ViewTransformDelegater) {
            ((ViewTransformDelegater)transformer).clearPendingTasks();
        }
        super.onDetachedFromWindow();
    }

    protected Parcelable onSaveInstanceState() {
        IViewTransformer transformer = this.getViewTransformer();
        if (transformer instanceof ViewTransformDelegater) {
            return ((ViewTransformDelegater)transformer).onSaveInstanceState(super.onSaveInstanceState());
        }
        return super.onSaveInstanceState();
    }

    protected void onRestoreInstanceState(Parcelable state) {
        IViewTransformer transformer;
        super.onRestoreInstanceState(state);
        if (state instanceof AbsSavedState) {
            super.onRestoreInstanceState(((AbsSavedState)state).getSuperState());
        }
        if ((transformer = this.getViewTransformer()) instanceof ViewTransformDelegater) {
            ((ViewTransformDelegater)transformer).onRestoreInstanceState(state);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        IViewTransformer transformer = this.getViewTransformer();
        if (transformer instanceof ViewTransformDelegater) {
            ((ViewTransformDelegater)transformer).onConfigurationChanged(newConfig);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.handleOnTouchEvent(event)) {
            return true;
        }
        IViewTransformer transformer = this.getViewTransformer();
        if (transformer instanceof ViewTransformDelegater && ((ViewTransformDelegater)transformer).onTouchEvent(event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    public boolean hasSurface() {
        return this.mHasSurface;
    }

    public void onSurfaceTextureAvailable(@NonNull SurfaceTexture surface, int width, int height) {
        this.mHasSurface = true;
        this.setMirror(0);
        this.init();
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    public void onSurfaceTextureSizeChanged(@NonNull SurfaceTexture surface, int width, int height) {
        this.applyMirrorMode();
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureSizeChanged(surface, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(@NonNull SurfaceTexture surface) {
        this.mHasSurface = false;
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureDestroyed(surface);
        }
        return false;
    }

    public void onSurfaceTextureUpdated(@NonNull SurfaceTexture surface) {
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureUpdated(surface);
        }
    }

    @Override
    public void setMirror(int mirror) {
        if (this.mMirrorMode != mirror) {
            this.mMirrorMode = mirror;
            this.applyMirrorMode();
        }
    }

    @Override
    public int getMirror() {
        return this.mMirrorMode;
    }

    @Override
    public void onStateChanged(@NonNull View view, int newState) {
    }

    @Override
    public void onTransformed(@NonNull View view, @NonNull Matrix transform) {
    }

    public void setEnableHandleTouchEvent(int enabled) {
        IViewTransformer transformer = this.getViewTransformer();
        if (transformer instanceof ViewTransformDelegater) {
            ((ViewTransformDelegater)transformer).setEnableHandleTouchEvent(enabled);
        }
    }

    public int getEnableHandleTouchEvent() {
        IViewTransformer transformer = this.getViewTransformer();
        if (transformer instanceof ViewTransformDelegater) {
            return ((ViewTransformDelegater)transformer).getEnableHandleTouchEvent();
        }
        return 7;
    }

    protected void init() {
        IViewTransformer transformer = this.getViewTransformer();
        if (transformer instanceof ViewTransformDelegater) {
            ((ViewTransformDelegater)transformer).init();
        }
    }

    protected boolean handleOnTouchEvent(MotionEvent event) {
        return false;
    }

    private void applyMirrorMode() {
        switch (this.mMirrorMode) {
            case 1: {
                this.setScaleX(-1.0f);
                this.setScaleY(1.0f);
                break;
            }
            case 2: {
                this.setScaleX(1.0f);
                this.setScaleY(-1.0f);
                break;
            }
            case 3: {
                this.setScaleX(-1.0f);
                this.setScaleY(-1.0f);
                break;
            }
            default: {
                this.setScaleX(1.0f);
                this.setScaleY(1.0f);
            }
        }
    }

    protected RectF getContentBounds() {
        float viewHeight = this.getHeight();
        return new RectF(0.0f, 0.0f, this.mRequestedAspect > 0.0 ? (float)(this.mRequestedAspect * (double)viewHeight) : (float)this.getWidth(), viewHeight);
    }

    @Override
    public void setAspectRatio(double aspectRatio) {
        if (this.mRequestedAspect != aspectRatio) {
            this.mRequestedAspect = aspectRatio;
            this.requestLayout();
        }
    }

    @Override
    public void setAspectRatio(int width, int height) {
        this.setAspectRatio((double)width / (double)height);
    }

    @Override
    public double getAspectRatio() {
        return this.mRequestedAspect;
    }

    @Override
    public void setNeedResizeToKeepAspect(boolean keepAspect) {
        if (this.mNeedResizeToKeepAspect != keepAspect) {
            this.mNeedResizeToKeepAspect = keepAspect;
            this.requestLayout();
        }
    }

    @Override
    public void setScaleMode(int scaleMode) {
        IViewTransformer transformer = this.getViewTransformer();
        if (transformer instanceof ViewTransformDelegater) {
            ((ViewTransformDelegater)transformer).setScaleMode(scaleMode);
        }
    }

    @Override
    public int getScaleMode() {
        IViewTransformer transformer = this.getViewTransformer();
        if (transformer instanceof ViewTransformDelegater) {
            return ((ViewTransformDelegater)transformer).getScaleMode();
        }
        return 1;
    }
}

