/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view;

import android.os.Build;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import com.serenegiant.utils.BitsHelper;
import java.util.Locale;

public class MotionEventUtils {
    public static final int BUTTON_PRIMARY = 1 | (Build.VERSION.SDK_INT >= 23 ? 32 : 0);
    public static final int BUTTON_SECONDARY = 2 | (Build.VERSION.SDK_INT >= 23 ? 64 : 0);
    private static final String[] BUTTON_SYMBOLIC_NAMES = new String[]{"BUTTON_PRIMARY", "BUTTON_SECONDARY", "BUTTON_TERTIARY", "BUTTON_BACK", "BUTTON_FORWARD", "BUTTON_STYLUS_PRIMARY", "BUTTON_STYLUS_SECONDARY", "0x00000080", "0x00000100", "0x00000200", "0x00000400", "0x00000800", "0x00001000", "0x00002000", "0x00004000", "0x00008000", "0x00010000", "0x00020000", "0x00040000", "0x00080000", "0x00100000", "0x00200000", "0x00400000", "0x00800000", "0x01000000", "0x02000000", "0x04000000", "0x08000000", "0x10000000", "0x20000000", "0x40000000", "0x80000000"};

    private MotionEventUtils() {
    }

    public static String getActionString(@NonNull MotionEvent event) {
        if (Build.VERSION.SDK_INT >= 19) {
            return MotionEvent.actionToString((int)event.getActionMasked());
        }
        int action = event.getActionMasked();
        switch (action) {
            case 0: {
                return "ACTION_DOWN";
            }
            case 1: {
                return "ACTION_UP";
            }
            case 3: {
                return "ACTION_CANCEL";
            }
            case 4: {
                return "ACTION_OUTSIDE";
            }
            case 2: {
                return "ACTION_MOVE";
            }
            case 7: {
                return "ACTION_HOVER_MOVE";
            }
            case 8: {
                return "ACTION_SCROLL";
            }
            case 9: {
                return "ACTION_HOVER_ENTER";
            }
            case 10: {
                return "ACTION_HOVER_EXIT";
            }
            case 11: {
                return "ACTION_BUTTON_PRESS";
            }
            case 12: {
                return "ACTION_BUTTON_RELEASE";
            }
        }
        int index = (action & 0xFF00) >> 8;
        switch (action & 0xFF) {
            case 5: {
                return "ACTION_POINTER_DOWN(" + index + ")";
            }
            case 6: {
                return "ACTION_POINTER_UP(" + index + ")";
            }
        }
        return Integer.toString(action);
    }

    public static String getButtonStateString(@NonNull MotionEvent event) {
        int buttonState = event.getButtonState();
        if (buttonState == 0) {
            return "[]";
        }
        StringBuilder result = new StringBuilder("[");
        int i = 0;
        while (buttonState != 0) {
            boolean isSet = (buttonState & 1) != 0;
            buttonState >>>= 1;
            if (isSet) {
                String name = BUTTON_SYMBOLIC_NAMES[i];
                if (result.length() == 1) {
                    result.append(name);
                    if (buttonState == 0) {
                        break;
                    }
                } else {
                    result.append('|');
                    result.append(name);
                }
            }
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public static boolean isPressed(@NonNull MotionEvent event, int buttons) {
        return MotionEventUtils.isPressed(event.getButtonState(), buttons);
    }

    public static boolean isPressed(int buttonState, int buttons) {
        return (buttonState & buttons) == buttons;
    }

    public static boolean isPressedAny(@NonNull MotionEvent event, int buttons) {
        return MotionEventUtils.isPressedAny(event.getButtonState(), buttons);
    }

    public static boolean isPressedAny(int buttonState, int buttons) {
        return (buttonState & buttons) != 0;
    }

    public static int getNumPressed(@NonNull MotionEvent event) {
        return MotionEventUtils.getNumPressed(event.getButtonState());
    }

    public static int getNumPressed(int buttonState) {
        return BitsHelper.countBits(buttonState);
    }

    public static boolean isFromSource(@NonNull MotionEvent event, int sourceClass) {
        return (event.getSource() & sourceClass) == sourceClass;
    }

    public static String debugMotionEventString(@NonNull MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        return String.format(Locale.US, "%s(%f,%f):,down=%d,event=%d,src=0x%08x", MotionEventUtils.getActionString(event), Float.valueOf(x), Float.valueOf(y), event.getDownTime(), event.getEventTime(), event.getSource());
    }
}

