/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view;

import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

public class ChainedTouchDelegate
extends TouchDelegate {
    @Nullable
    private final TouchDelegate mParentTouchDelegate;

    public ChainedTouchDelegate(@NonNull View parent, @NonNull View target, @NonNull Rect bounds) {
        super(bounds, target);
        this.mParentTouchDelegate = parent.getTouchDelegate();
        parent.setTouchDelegate((TouchDelegate)this);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (!result && this.mParentTouchDelegate != null) {
            result = this.mParentTouchDelegate.onTouchEvent(event);
        }
        return result;
    }

    @RequiresApi(api=29)
    public boolean onTouchExplorationHoverEvent(@NonNull MotionEvent event) {
        boolean result = super.onTouchExplorationHoverEvent(event);
        if (!result && this.mParentTouchDelegate != null) {
            result = this.mParentTouchDelegate.onTouchExplorationHoverEvent(event);
        }
        return result;
    }
}

