/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.annotation.TargetApi;
import androidx.annotation.NonNull;

@TargetApi(value=19)
public class RefCountedAutoCloseable<T extends AutoCloseable>
implements AutoCloseable {
    private T mObject;
    private long mRefCount = 0L;

    public RefCountedAutoCloseable(@NonNull T object) {
        this.mObject = object;
    }

    public synchronized T getAndRetain() {
        if (this.mRefCount < 0L) {
            return null;
        }
        ++this.mRefCount;
        return this.mObject;
    }

    public synchronized T get() {
        return this.mObject;
    }

    @Override
    public synchronized void close() {
        if (this.mRefCount >= 0L) {
            --this.mRefCount;
            if (this.mRefCount < 0L) {
                try {
                    this.mObject.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.mObject = null;
                }
            }
        }
    }
}

