/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.annotation.UiThread;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import com.serenegiant.common.R;
import com.serenegiant.utils.TypedArrayUtils;

public final class SubTitlePreferenceV7
extends Preference {
    private static final boolean DEBUG = false;
    private static final String TAG = SubTitlePreferenceV7.class.getSimpleName();
    @LayoutRes
    private final int mSubTitleLayoutId;
    @IdRes
    private final int mSubTitleTvId;
    private CharSequence mSubTitle;
    private TextView mSubTitleTextView;
    private int mSubTitleVisibility;

    public SubTitlePreferenceV7(Context context) {
        this(context, null);
    }

    public SubTitlePreferenceV7(Context context, AttributeSet attrs) {
        this(context, attrs, TypedArrayUtils.getAttr(context, R.attr.preferenceStyle, 16842894));
    }

    public SubTitlePreferenceV7(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray attribs = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SubTitlePreference, defStyle, 0);
        this.mSubTitleLayoutId = attribs.getResourceId(R.styleable.SubTitlePreference_subtitle_layout, R.layout.subtitle);
        this.mSubTitleTvId = attribs.getResourceId(R.styleable.SubTitlePreference_subtitle_id, R.id.subtitle);
        this.mSubTitle = attribs.getString(R.styleable.SubTitlePreference_subtitle);
        attribs.recycle();
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        ViewGroup group;
        super.onBindViewHolder(holder);
        if (this.mSubTitleLayoutId == 0) {
            return;
        }
        RelativeLayout parent = null;
        if (holder.itemView instanceof ViewGroup) {
            group = (ViewGroup)holder.itemView;
            for (int i = group.getChildCount() - 1; i >= 0; --i) {
                View v = group.getChildAt(i);
                if (!(v instanceof RelativeLayout)) continue;
                parent = (RelativeLayout)v;
                break;
            }
        } else {
            group = null;
        }
        if (parent == null) {
            return;
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        View extraview = layoutInflater.inflate(this.mSubTitleLayoutId, group, false);
        if (extraview != null) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
            params.addRule(3, 16908310);
            parent.addView(extraview, (ViewGroup.LayoutParams)params);
            View summary = parent.findViewById(0x1020010);
            if (summary != null) {
                int id2 = extraview.getId();
                if (id2 == 0) {
                    id2 = this.mSubTitleTvId;
                }
                params = (RelativeLayout.LayoutParams)summary.getLayoutParams();
                params.addRule(3, id2);
                summary.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            this.mSubTitleTextView = (TextView)extraview.findViewById(this.mSubTitleTvId);
            this.setSubtitle(this.mSubTitle);
        }
    }

    @UiThread
    public void setSubtitle(@StringRes int subtitleId) {
        if (this.mSubTitleTextView != null) {
            this.mSubTitleTextView.setText(subtitleId);
            this.mSubTitle = this.mSubTitleTextView.getText();
            this.mSubTitleTextView.setVisibility(TextUtils.isEmpty((CharSequence)this.mSubTitle) ? 8 : this.mSubTitleVisibility);
        }
    }

    @UiThread
    public void setSubtitle(CharSequence subtitle) {
        this.mSubTitle = subtitle;
        if (this.mSubTitleTextView != null) {
            this.mSubTitleTextView.setText(subtitle);
            this.mSubTitleTextView.setVisibility(TextUtils.isEmpty((CharSequence)this.mSubTitle) ? 8 : this.mSubTitleVisibility);
        }
    }

    @UiThread
    public void setSubTitleVisibility(int visibility) {
        this.mSubTitleVisibility = visibility;
        if (this.mSubTitleTextView != null) {
            this.mSubTitleTextView.setVisibility(visibility);
        }
    }
}

