/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.serenegiant.net.WiFiP2pListener;
import com.serenegiant.system.ContextUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class WiFiP2pHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = WiFiP2pHelper.class.getSimpleName();
    private static WiFiP2pHelper sWiFiP2PHelper;
    @NonNull
    private final Set<WiFiP2pListener> mListeners = new CopyOnWriteArraySet<WiFiP2pListener>();
    @NonNull
    private final List<WifiP2pDevice> mAvailableDevices = new ArrayList<WifiP2pDevice>();
    @NonNull
    private final WeakReference<Context> mWeakContext;
    @NonNull
    private final WifiP2pManager mWifiP2pManager;
    @Nullable
    private WifiP2pManager.Channel mChannel;
    @Nullable
    private WiFiDirectBroadcastReceiver mReceiver;
    private boolean mIsWifiP2pEnabled;
    private WifiP2pDevice mWifiP2pDevice;
    private int mRetryCount;
    private final WifiP2pManager.ChannelListener mChannelListener = new WifiP2pManager.ChannelListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChannelDisconnected() {
            WiFiP2pHelper.this.setIsWifiP2pEnabled(false);
            WiFiP2pHelper.this.resetData();
            WiFiP2pHelper wiFiP2pHelper = WiFiP2pHelper.this;
            synchronized (wiFiP2pHelper) {
                WiFiP2pHelper.this.mChannel = null;
            }
            if (WiFiP2pHelper.this.mRetryCount == 0) {
                WiFiP2pHelper.this.mRetryCount++;
                Context context = (Context)WiFiP2pHelper.this.mWeakContext.get();
                if (context != null & WiFiP2pHelper.this.mReceiver == null) {
                    WiFiP2pHelper.this.mChannel = WiFiP2pHelper.this.mWifiP2pManager.initialize(context, context.getMainLooper(), WiFiP2pHelper.this.mChannelListener);
                }
            }
        }
    };
    private final WifiP2pManager.PeerListListener mPeerListListener = new WifiP2pManager.PeerListListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPeersAvailable(WifiP2pDeviceList peers) {
            Collection devices = peers.getDeviceList();
            List list = WiFiP2pHelper.this.mAvailableDevices;
            synchronized (list) {
                WiFiP2pHelper.this.mAvailableDevices.clear();
                WiFiP2pHelper.this.mAvailableDevices.addAll(devices);
            }
            WiFiP2pHelper.this.callOnUpdateDevices(WiFiP2pHelper.this.mAvailableDevices);
        }
    };
    private final WifiP2pManager.ConnectionInfoListener mConnectionInfoListener = new WifiP2pManager.ConnectionInfoListener(){

        public void onConnectionInfoAvailable(WifiP2pInfo info) {
            if (info != null) {
                WiFiP2pHelper.this.callOnConnect(info);
            }
        }
    };

    public static synchronized WiFiP2pHelper getInstance(@NonNull Context context) {
        if (sWiFiP2PHelper == null || WiFiP2pHelper.sWiFiP2PHelper.mWeakContext.get() == null) {
            sWiFiP2PHelper = new WiFiP2pHelper(context);
        }
        return sWiFiP2PHelper;
    }

    public static synchronized void release() {
        sWiFiP2PHelper = null;
    }

    private WiFiP2pHelper(@NonNull Context context) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mWifiP2pManager = ContextUtils.requireSystemService(context, WifiP2pManager.class);
    }

    public synchronized void register() {
        Context context = (Context)this.mWeakContext.get();
        if (context != null & this.mReceiver == null) {
            this.mChannel = this.mWifiP2pManager.initialize(context, context.getMainLooper(), this.mChannelListener);
            this.mReceiver = new WiFiDirectBroadcastReceiver(this.mWifiP2pManager, this.mChannel, this);
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.wifi.p2p.STATE_CHANGED");
            intentFilter.addAction("android.net.wifi.p2p.PEERS_CHANGED");
            intentFilter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
            intentFilter.addAction("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
            context.registerReceiver((BroadcastReceiver)this.mReceiver, intentFilter);
        }
    }

    public synchronized void unregister() {
        this.mIsWifiP2pEnabled = false;
        this.mRetryCount = 0;
        this.internalDisconnect(null);
        if (this.mReceiver != null) {
            Context context = (Context)this.mWeakContext.get();
            try {
                context.unregisterReceiver((BroadcastReceiver)this.mReceiver);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mReceiver = null;
        }
    }

    public void add(@NonNull WiFiP2pListener listener) {
        this.mListeners.add(listener);
    }

    public void remove(@NonNull WiFiP2pListener listener) {
        this.mListeners.remove(listener);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public synchronized void startDiscovery() throws IllegalStateException {
        if (this.mChannel == null) {
            throw new IllegalStateException("not registered");
        }
        this.mWifiP2pManager.discoverPeers(this.mChannel, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
            }

            public void onFailure(int reason) {
                WiFiP2pHelper.this.callOnError(new RuntimeException("failed to start discovery, reason=" + reason));
            }
        });
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public void connect(@NonNull String remoteMacAddress) {
        WifiP2pConfig config = new WifiP2pConfig();
        config.deviceAddress = remoteMacAddress;
        config.wps.setup = 0;
        this.connect(config);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public void connect(@NonNull WifiP2pDevice device) {
        WifiP2pConfig config = new WifiP2pConfig();
        config.deviceAddress = device.deviceAddress;
        config.wps.setup = 0;
        this.connect(config);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public void connect(@NonNull WifiP2pConfig config) throws IllegalStateException {
        if (this.mChannel == null) {
            throw new IllegalStateException("not registered");
        }
        this.mWifiP2pManager.connect(this.mChannel, config, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
            }

            public void onFailure(int reason) {
                WiFiP2pHelper.this.callOnError(new RuntimeException("failed to connect, reason=" + reason));
            }
        });
    }

    protected void internalDisconnect(WifiP2pManager.ActionListener listener) {
        if (this.mWifiP2pManager != null) {
            if (this.mWifiP2pDevice == null || this.mWifiP2pDevice.status == 0) {
                if (this.mChannel != null) {
                    this.mWifiP2pManager.removeGroup(this.mChannel, listener);
                }
            } else if (this.mWifiP2pDevice.status == 3 || this.mWifiP2pDevice.status == 1) {
                this.mWifiP2pManager.cancelConnect(this.mChannel, listener);
            }
        }
    }

    public synchronized void disconnect() {
        this.internalDisconnect(new WifiP2pManager.ActionListener(){

            public void onSuccess() {
            }

            public void onFailure(int reason) {
                WiFiP2pHelper.this.callOnError(new RuntimeException("failed to disconnect, reason=" + reason));
            }
        });
    }

    public synchronized boolean isWiFiP2pEnabled() {
        return this.mChannel != null && this.mIsWifiP2pEnabled;
    }

    private synchronized void setIsWifiP2pEnabled(boolean enabled) {
        this.mIsWifiP2pEnabled = enabled;
        this.callOnStateChanged(enabled);
    }

    private synchronized void resetData() {
        if (this.isConnectedOrConnecting()) {
            this.callOnDisconnect();
        }
    }

    private synchronized void updateDevice(WifiP2pDevice device) {
        this.mWifiP2pDevice = device;
    }

    public synchronized boolean isConnected() {
        return this.mWifiP2pDevice != null && this.mWifiP2pDevice.status == 0;
    }

    public synchronized boolean isConnectedOrConnecting() {
        return this.mWifiP2pDevice != null && (this.mWifiP2pDevice.status == 0 || this.mWifiP2pDevice.status == 1);
    }

    protected void callOnStateChanged(boolean enabled) {
        for (WiFiP2pListener listener : this.mListeners) {
            try {
                listener.onStateChanged(enabled);
            }
            catch (Exception e1) {
                Log.w((String)TAG, (Throwable)e1);
                this.mListeners.remove(listener);
            }
        }
    }

    protected void callOnUpdateDevices(@NonNull List<WifiP2pDevice> devices) {
        for (WiFiP2pListener listener : this.mListeners) {
            try {
                listener.onUpdateDevices(devices);
            }
            catch (Exception e1) {
                Log.w((String)TAG, (Throwable)e1);
                this.mListeners.remove(listener);
            }
        }
    }

    protected void callOnConnect(@NonNull WifiP2pInfo info) {
        for (WiFiP2pListener listener : this.mListeners) {
            try {
                listener.onConnect(info);
            }
            catch (Exception e1) {
                Log.w((String)TAG, (Throwable)e1);
                this.mListeners.remove(listener);
            }
        }
    }

    protected void callOnDisconnect() {
        for (WiFiP2pListener listener : this.mListeners) {
            try {
                listener.onDisconnect();
            }
            catch (Exception e1) {
                Log.w((String)TAG, (Throwable)e1);
                this.mListeners.remove(listener);
            }
        }
    }

    protected void callOnError(Exception e) {
        for (WiFiP2pListener listener : this.mListeners) {
            try {
                listener.onError(e);
            }
            catch (Exception e1) {
                Log.w((String)TAG, (Throwable)e1);
                this.mListeners.remove(listener);
            }
        }
    }

    private static class WiFiDirectBroadcastReceiver
    extends BroadcastReceiver {
        @NonNull
        private final WifiP2pManager mManager;
        @NonNull
        private final WifiP2pManager.Channel mChannel;
        @NonNull
        private final WiFiP2pHelper mParent;

        public WiFiDirectBroadcastReceiver(@NonNull WifiP2pManager manager, @NonNull WifiP2pManager.Channel channel, @NonNull WiFiP2pHelper parent) {
            this.mManager = manager;
            this.mChannel = channel;
            this.mParent = parent;
        }

        @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
        public void onReceive(Context context, Intent intent) {
            block17: {
                String action;
                String string2 = action = intent != null ? intent.getAction() : null;
                if ("android.net.wifi.p2p.STATE_CHANGED".equals(action)) {
                    try {
                        int state = intent.getIntExtra("wifi_p2p_state", -1);
                        if (state == 2) {
                            this.mParent.setIsWifiP2pEnabled(true);
                            break block17;
                        }
                        this.mParent.setIsWifiP2pEnabled(false);
                        this.mParent.resetData();
                    }
                    catch (Exception e) {
                        this.mParent.callOnError(e);
                    }
                } else if ("android.net.wifi.p2p.PEERS_CHANGED".equals(action)) {
                    try {
                        this.mManager.requestPeers(this.mChannel, this.mParent.mPeerListListener);
                    }
                    catch (Exception e) {
                        this.mParent.callOnError(e);
                    }
                } else if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(action)) {
                    try {
                        NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                        if (networkInfo.isConnected()) {
                            this.mManager.requestConnectionInfo(this.mChannel, this.mParent.mConnectionInfoListener);
                            break block17;
                        }
                        this.mParent.resetData();
                    }
                    catch (Exception e) {
                        this.mParent.callOnError(e);
                    }
                } else if ("android.net.wifi.p2p.THIS_DEVICE_CHANGED".equals(action)) {
                    try {
                        WifiP2pDevice device = (WifiP2pDevice)intent.getParcelableExtra("wifiP2pDevice");
                        this.mParent.updateDevice(device);
                    }
                    catch (Exception e) {
                        this.mParent.callOnError(e);
                    }
                }
            }
        }
    }
}

