/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.provider.MediaStore;
import android.util.Log;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LruCache;
import com.serenegiant.graphics.BitmapHelper;
import com.serenegiant.io.DiskLruCache;
import com.serenegiant.mediastore.MediaInfo;
import com.serenegiant.system.ContextUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

public class ThumbnailCache {
    private static final boolean DEBUG = false;
    private static final String TAG = ThumbnailCache.class.getSimpleName();
    private static final int DISK_CACHE_SIZE = 0xA00000;
    private static final String DISK_CACHE_SUBDIR = ".thumbnailCache";
    private static final int DISK_CACHE_INDEX = 0;
    private static final Object sSync = new Object();
    private static final int CACHE_RATE = 8;
    private static LruCache<String, Bitmap> sThumbnailCache;
    private static int sMaxDiskCacheBytes;
    @Nullable
    private static DiskLruCache sDiskLruCache;
    private static int sCacheSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareThumbnailCache(@NonNull Context context, int maxDiskCacheBytes) {
        Object object = sSync;
        synchronized (object) {
            if (sThumbnailCache == null || sMaxDiskCacheBytes != maxDiskCacheBytes) {
                sMaxDiskCacheBytes = maxDiskCacheBytes;
                if (sMaxDiskCacheBytes <= 0) {
                    sMaxDiskCacheBytes = 0xA00000;
                }
                if (sThumbnailCache != null) {
                    sThumbnailCache.evictAll();
                }
                if (sDiskLruCache != null && !sDiskLruCache.isClosed()) {
                    try {
                        sDiskLruCache.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                int memClass = ContextUtils.requireSystemService(context, ActivityManager.class).getMemoryClass();
                sCacheSize = 0x100000 * memClass / 8;
                sThumbnailCache = new LruCache<String, Bitmap>(sCacheSize){

                    protected int sizeOf(@NonNull String key, @NonNull Bitmap bitmap) {
                        return bitmap.getRowBytes() * bitmap.getHeight();
                    }
                };
                try {
                    File cacheDir = ThumbnailCache.getDiskCacheDir(context);
                    if (!cacheDir.exists()) {
                        cacheDir.mkdirs();
                    }
                    if (!cacheDir.canWrite()) {
                        Log.w((String)TAG, (String)"unable to write to cache dir!!");
                    }
                    sDiskLruCache = DiskLruCache.open(cacheDir, 374, 1, sMaxDiskCacheBytes);
                }
                catch (IOException e) {
                    sDiskLruCache = null;
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }
    }

    private static File getDiskCacheDir(@NonNull Context context) throws IOException {
        File cacheDir = context.getExternalCacheDir();
        cacheDir.mkdirs();
        if (cacheDir == null || !cacheDir.canWrite()) {
            cacheDir = context.getCacheDir();
            cacheDir.mkdirs();
        }
        if (cacheDir == null || !cacheDir.canWrite()) {
            throw new IOException("can't write cache dir");
        }
        cacheDir = new File(cacheDir, DISK_CACHE_SUBDIR);
        cacheDir.mkdirs();
        return cacheDir;
    }

    public ThumbnailCache(@NonNull Context context) {
        ThumbnailCache.prepareThumbnailCache(context, 0xA00000);
    }

    public ThumbnailCache(@NonNull Context context, int maxDiskCacheBytes) {
        ThumbnailCache.prepareThumbnailCache(context, maxDiskCacheBytes);
    }

    protected void finalize() throws Throwable {
        try {
            this.trim();
        }
        finally {
            super.finalize();
        }
    }

    @Nullable
    public Bitmap get(long id2) {
        return this.get(ThumbnailCache.getKey(id2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Bitmap get(@NonNull String key) {
        Bitmap result;
        Object object = sSync;
        synchronized (object) {
            result = (Bitmap)sThumbnailCache.get((Object)key);
            if (result == null && sDiskLruCache != null) {
                InputStream in = null;
                try {
                    DiskLruCache.Snapshot snapshot = sDiskLruCache.get(key);
                    if (snapshot != null && (in = snapshot.getInputStream(0)) != null) {
                        FileDescriptor fd = ((FileInputStream)in).getFD();
                        result = BitmapHelper.asBitmap(fd, Integer.MAX_VALUE, Integer.MAX_VALUE);
                    }
                }
                catch (IOException e) {
                    try {
                        sDiskLruCache.remove(key);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (result != null) {
                    sThumbnailCache.put((Object)key, (Object)result);
                }
            }
        }
        return result;
    }

    public void put(long id2, @NonNull Bitmap thumbnail, boolean shouldOverride) {
        this.put(ThumbnailCache.getKey(id2), thumbnail, shouldOverride);
    }

    @Deprecated
    public void put(@NonNull String key, @NonNull Bitmap bitmap) {
        this.put(key, bitmap, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@NonNull String key, @NonNull Bitmap bitmap, boolean shouldOverride) {
        Object object = sSync;
        synchronized (object) {
            Bitmap cached = (Bitmap)sThumbnailCache.get((Object)key);
            if (cached == null || shouldOverride) {
                sThumbnailCache.put((Object)key, (Object)bitmap);
            }
            if (sDiskLruCache != null) {
                OutputStream out = null;
                try {
                    DiskLruCache.Editor editor;
                    if ((!sDiskLruCache.contains(key) || shouldOverride) && (editor = sDiskLruCache.edit(key)) != null) {
                        out = editor.newOutputStream(0);
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, out);
                        editor.commit();
                        out.close();
                    }
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = sSync;
        synchronized (object) {
            sThumbnailCache.evictAll();
            if (sDiskLruCache != null) {
                try {
                    sDiskLruCache.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim() {
        Object object = sSync;
        synchronized (object) {
            sThumbnailCache.trimToSize(sCacheSize);
            if (sDiskLruCache != null) {
                try {
                    sDiskLruCache.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        Object object = sSync;
        synchronized (object) {
            sThumbnailCache.remove((Object)key);
            if (sDiskLruCache != null) {
                try {
                    sDiskLruCache.remove(key);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @NonNull
    public Bitmap getThumbnail(@NonNull ContentResolver cr, @NonNull MediaInfo info, int requestWidth, int requestHeight) throws FileNotFoundException, IOException {
        Bitmap result;
        if (Build.VERSION.SDK_INT >= 29) {
            return cr.loadThumbnail(info.getUri(), new Size(requestWidth, requestHeight), null);
        }
        if (info.mediaType == 1) {
            result = requestWidth <= 0 || requestHeight <= 0 ? BitmapHelper.asBitmap(cr, info.getUri(), requestWidth, requestHeight) : this.getImageThumbnail(cr, info.id, requestWidth, requestHeight);
        } else if (info.mediaType == 3) {
            result = this.getVideoThumbnail(cr, info.id, requestWidth, requestHeight);
        } else {
            throw new UnsupportedOperationException("unexpected mediaType");
        }
        if (result == null) {
            throw new IOException("failed to load thumbnail," + info);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Bitmap getImageThumbnail(@NonNull ContentResolver cr, long id2, int requestWidth, int requestHeight) throws FileNotFoundException, IOException {
        Bitmap result;
        String key = ThumbnailCache.getKey(id2);
        Object object = sSync;
        synchronized (object) {
            result = this.get(key);
            if (result == null) {
                if (requestWidth <= 0 || requestHeight <= 0) {
                    result = BitmapHelper.asBitmap(cr, id2, requestWidth, requestHeight);
                } else {
                    int kind = 3;
                    if (requestWidth > 96 || requestHeight > 96 || requestWidth * requestHeight > 16384) {
                        kind = 1;
                    }
                    try {
                        result = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)cr, (long)id2, (int)kind, null);
                    }
                    catch (Exception e) {
                        this.remove(key);
                        throw e instanceof IOException ? (IOException)e : new IOException(e);
                    }
                }
                if (result != null) {
                    int orientation = BitmapHelper.getOrientation(cr, id2);
                    if (orientation != 0) {
                        Bitmap newBitmap = BitmapHelper.rotateBitmap(result, orientation);
                        result.recycle();
                        result = newBitmap;
                    }
                    this.put(key, result, false);
                } else {
                    throw new IOException("failed to get thumbnail,key=" + key + "/id=" + id2);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Bitmap getVideoThumbnail(@NonNull ContentResolver cr, long id2, int requestWidth, int requestHeight) throws FileNotFoundException, IOException {
        Bitmap result;
        String key = ThumbnailCache.getKey(id2);
        Object object = sSync;
        synchronized (object) {
            result = this.get(key);
            if (result == null) {
                int kind = 3;
                if (requestWidth > 96 || requestHeight > 96 || requestWidth * requestHeight > 16384) {
                    kind = 1;
                }
                try {
                    result = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)cr, (long)id2, (int)kind, null);
                }
                catch (Exception e) {
                    this.remove(key);
                    throw e instanceof IOException ? (IOException)e : new IOException(e);
                }
                if (result != null) {
                    int orientation = BitmapHelper.getOrientation(cr, id2);
                    if (orientation != 0) {
                        Bitmap newBitmap = BitmapHelper.rotateBitmap(result, orientation);
                        result.recycle();
                        result = newBitmap;
                    }
                    this.put(key, result, false);
                } else {
                    throw new IOException("failed to get thumbnail,key=" + key + "/id=" + id2);
                }
            }
        }
        return result;
    }

    private static String getKey(long id2) {
        return String.format(Locale.US, "%x", id2);
    }

    static {
        sMaxDiskCacheBytes = 0xA00000;
    }
}

