/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediaeffect;

import android.util.Log;
import androidx.annotation.NonNull;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLSurface;
import com.serenegiant.mediaeffect.IEffect;
import com.serenegiant.mediaeffect.ISource;

public class MediaSource
implements ISource {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaSource";
    protected GLSurface mSourceScreen;
    protected GLSurface mOutputScreen;
    protected int mWidth;
    protected int mHeight;
    protected int[] mSrcTexIds = new int[1];
    protected boolean needSwap;

    public MediaSource() {
        this.resize(1, 1);
    }

    public MediaSource(int width, int height) {
        this.resize(width, height);
    }

    @Override
    public ISource reset() {
        this.needSwap = false;
        this.mSrcTexIds[0] = this.mSourceScreen.getTexId();
        return this;
    }

    @Override
    public ISource resize(int width, int height) {
        if (this.mWidth != width || this.mHeight != height) {
            if (this.mSourceScreen != null) {
                this.mSourceScreen.release();
                this.mSourceScreen = null;
            }
            if (this.mOutputScreen != null) {
                this.mOutputScreen.release();
                this.mOutputScreen = null;
            }
            if (width > 0 && height > 0) {
                this.mSourceScreen = GLSurface.newInstance(false, width, height, false, false);
                this.mOutputScreen = GLSurface.newInstance(false, width, height, false, false);
                this.mWidth = width;
                this.mHeight = height;
                this.mSrcTexIds[0] = this.mSourceScreen.getTexId();
            }
        }
        this.needSwap = false;
        return this;
    }

    @Override
    public ISource apply(IEffect effect) {
        if (this.mSourceScreen != null) {
            if (this.needSwap) {
                GLSurface temp = this.mSourceScreen;
                this.mSourceScreen = this.mOutputScreen;
                this.mOutputScreen = temp;
                this.mSrcTexIds[0] = this.mSourceScreen.getTexId();
            }
            this.needSwap = !this.needSwap;
            effect.apply(this);
        }
        return this;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    @NonNull
    public int[] getSourceTexId() {
        return this.mSrcTexIds;
    }

    @Override
    public int getOutputTexId() {
        return this.needSwap ? this.mOutputScreen.getTexId() : this.mSourceScreen.getTexId();
    }

    @Override
    public float[] getTexMatrix() {
        return this.needSwap ? this.mOutputScreen.copyTexMatrix() : this.mSourceScreen.copyTexMatrix();
    }

    @Override
    public GLSurface getOutputTexture() {
        return this.needSwap ? this.mOutputScreen : this.mSourceScreen;
    }

    @Override
    public void release() {
        this.mSrcTexIds[0] = -1;
        if (this.mSourceScreen != null) {
            this.mSourceScreen.release();
            this.mSourceScreen = null;
        }
        if (this.mOutputScreen != null) {
            this.mOutputScreen.release();
            this.mOutputScreen = null;
        }
    }

    public MediaSource bind() {
        this.mSourceScreen.makeCurrent();
        return this;
    }

    public MediaSource unbind() {
        this.mSourceScreen.swap();
        this.reset();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaSource setSource(GLDrawer2D drawer, int tex_id, float[] tex_matrix) {
        this.mSourceScreen.makeCurrent();
        try {
            drawer.draw(33984, tex_id, tex_matrix, 0);
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        finally {
            this.mSourceScreen.swap();
        }
        this.reset();
        return this;
    }
}

