/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.media.Encoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.ISurfaceEncoder;
import com.serenegiant.media.MediaReaper;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.system.Time;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public abstract class AbstractEncoder
implements Encoder {
    private static final boolean DEBUG = false;
    private static final String TAG = AbstractEncoder.class.getSimpleName();
    public static final int TIMEOUT_USEC = 10000;
    @NonNull
    protected final Object mSync = new Object();
    @NonNull
    private final EncoderListener mListener;
    @NonNull
    protected final String MIME_TYPE;
    protected volatile boolean mIsCapturing;
    protected volatile boolean mRequestStop;
    protected int mTrackIndex;
    @Nullable
    protected MediaCodec mMediaCodec;
    @Nullable
    protected MediaReaper mReaper;
    @Nullable
    private IRecorder mRecorder;
    private final MediaReaper.ReaperListener mReaperListener = new MediaReaper.ReaperListener(){

        @Override
        public void writeSampleData(@NonNull MediaReaper reaper, @NonNull ByteBuffer byteBuf, @NonNull MediaCodec.BufferInfo bufferInfo) {
            if (AbstractEncoder.this.mIsCapturing && !AbstractEncoder.this.mRequestStop && AbstractEncoder.this.mRecorder != null) {
                AbstractEncoder.this.mRecorder.writeSampleData(AbstractEncoder.this.mTrackIndex, byteBuf, bufferInfo);
            }
        }

        @Override
        public void onOutputFormatChanged(@NonNull MediaReaper reaper, @NonNull MediaFormat format) {
            if (AbstractEncoder.this.mIsCapturing && !AbstractEncoder.this.mRequestStop && AbstractEncoder.this.mRecorder != null) {
                AbstractEncoder.this.startRecorder(AbstractEncoder.this.mRecorder, format);
            }
        }

        @Override
        public void onStop(@NonNull MediaReaper reaper) {
            AbstractEncoder.this.mRequestStop = true;
        }

        @Override
        public void onError(@NonNull MediaReaper reaper, Throwable t) {
        }
    };
    private long prevInputPTSUs = -1L;

    public AbstractEncoder(@NonNull String mime_type, @NonNull IRecorder recorder, @NonNull EncoderListener listener) {
        if (listener == null) {
            throw new NullPointerException("EncodeListener is null");
        }
        if (recorder == null) {
            throw new NullPointerException("recorder is null");
        }
        this.MIME_TYPE = mime_type;
        this.mRecorder = recorder;
        this.mListener = listener;
        recorder.addEncoder(this);
    }

    @NonNull
    public IRecorder getRecorder() {
        return this.mRecorder;
    }

    @NonNull
    public VideoConfig getConfig() {
        return this.mRecorder.getConfig();
    }

    @Override
    @Deprecated
    public String getOutputPath() {
        return this.mRecorder != null ? this.mRecorder.getOutputPath() : null;
    }

    public int getCaptureFormat() {
        return -1;
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public final void prepare() throws Exception {
        boolean mayFail = this.internalPrepare(this.mReaperListener);
        Surface surface = this instanceof ISurfaceEncoder ? ((ISurfaceEncoder)((Object)this)).getInputSurface() : null;
        try {
            this.mListener.onStartEncode(this, surface, this.getCaptureFormat(), mayFail);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    protected abstract boolean internalPrepare(@NonNull MediaReaper.ReaperListener var1) throws Exception;

    protected void callOnError(Exception e) {
        try {
            this.mListener.onError(e);
        }
        catch (Exception e2) {
            Log.w((String)TAG, (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.mSync;
        synchronized (object) {
            this.mIsCapturing = true;
            this.mRequestStop = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRequestStop) {
                return;
            }
            if (this.mReaper != null) {
                this.mReaper.frameAvailableSoon();
            }
            this.mRequestStop = true;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameAvailableSoon() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            if (this.mReaper != null) {
                this.mReaper.frameAvailableSoon();
            }
            this.mSync.notifyAll();
        }
    }

    @Override
    public void release() {
        this.mRecorder = null;
        if (this.mIsCapturing) {
            try {
                this.mListener.onStopEncode(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mIsCapturing = false;
        if (this.mMediaCodec != null) {
            try {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mReaper != null) {
            this.mReaper.release();
            this.mReaper = null;
        }
        if (this.mRecorder != null) {
            try {
                this.mRecorder.stop(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.mListener.onDestroy(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mRecorder = null;
    }

    @Override
    public void signalEndOfInputStream() {
        this.encode(null, 0, this.getInputPTSUs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCapturing() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mIsCapturing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            if (this.mMediaCodec == null) {
                return;
            }
        }
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        while (this.mIsCapturing) {
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                if (buffer != null && length > 0) {
                    buffer.clear();
                    buffer.position(length);
                    buffer.flip();
                    inputBuffer.put(buffer);
                }
                if (length <= 0) {
                    this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                    break;
                }
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, length, presentationTimeUs, 0);
                break;
            }
            if (inputBufferIndex != -1) continue;
            this.frameAvailableSoon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startRecorder(@NonNull IRecorder recorder, @NonNull MediaFormat outFormat) {
        if (recorder.getState() != 3) {
            for (int i = 0; i < 10 && recorder.getState() != 3; ++i) {
                Object object = this.mSync;
                synchronized (object) {
                    try {
                        this.mSync.wait(10L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
        if (recorder.getState() == 3) {
            this.mTrackIndex = recorder.addTrack(this, outFormat);
            if (this.mTrackIndex >= 0) {
                if (!recorder.start(this)) {
                    Log.w((String)TAG, (String)("startRecorder: failed to start recorder mTrackIndex=" + this.mTrackIndex));
                }
            } else {
                recorder.removeEncoder(this);
            }
        }
        return recorder.isStarted();
    }

    protected void stopRecorder(IRecorder recorder) {
        this.mIsCapturing = false;
    }

    @SuppressLint(value={"NewApi"})
    protected long getInputPTSUs() {
        long result = Time.nanoTime() / 1000L;
        if (result <= this.prevInputPTSUs) {
            result = this.prevInputPTSUs + 9643L;
        }
        this.prevInputPTSUs = result;
        return result;
    }
}

