/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.serenegiant.glpipeline.DistributePipeline;
import com.serenegiant.glpipeline.GLPipeline;

public class ProxyPipeline
implements GLPipeline {
    private static final boolean DEBUG = false;
    private static final String TAG = ProxyPipeline.class.getSimpleName();
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    @NonNull
    private final Object mSync = new Object();
    private int mWidth;
    private int mHeight;
    @Nullable
    private GLPipeline mParent;
    @Nullable
    private GLPipeline mPipeline;
    private volatile boolean mReleased = false;

    public ProxyPipeline() {
        this(640, 480);
    }

    protected ProxyPipeline(int width, int height) {
        if (width > 0 || height > 0) {
            this.mWidth = width;
            this.mHeight = height;
        } else {
            this.mWidth = 640;
            this.mHeight = 480;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public final void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            this.internalRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    protected void internalRelease() {
        GLPipeline pipeline;
        this.mReleased = true;
        Object object = this.mSync;
        synchronized (object) {
            pipeline = this.mPipeline;
            this.mPipeline = null;
            this.mParent = null;
        }
        if (pipeline != null) {
            pipeline.release();
        }
    }

    @Override
    @CallSuper
    public void resize(int width, int height) throws IllegalStateException {
        if (!this.mReleased) {
            this.mWidth = width;
            this.mHeight = height;
            GLPipeline pipeline = this.getPipeline();
            if (pipeline != null) {
                pipeline.resize(width, height);
            }
        } else {
            throw new IllegalStateException("already released!");
        }
    }

    @Override
    public boolean isValid() {
        return !this.mReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.mSync;
        synchronized (object) {
            return !this.mReleased && this.mPipeline != null && this.mParent != null;
        }
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CallSuper
    public void setParent(@Nullable GLPipeline parent) {
        if (!this.mReleased) {
            Object object = this.mSync;
            synchronized (object) {
                this.mParent = parent;
            }
        } else {
            throw new IllegalStateException("already released!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GLPipeline getParent() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mParent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CallSuper
    public void setPipeline(@Nullable GLPipeline pipeline) {
        if (!this.mReleased) {
            Object object = this.mSync;
            synchronized (object) {
                this.mPipeline = pipeline;
            }
            if (pipeline != null) {
                pipeline.setParent(this);
                pipeline.resize(this.mWidth, this.mHeight);
            }
        } else {
            throw new IllegalStateException("already released!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GLPipeline getPipeline() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mPipeline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CallSuper
    public void remove() {
        GLPipeline parent;
        GLPipeline first = GLPipeline.findFirst(this);
        Object object = this.mSync;
        synchronized (object) {
            parent = this.mParent;
            if (this.mParent instanceof DistributePipeline) {
                ((DistributePipeline)this.mParent).removePipeline(this);
            } else if (this.mParent != null) {
                this.mParent.setPipeline(this.mPipeline);
            }
            this.mParent = null;
            this.mPipeline = null;
        }
        if (first != this) {
            GLPipeline.validatePipelineChain(first);
            parent.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CallSuper
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        if (!this.mReleased) {
            GLPipeline pipeline;
            Object object = this.mSync;
            synchronized (object) {
                pipeline = this.mPipeline;
            }
            if (pipeline != null) {
                pipeline.onFrameAvailable(isOES, texId, texMatrix);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (!this.mReleased) {
            GLPipeline pipeline;
            Object object = this.mSync;
            synchronized (object) {
                pipeline = this.mPipeline;
            }
            if (pipeline != null) {
                pipeline.refresh();
            }
        }
    }
}

