/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.gl;

import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.Choreographer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.GLContext;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.utils.HandlerThreadHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class GLManager {
    private static final boolean DEBUG = false;
    private static final String TAG = GLManager.class.getSimpleName();
    @NonNull
    private final GLContext mGLContext;
    @NonNull
    private final Handler mGLHandler;
    private final long mHandlerThreadId;
    private boolean mInitialized;
    private boolean mReleased;

    public GLManager() {
        this(GLUtils.getSupportedGLVersion(), null, 0, null, 0, 0, null);
    }

    public GLManager(@Nullable Handler.Callback callback) {
        this(GLUtils.getSupportedGLVersion(), null, 0, null, 0, 0, callback);
    }

    public GLManager(int maxClientVersion) {
        this(maxClientVersion, null, 0, null, 0, 0, null);
    }

    public GLManager(int maxClientVersion, @Nullable Handler.Callback callback) {
        this(maxClientVersion, null, 0, null, 0, 0, callback);
    }

    public GLManager(@NonNull GLManager manager, @Nullable Handler.Callback callback) {
        this(manager.getGLContext().getMaxClientVersion(), manager.getGLContext().getContext(), manager.getGLContext().getFlags(), null, 0, 0, callback);
    }

    public GLManager(int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags, @Nullable Handler.Callback callback) throws IllegalArgumentException, IllegalStateException {
        this(maxClientVersion, sharedContext, flags, null, 0, 0, callback);
    }

    public GLManager(int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags, final @Nullable Object masterSurface, final int masterWidth, final int masterHeight, @Nullable Handler.Callback callback) throws IllegalArgumentException, IllegalStateException {
        if (masterSurface != null && !GLUtils.isSupportedSurface(masterSurface)) {
            throw new IllegalArgumentException("wrong type of masterSurface");
        }
        this.mGLContext = new GLContext(maxClientVersion, sharedContext, flags);
        HandlerThreadHandler handler = Build.VERSION.SDK_INT >= 22 ? HandlerThreadHandler.createHandler(TAG, callback, true) : HandlerThreadHandler.createHandler(TAG, callback);
        this.mGLHandler = handler;
        this.mHandlerThreadId = handler.getId();
        final Semaphore sync = new Semaphore(0);
        this.mGLHandler.postAtFrontOfQueue(new Runnable(){

            @Override
            public void run() {
                try {
                    GLManager.this.mGLContext.initialize(masterSurface, masterWidth, masterHeight);
                    GLManager.this.mInitialized = true;
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                sync.release();
            }
        });
        try {
            if (!sync.tryAcquire(3000L, TimeUnit.MILLISECONDS)) {
                this.mInitialized = false;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.mInitialized) {
            throw new IllegalStateException("Failed to initialize GL context");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            this.mGLHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    GLManager.this.mGLContext.release();
                    GLManager.this.mGLHandler.removeCallbacksAndMessages(null);
                    GLManager.this.mGLHandler.getLooper().quit();
                }
            });
        }
    }

    public void reInitialize(final @Nullable Object masterSurface, final int masterWidth, final int masterHeight) {
        if (this.mInitialized) {
            this.mInitialized = false;
            final Semaphore sync = new Semaphore(0);
            this.mGLHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    try {
                        GLManager.this.mGLContext.initialize(masterSurface, masterWidth, masterHeight);
                        GLManager.this.mInitialized = true;
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                    sync.release();
                }
            });
            try {
                if (!sync.tryAcquire(3000L, TimeUnit.MILLISECONDS)) {
                    this.mInitialized = false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.mInitialized) {
                throw new IllegalStateException("Failed to initialize GL context");
            }
        } else {
            throw new IllegalStateException("Not initialized!");
        }
    }

    public synchronized boolean isValid() {
        return this.mInitialized && !this.mReleased;
    }

    public boolean isGLES3() {
        return this.mGLContext.isGLES3();
    }

    public boolean isGLThread() {
        return this.mHandlerThreadId == Thread.currentThread().getId();
    }

    public EGLBase getEgl() throws IllegalStateException {
        this.checkValid();
        return this.mGLContext.getEgl();
    }

    public int getMasterWidth() {
        return this.mGLContext.getMasterWidth();
    }

    public int getMasterHeight() {
        return this.mGLContext.getMasterHeight();
    }

    public synchronized GLManager createShared(@Nullable Handler.Callback callback) throws RuntimeException {
        this.checkValid();
        return new GLManager(this.mGLContext.getMaxClientVersion(), this.mGLContext.getContext(), this.mGLContext.getFlags(), null, 0, 0, callback);
    }

    @NonNull
    public synchronized Handler getGLHandler() throws IllegalStateException {
        this.checkValid();
        return this.mGLHandler;
    }

    public synchronized Handler createGLHandler(@Nullable Handler.Callback callback) throws IllegalStateException {
        this.checkValid();
        return new Handler(this.mGLHandler.getLooper(), callback);
    }

    @NonNull
    public synchronized GLContext getGLContext() throws IllegalStateException {
        this.checkValid();
        return this.mGLContext;
    }

    public void makeDefault() throws IllegalStateException {
        this.checkValid();
        this.mGLContext.makeDefault();
    }

    public void swap() throws IllegalStateException {
        this.checkValid();
        this.mGLContext.swap();
    }

    public synchronized void runOnGLThread(Runnable task) throws IllegalStateException {
        this.checkValid();
        if (this.isGLThread()) {
            task.run();
        } else {
            this.mGLHandler.post(task);
        }
    }

    public synchronized void runOnGLThread(Runnable task, long delayMs) throws IllegalStateException {
        this.checkValid();
        if (delayMs > 0L) {
            this.mGLHandler.postDelayed(task, delayMs);
        } else if (this.isGLThread()) {
            task.run();
        } else {
            this.mGLHandler.post(task);
        }
    }

    public synchronized void postFrameCallbackDelayed(final @NonNull Choreographer.FrameCallback callback, final long delayMs) throws IllegalStateException {
        this.checkValid();
        if (this.isGLThread()) {
            Choreographer.getInstance().postFrameCallbackDelayed(callback, delayMs);
        } else {
            this.mGLHandler.post(new Runnable(){

                @Override
                public void run() {
                    Choreographer.getInstance().postFrameCallbackDelayed(callback, delayMs);
                }
            });
        }
    }

    public synchronized void removeFrameCallback(final @NonNull Choreographer.FrameCallback callback) throws IllegalStateException {
        this.checkValid();
        if (this.isGLThread()) {
            Choreographer.getInstance().removeFrameCallback(callback);
        } else {
            this.mGLHandler.post(new Runnable(){

                @Override
                public void run() {
                    Choreographer.getInstance().removeFrameCallback(callback);
                }
            });
        }
    }

    private void checkValid() throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException("already released");
        }
    }
}

