/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.graphics.BitmapHelper;
import com.serenegiant.utils.ArrayUtils;

public class SQLiteBlobHelper {
    public static void bindBlobFloatArray(@NonNull SQLiteStatement stat, int index, @NonNull float[] array) {
        stat.bindBlob(index, ArrayUtils.floatArrayToByteArray(array, 0, array.length));
    }

    public static void bindBlobFloatArray(@NonNull SQLiteStatement stat, int index, @NonNull float[] array, int offset, int num) {
        stat.bindBlob(index, ArrayUtils.floatArrayToByteArray(array, offset, num));
    }

    public static void bindBlobDoubleArray(@NonNull SQLiteStatement stat, int index, @NonNull double[] array) {
        stat.bindBlob(index, ArrayUtils.doubleArrayToByteArray(array, 0, array.length));
    }

    public static void bindBlobDoubleArray(@NonNull SQLiteStatement stat, int index, @NonNull double[] array, int offset, int num) {
        stat.bindBlob(index, ArrayUtils.doubleArrayToByteArray(array, offset, num));
    }

    public static void bindBlobIntArray(@NonNull SQLiteStatement stat, int index, @NonNull int[] array) {
        stat.bindBlob(index, ArrayUtils.intArrayToByteArray(array, 0, array.length));
    }

    public static void bindBlobIntArray(@NonNull SQLiteStatement stat, int index, @NonNull int[] array, int offset, int num) {
        stat.bindBlob(index, ArrayUtils.intArrayToByteArray(array, offset, num));
    }

    public static void bindBlobShortArray(@NonNull SQLiteStatement stat, int index, @NonNull short[] array) {
        stat.bindBlob(index, ArrayUtils.shortArrayToByteArray(array, 0, array.length));
    }

    public static void bindBlobShortArray(@NonNull SQLiteStatement stat, int index, @NonNull short[] array, int offset, int num) {
        stat.bindBlob(index, ArrayUtils.shortArrayToByteArray(array, offset, num));
    }

    public static void bindBlobLongArray(@NonNull SQLiteStatement stat, int index, @NonNull long[] array) {
        stat.bindBlob(index, ArrayUtils.longArrayToByteArray(array, 0, array.length));
    }

    public static void bindBlobLongArray(@NonNull SQLiteStatement stat, int index, long[] array, int offset, int num) {
        stat.bindBlob(index, ArrayUtils.longArrayToByteArray(array, offset, num));
    }

    public static void bindBlobBitmap(@NonNull SQLiteStatement stat, int index, @NonNull Bitmap bitmap) {
        stat.bindBlob(index, BitmapHelper.BitmapToByteArray(bitmap));
    }

    public static float[] getBlobFloatArray(@NonNull Cursor cursor, int columnIndex) {
        return ArrayUtils.byteArrayToFloatArray(cursor.getBlob(columnIndex));
    }

    @Nullable
    public static float[] getBlobFloatArray(@NonNull Cursor cursor, String columnName, @Nullable float[] defaultValue) {
        float[] result = ArrayUtils.byteArrayToFloatArray(SQLiteBlobHelper.getBlob(cursor, columnName, null));
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static double[] getBlobDoubleArray(@NonNull Cursor cursor, int columnIndex) {
        return ArrayUtils.byteArrayToDoubleArray(cursor.getBlob(columnIndex));
    }

    @Nullable
    public static double[] getBlobDoubleArray(@NonNull Cursor cursor, String columnName, @Nullable double[] defaultValue) {
        double[] result = ArrayUtils.byteArrayToDoubleArray(SQLiteBlobHelper.getBlob(cursor, columnName, null));
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Nullable
    public static byte[] getBlob(@NonNull Cursor cursor, String columnName, @Nullable byte[] defaultValue) {
        byte[] result = defaultValue;
        try {
            result = cursor.getBlob(cursor.getColumnIndexOrThrow(columnName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static int[] getBlobIntArray(@NonNull Cursor cursor, int columnIndex) {
        return ArrayUtils.byteArrayToIntArray(cursor.getBlob(columnIndex));
    }

    @Nullable
    public static int[] getBlobIntArray(@NonNull Cursor cursor, String columnName, @Nullable int[] defaultValue) {
        int[] result = ArrayUtils.byteArrayToIntArray(SQLiteBlobHelper.getBlob(cursor, columnName, null));
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static short[] getBlobShortArray(@NonNull Cursor cursor, int columnIndex) {
        return ArrayUtils.byteArrayToShortArray(cursor.getBlob(columnIndex));
    }

    @Nullable
    public static short[] getBlobShortArray(@NonNull Cursor cursor, String columnName, @Nullable short[] defaultValue) {
        short[] result = ArrayUtils.byteArrayToShortArray(SQLiteBlobHelper.getBlob(cursor, columnName, null));
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static long[] getBlobLongArray(@NonNull Cursor cursor, int columnIndex) {
        return ArrayUtils.byteArrayToLongArray(cursor.getBlob(columnIndex));
    }

    @Nullable
    public static long[] getBlobLongArray(@NonNull Cursor cursor, String columnName, @Nullable long[] defaultValue) {
        long[] result = ArrayUtils.byteArrayToLongArray(SQLiteBlobHelper.getBlob(cursor, columnName, null));
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static Bitmap getBlobBitmap(@NonNull Cursor cursor, int columnIndex) {
        return BitmapHelper.asBitmap(cursor.getBlob(columnIndex));
    }

    public static Bitmap getBlobBitmap(@NonNull Cursor cursor, String columnName) {
        return BitmapHelper.asBitmap(SQLiteBlobHelper.getBlob(cursor, columnName, null));
    }

    @Nullable
    public static Bitmap getBlobBitmap(@NonNull Cursor cursor, int columnIndex, int requestWidth, int requestHeight) {
        return BitmapHelper.asBitmap(cursor.getBlob(columnIndex), requestWidth, requestHeight);
    }

    @Nullable
    public static Bitmap getBlobBitmap(@NonNull Cursor cursor, String columnName, int requestWidth, int requestHeight) {
        return BitmapHelper.asBitmap(SQLiteBlobHelper.getBlob(cursor, columnName, null), requestWidth, requestHeight);
    }

    @Nullable
    public static Bitmap getBlobBitmapStrictSize(@NonNull Cursor cursor, int columnIndex, int requestWidth, int requestHeight) {
        return BitmapHelper.asBitmapStrictSize(cursor.getBlob(columnIndex), requestWidth, requestHeight);
    }

    @Nullable
    public static Bitmap getBlobBitmapStrictSize(@NonNull Cursor cursor, String columnName, int requestWidth, int requestHeight) {
        return BitmapHelper.asBitmapStrictSize(SQLiteBlobHelper.getBlob(cursor, columnName, null), requestWidth, requestHeight);
    }
}

