/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.hardware.usb.UsbDeviceConnection;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.usb.NativeLibLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;

@Keep
public class Utils {
    private static final String TAG = Utils.class.getSimpleName();

    public static String testParse(@NonNull UsbDeviceConnection device, @NonNull String outputDir) {
        ByteBuffer descriptor = ByteBuffer.wrap(device.getRawDescriptors());
        return Utils.testParse(descriptor, 0, descriptor.capacity(), outputDir);
    }

    public static String testParse(@NonNull ByteBuffer descriptor, @NonNull String outputDir) {
        return Utils.testParse(descriptor, 0, descriptor.limit(), outputDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String testParse(@NonNull ByteBuffer descriptor, int offset, int size, @NonNull String outputDir) {
        String result = null;
        File dir = new File(outputDir);
        dir.mkdirs();
        if (dir.canWrite()) {
            String name = String.format(Locale.US, "%08x.txt", System.currentTimeMillis());
            File file = new File(dir, name);
            if (!file.exists()) {
                try {
                    Utils.nativeTestParse(descriptor, offset, size, file.getAbsolutePath());
                }
                catch (IOException e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                if (file.exists()) {
                    try (BufferedReader in = new BufferedReader(new FileReader(file));){
                        StringBuilder sb = new StringBuilder(1024);
                        char[] buffer = new char[512];
                        int n = 0;
                        while (n >= 0 && (n = in.read(buffer)) > 0) {
                            sb.append(buffer, 0, n);
                        }
                        result = sb.toString();
                    }
                    catch (FileNotFoundException e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                    catch (IOException e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                    file.deleteOnExit();
                }
            } else {
                Log.w((String)TAG, (String)("specific file is already exists:" + file));
            }
        } else {
            Log.w((String)TAG, (String)("can not write to " + outputDir));
        }
        return result;
    }

    private static native void nativeStaticInit();

    private static native int nativeTestParse(@NonNull ByteBuffer var0, int var1, int var2, @NonNull String var3) throws IOException;

    static {
        NativeLibLoader.loadNative();
    }
}

