/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.upc;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.AbstractCamera;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.camera.Size;
import com.serenegiant.camera.SizeUtils;
import com.serenegiant.usb.NativeLibLoader;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UsbDeviceInfo;
import com.serenegiant.usb.UsbUtils;
import com.serenegiant.usb.uvc.IPipeline;
import com.serenegiant.usb.uvc.IPipelineSource;
import com.serenegiant.usb.uvc.PreviewFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Keep
public class UPCPipeline
extends AbstractCamera
implements IPipelineSource {
    private static final boolean DEBUG = true;
    private static final String TAG = UPCPipeline.class.getSimpleName();
    @Keep
    @NonNull
    private final Context mContext;
    @Keep
    private long mNativePtr;
    @Keep
    private int mNativeValue;
    private USBMonitor.UsbControlBlock mCtrlBlock;
    @Nullable
    private String mSupportedSize;
    @Nullable
    private List<Size> mCurrentSizeList;
    private int mRequestWidth = 640;
    private int mRequestHeight = 480;
    private float mRequestMinFps = 1.0f;
    private float mRequestMaxFps = 31.0f;
    private float mRequestBandWidthFactor = 0.0f;

    public UPCPipeline(@NonNull Context context) throws IllegalAccessException {
        this.mContext = context;
        this.setState(1);
        this.mNativePtr = this.nativeCreate();
        if (this.mNativePtr == 0L) {
            throw new IllegalAccessException("Failed to create native instance");
        }
        this.setState(16);
    }

    @Override
    public void release() {
        Log.v((String)TAG, (String)("release:mNativePtr=" + this.mNativePtr));
        if (this.mNativePtr != 0L) {
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
        super.release();
    }

    @Override
    public void setPipeline(IPipeline next_pipeline) {
    }

    @Override
    public void start() throws IllegalStateException {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    public synchronized void open(@NonNull USBMonitor.UsbControlBlock ctrlBlock) throws IOException {
        Log.v((String)TAG, (String)"open:");
        if (!this.isConnected()) {
            int result;
            this.setState(256, -257);
            try {
                this.mCtrlBlock = ctrlBlock.clone();
                result = UPCPipeline.nativeConnect(this.mNativePtr, this.mCtrlBlock.getFileDescriptor());
            }
            catch (Exception e) {
                result = -1;
            }
            if (result != 0) {
                if (this.mCtrlBlock != null) {
                    this.mCtrlBlock.close();
                    this.mCtrlBlock = null;
                }
                this.setState(0, -769);
                throw new IOException("open failed:result=" + result);
            }
            this.setState(512, -769);
        }
    }

    public synchronized void close() {
        this.stopStream();
        this.setState(0, -769);
        if (this.mNativePtr != 0L) {
            UPCPipeline.nativeDisconnect(this.mNativePtr);
        }
        if (this.mCtrlBlock != null) {
            this.mCtrlBlock.close();
            this.mCtrlBlock = null;
        }
    }

    @Override
    public boolean startStream() {
        Log.v((String)TAG, (String)("startStream:mNativePtr=" + this.mNativePtr));
        if (this.mNativePtr != 0L) {
            int result = UPCPipeline.nativeStartStream(this.mNativePtr);
            if (result != 0) {
                throw new RuntimeException("startStream: Failed result=" + result);
            }
        } else {
            throw new RuntimeException("startStream: not ready");
        }
        this.setState(1024, -1025);
        return this.isStreaming();
    }

    @Override
    public boolean stopStream() {
        Log.v((String)TAG, (String)"stopStream:");
        this.setState(0, -1025);
        if (this.mNativePtr != 0L) {
            UPCPipeline.nativeStopStream(this.mNativePtr);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized String getDescriptor() {
        Log.v((String)TAG, (String)"getDescriptor:");
        String result = null;
        if (this.mNativePtr != 0L && this.mCtrlBlock != null) {
            File dir = this.mContext.getExternalFilesDir("Descriptors");
            dir.mkdirs();
            if (dir.canWrite()) {
                File filepath = new File(dir, String.format("desc-%04x_%04x_%08x.txt", this.mCtrlBlock.getVenderId(), this.mCtrlBlock.getProductId(), UsbUtils.getDeviceKey((UsbDeviceInfo)this.mCtrlBlock.getInfo())));
                if (!filepath.exists()) {
                    UPCPipeline.nativeOutputDescriptor(this.mNativePtr, this.mCtrlBlock.getVenderId(), this.mCtrlBlock.getProductId(), this.mCtrlBlock.getFileDescriptor(), filepath.getAbsolutePath());
                }
                if (filepath.exists()) {
                    try (BufferedReader in = new BufferedReader(new FileReader(filepath));){
                        StringBuilder sb = new StringBuilder(1024);
                        char[] buffer = new char[512];
                        int n = 0;
                        while (n >= 0 && (n = in.read(buffer)) > 0) {
                            sb.append(buffer, 0, n);
                        }
                        result = sb.toString();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        Log.v((String)TAG, (String)"getDescriptor:finished");
        return result;
    }

    public synchronized String getCurrentStream() {
        return null;
    }

    @Override
    public String getDeviceKeyName() {
        return null;
    }

    @Override
    public int getDeviceKey() {
        return 0;
    }

    @Override
    public void setVideoSize(@Nullable Size size) throws IllegalArgumentException {
        this.setVideoSize(size, 0.0f);
    }

    @Override
    public void setVideoSize(@Nullable Size size, float bandwidthFactor) throws IllegalArgumentException {
        if (size == null) {
            List<Size> resolutions = this.getSupportedSizeList();
            if (resolutions.size() > 0) {
                Size sz = resolutions.get(0);
                if (sz == null) {
                    throw new IllegalArgumentException("invalid preview size index");
                }
                this.setVideoSize(sz.width, sz.height, this.mRequestMinFps, this.mRequestMaxFps, bandwidthFactor);
                return;
            }
            throw new IllegalArgumentException("invalid preview size index");
        }
        float maxFps = this.mRequestMaxFps;
        try {
            maxFps = size.getCurrentFrameRate() + 0.1f;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVideoSize(size.width, size.height, this.mRequestMinFps, maxFps, bandwidthFactor);
    }

    @Override
    public void setVideoSize(int width, int height, float minFps, float maxFps) {
        this.setVideoSize(width, height, minFps, maxFps, 0.0f);
    }

    @Override
    public void setVideoSize(int width, int height, float minFps, float maxFps, float bandwidthFactor) {
        int result;
        Log.d((String)TAG, (String)String.format("setVideoSize:size(%d,%d),fps(%f,%f)", width, height, Float.valueOf(minFps), Float.valueOf(maxFps)));
        this.mCurrentSizeList = null;
        Size sz = this.findVideoSize(width, height);
        Log.v((String)TAG, (String)("setVideoSize:sz=" + sz));
        if (sz != null && (result = UPCPipeline.nativeSetVideoSize(this.mNativePtr, RawFrameType.RAW_FRAME_UNCOMPRESSED_YUYV.getValue(), sz.width, sz.height, minFps, maxFps, bandwidthFactor)) == 0) {
            this.mRequestWidth = sz.width;
            this.mRequestHeight = sz.height;
            this.mRequestMinFps = minFps;
            this.mRequestMaxFps = maxFps;
            this.mRequestBandWidthFactor = bandwidthFactor;
            return;
        }
        throw new IllegalArgumentException("setVideoSize:");
    }

    public Size findVideoSize(int width, int height) {
        Size result = null;
        List<Size> supported = this.getSupportedSizeListAll();
        Log.v((String)TAG, (String)("findVideoSize:" + (supported != null ? Arrays.toString(supported.toArray()) : null)));
        if (supported != null && !supported.isEmpty()) {
            for (Size sz : supported) {
                if (sz.width != width || sz.height != height) continue;
                result = sz;
                break;
            }
            if (result == null) {
                result = supported.get(0);
            }
        }
        Log.i((String)TAG, (String)("findVideoSize:result=" + result));
        return result;
    }

    @Override
    public void updateCameraParams() {
    }

    @Override
    @NonNull
    public synchronized String getSupportedSizeStringAll() throws IllegalStateException {
        if (TextUtils.isEmpty((CharSequence)this.mSupportedSize)) {
            this.mSupportedSize = UPCPipeline.nativeGetSupportedSize(this.mNativePtr);
        }
        if (TextUtils.isEmpty((CharSequence)this.mSupportedSize)) {
            throw new IllegalStateException("Couldn't get supported size string, will be already released?");
        }
        return this.mSupportedSize;
    }

    @Override
    @NonNull
    public String getSupportedSizeString() throws IllegalStateException {
        return SizeUtils.toJsonString(this.getSupportedSizeList());
    }

    @Override
    @NonNull
    public List<Size> getSupportedSizeList() throws IllegalStateException {
        List<Size> result = this.mCurrentSizeList;
        if (result == null || result.isEmpty()) {
            this.mCurrentSizeList = result = SizeUtils.getSizeListFromPreviewFormat(this.getSupportedSizeStringAll(), PreviewFormat.PREVIEW_FORMAT_YUY2);
        }
        return result;
    }

    @Override
    @NonNull
    public List<Size> getSupportedSizeListAll() throws IllegalStateException {
        return Collections.unmodifiableList(SizeUtils.getSizeList(this.getSupportedSizeStringAll()));
    }

    @Override
    @Nullable
    public Size getCurrentVideoSize() {
        return null;
    }

    @Override
    public double getAspectRatio() {
        return 0.0;
    }

    @Override
    public long getSupportedCtrl() {
        return 0L;
    }

    @Override
    public long getSupportedProc() {
        return 0L;
    }

    @Override
    public boolean checkSupportFlag(long flags) {
        return false;
    }

    @Override
    public boolean setScanningMode(boolean isProgressive) {
        return false;
    }

    @Override
    public boolean getScanningMode() {
        return false;
    }

    @Override
    public boolean getScanningModeDef() {
        return false;
    }

    @Override
    public boolean resetScanningMode() {
        return false;
    }

    @Override
    public int setExposureMode(int exposure_mode) {
        return 0;
    }

    @Override
    public int getExposureMode() {
        return 0;
    }

    @Override
    public int getExposureModeDef() {
        return 0;
    }

    @Override
    public int resetExposureMode() {
        return 0;
    }

    @Override
    public int setExposurePriority(int exposure_priority) {
        return 0;
    }

    @Override
    public int getExposurePriority() {
        return 0;
    }

    @Override
    public int getExposurePriorityDef() {
        return 0;
    }

    @Override
    public int resetExposurePriority() {
        return 0;
    }

    @Override
    public int setExposure(int exposure) {
        return 0;
    }

    @Override
    public int getExposure() {
        return 0;
    }

    @Override
    public int getExposureDef() {
        return 0;
    }

    @Override
    public int resetExposure() {
        return 0;
    }

    @Override
    public int setExposureRel(int exposure_rel) {
        return 0;
    }

    @Override
    public int getExposureRel() {
        return 0;
    }

    @Override
    public int getExposureRelDef() {
        return 0;
    }

    @Override
    public int resetExposureRel() {
        return 0;
    }

    @Override
    public boolean setAutoFocus(boolean autoFocus) {
        return false;
    }

    @Override
    public boolean getAutoFocus() {
        return false;
    }

    @Override
    public boolean getAutoFocusDef() {
        return false;
    }

    @Override
    public boolean resetAutoFocus() {
        return false;
    }

    @Override
    public int setFocus(int focus) {
        return 0;
    }

    @Override
    public int getFocus() {
        return 0;
    }

    @Override
    public int getFocusDef() {
        return 0;
    }

    @Override
    public int resetFocus() {
        return 0;
    }

    @Override
    public int setFocusRel(int focus_rel) {
        return 0;
    }

    @Override
    public int getFocusRel() {
        return 0;
    }

    @Override
    public int getFocusRelDef() {
        return 0;
    }

    @Override
    public int resetFocusRel() {
        return 0;
    }

    @Override
    public int setIris(int iris) {
        return 0;
    }

    @Override
    public int getIris() {
        return 0;
    }

    @Override
    public int getIrisDef() {
        return 0;
    }

    @Override
    public int resetIris() {
        return 0;
    }

    @Override
    public int setIrisRel(int iris_rel) {
        return 0;
    }

    @Override
    public int getIrisRel() {
        return 0;
    }

    @Override
    public int getIrisRelDef() {
        return 0;
    }

    @Override
    public int resetIrisRel() {
        return 0;
    }

    @Override
    public int setPanTilt(int pan, int tilt) {
        return 0;
    }

    @Override
    public int getPanTilt() {
        return 0;
    }

    @Override
    public int getPanTiltDef() {
        return 0;
    }

    @Override
    public int resetPanTilt() {
        return 0;
    }

    @Override
    public int setPan(int pan) {
        return 0;
    }

    @Override
    public int getPan() {
        return 0;
    }

    @Override
    public int getPanDef() {
        return 0;
    }

    @Override
    public int resetPan() {
        return 0;
    }

    @Override
    public int setPanRel(int pan_rel, int pan_speed) {
        return 0;
    }

    @Override
    public int getPanRel() {
        return 0;
    }

    @Override
    public int getPanRelDef() {
        return 0;
    }

    @Override
    public int resetPanRel() {
        return 0;
    }

    @Override
    public int setTilt(int tilt) {
        return 0;
    }

    @Override
    public int getTilt() {
        return 0;
    }

    @Override
    public int getTiltDef() {
        return 0;
    }

    @Override
    public int resetTilt() {
        return 0;
    }

    @Override
    public int setTiltRel(int tilt_rel, int tilt_speed) {
        return 0;
    }

    @Override
    public int getTiltRel() {
        return 0;
    }

    @Override
    public int getTiltRelDef() {
        return 0;
    }

    @Override
    public int resetTiltRel() {
        return 0;
    }

    @Override
    public int setRoll(int roll) {
        return 0;
    }

    @Override
    public int getRoll() {
        return 0;
    }

    @Override
    public int getRollDef() {
        return 0;
    }

    @Override
    public int resetRoll() {
        return 0;
    }

    @Override
    public int setRollRel(int roll_rel, int roll_speed) {
        return 0;
    }

    @Override
    public int getRollRel() {
        return 0;
    }

    @Override
    public int getRollRelDef() {
        return 0;
    }

    @Override
    public int resetRollRel() {
        return 0;
    }

    @Override
    public boolean setPrivacy(boolean privacy) {
        return false;
    }

    @Override
    public boolean getPrivacy() {
        return false;
    }

    @Override
    public boolean getPrivacyDef() {
        return false;
    }

    @Override
    public boolean resetPrivacy() {
        return false;
    }

    @Override
    public boolean setAutoWhiteBlance(boolean autoWhiteBlance) {
        return false;
    }

    @Override
    public boolean getAutoWhiteBlance() {
        return false;
    }

    @Override
    public boolean getAutoWhiteBlanceDef() {
        return false;
    }

    @Override
    public boolean resetAutoWhiteBlance() {
        return false;
    }

    @Override
    public int setWhiteBlance(int whiteBlance) {
        return 0;
    }

    @Override
    public int getWhiteBlance() {
        return 0;
    }

    @Override
    public int getWhiteBlanceDef() {
        return 0;
    }

    @Override
    public int resetWhiteBlance() {
        return 0;
    }

    @Override
    public boolean setAutoWhiteBlanceCompo(boolean autoWhiteBlanceCompo) {
        return false;
    }

    @Override
    public boolean getAutoWhiteBlanceCompo() {
        return false;
    }

    @Override
    public boolean getAutoWhiteBlanceCompoDef() {
        return false;
    }

    @Override
    public boolean resetAutoWhiteBlanceCompo() {
        return false;
    }

    @Override
    public int setWhiteBlanceCompo(int whiteBalanceCompo) {
        return 0;
    }

    @Override
    public int getWhiteBlanceCompo() {
        return 0;
    }

    @Override
    public int getWhiteBlanceCompoDef() {
        return 0;
    }

    @Override
    public int resetWhiteBlanceCompo() {
        return 0;
    }

    @Override
    public int setBacklightComp(int backlight) {
        return 0;
    }

    @Override
    public int getBacklightComp() {
        return 0;
    }

    @Override
    public int getBacklightCompDef() {
        return 0;
    }

    @Override
    public int resetBacklightComp() {
        return 0;
    }

    @Override
    public int setBrightness(int brightness) {
        return 0;
    }

    @Override
    public int getBrightness() {
        return 0;
    }

    @Override
    public int getBrightnessDef() {
        return 0;
    }

    @Override
    public int resetBrightness() {
        return 0;
    }

    @Override
    public int setContrast(int contrast) {
        return 0;
    }

    @Override
    public int getContrast() {
        return 0;
    }

    @Override
    public int getContrastDef() {
        return 0;
    }

    @Override
    public int resetContrast() {
        return 0;
    }

    @Override
    public boolean setAutoContrast(boolean autoContrast) {
        return false;
    }

    @Override
    public boolean getAutoContrast() {
        return false;
    }

    @Override
    public boolean getAutoContrastDef() {
        return false;
    }

    @Override
    public boolean resetAutoContrast() {
        return false;
    }

    @Override
    public int setSharpness(int sharpness) {
        return 0;
    }

    @Override
    public int getSharpness() {
        return 0;
    }

    @Override
    public int getSharpnessDef() {
        return 0;
    }

    @Override
    public int resetSharpness() {
        return 0;
    }

    @Override
    public int setGain(int gain) {
        return 0;
    }

    @Override
    public int getGain() {
        return 0;
    }

    @Override
    public int getGainDef() {
        return 0;
    }

    @Override
    public int resetGain() {
        return 0;
    }

    @Override
    public int setGamma(int gamma) {
        return 0;
    }

    @Override
    public int getGamma() {
        return 0;
    }

    @Override
    public int getGammaDef() {
        return 0;
    }

    @Override
    public int resetGamma() {
        return 0;
    }

    @Override
    public int setSaturation(int saturation) {
        return 0;
    }

    @Override
    public int getSaturation() {
        return 0;
    }

    @Override
    public int getSaturationDef() {
        return 0;
    }

    @Override
    public int resetSaturation() {
        return 0;
    }

    @Override
    public int setHue(int hue) {
        return 0;
    }

    @Override
    public int getHue() {
        return 0;
    }

    @Override
    public int getHueDef() {
        return 0;
    }

    @Override
    public int resetHue() {
        return 0;
    }

    @Override
    public boolean setAutoHue(boolean autoHue) {
        return false;
    }

    @Override
    public boolean getAutoHue() {
        return false;
    }

    @Override
    public boolean getAutoHueDef() {
        return false;
    }

    @Override
    public boolean resetAutoHue() {
        return false;
    }

    @Override
    public int setPowerlineFrequency(int frequency) {
        return 0;
    }

    @Override
    public int getPowerlineFrequency() {
        return 0;
    }

    @Override
    public int getPowerlineFrequencyDef() {
        return 0;
    }

    @Override
    public int resetPowerlineFrequency() {
        return 0;
    }

    @Override
    public int setZoom(int zoom) {
        return 0;
    }

    @Override
    public int getZoom() {
        return 0;
    }

    @Override
    public int getZoomDef() {
        return 0;
    }

    @Override
    public int resetZoom() {
        return 0;
    }

    @Override
    public int setZoomRel(int zoom_rel, boolean digital_zoom) {
        return 0;
    }

    @Override
    public int getZoomRel() {
        return 0;
    }

    @Override
    public int getZoomRelDef() {
        return 0;
    }

    @Override
    public int resetZoomRel() {
        return 0;
    }

    @Override
    public int setDigitalMultiplier(int multiplier) {
        return 0;
    }

    @Override
    public int getDigitalMultiplier() {
        return 0;
    }

    @Override
    public int getDigitalMultiplierDef() {
        return 0;
    }

    @Override
    public int resetDigitalMultiplier() {
        return 0;
    }

    @Override
    public int setDigitalMultiplierLimit(int multiplier_limit_abs) {
        return 0;
    }

    @Override
    public int getDigitalMultiplierLimit() {
        return 0;
    }

    @Override
    public int getDigitalMultiplierLimitDef() {
        return 0;
    }

    @Override
    public int resetDigitalMultiplierLimit() {
        return 0;
    }

    @Override
    public int setAnalogVideoStandard(int standard) {
        return 0;
    }

    @Override
    public int getAnalogVideoStandard() {
        return 0;
    }

    @Override
    public int getAnalogVideoStandardDef() {
        return 0;
    }

    @Override
    public int resetAnalogVideoStandard() {
        return 0;
    }

    @Override
    public boolean setAnalogVideoLockState(boolean locked) {
        return false;
    }

    @Override
    public boolean getAnalogVideoLockState() {
        return false;
    }

    @Override
    public boolean getAnalogVideoLockStateDef() {
        return false;
    }

    @Override
    public boolean resetAnalogVideoLockState() {
        return false;
    }

    private native long nativeCreate();

    private native void nativeDestroy(long var1);

    private static native int nativeConnect(long var0, int var2);

    private static native int nativeDisconnect(long var0);

    private static native int nativeOutputDescriptor(long var0, int var2, int var3, int var4, String var5);

    private static final native String nativeGetSupportedSize(long var0);

    private static final native int nativeSetVideoSize(long var0, int var2, int var3, int var4, float var5, float var6, float var7);

    private static native int nativeStartStream(long var0);

    private static native int nativeStopStream(long var0);

    static {
        NativeLibLoader.loadNative();
    }
}

