/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.serenegiant.common.R;
import com.serenegiant.view.ViewUtils;
import com.serenegiant.widget.DividerItemDecoration;

public class RecyclerViewWithEmptyView
extends RecyclerView {
    private static final boolean DEBUG = false;
    private static final String TAG = RecyclerViewWithEmptyView.class.getSimpleName();
    @IdRes
    private int mEmptyViewId;
    @Nullable
    private View mEmptyView;
    private final RecyclerView.AdapterDataObserver mAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            super.onChanged();
            RecyclerViewWithEmptyView.this.updateEmptyView();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            super.onItemRangeChanged(positionStart, itemCount);
            RecyclerViewWithEmptyView.this.updateEmptyView();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            super.onItemRangeRemoved(positionStart, itemCount);
            RecyclerViewWithEmptyView.this.updateEmptyView();
        }
    };

    public RecyclerViewWithEmptyView(@NonNull Context context) {
        this(context, null, 0);
    }

    public RecyclerViewWithEmptyView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @SuppressLint(value={"WrongConstant"})
    public RecyclerViewWithEmptyView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Drawable divider = null;
        if (attrs != null) {
            int defStyleRes = 0;
            TypedArray attribs = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RecycleViewWithEmptyView, defStyle, defStyleRes);
            try {
                if (attribs.hasValue(R.styleable.RecycleViewWithEmptyView_listDivider)) {
                    divider = attribs.getDrawable(R.styleable.RecycleViewWithEmptyView_listDivider);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mEmptyViewId = attribs.getResourceId(R.styleable.RecyclerViewWithEmptyView_emptyView, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            attribs.recycle();
        }
        int orientation = 1;
        if (this.getLayoutManager() instanceof LinearLayoutManager) {
            orientation = ((LinearLayoutManager)this.getLayoutManager()).getOrientation();
        }
        DividerItemDecoration deco = new DividerItemDecoration(context, divider);
        deco.setOrientation(orientation);
        this.addItemDecoration(deco);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.getAdapter() != adapter) {
            try {
                if (this.getAdapter() != null) {
                    this.getAdapter().unregisterAdapterDataObserver(this.mAdapterDataObserver);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.setAdapter(adapter);
            if (adapter != null) {
                adapter.registerAdapterDataObserver(this.mAdapterDataObserver);
            }
        }
        this.updateEmptyView();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        int[] ids = new int[]{this.mEmptyViewId, R.id.empty, 16908292};
        View emptyView = ViewUtils.findViewInParent((View)this, ids, View.class);
        this.setEmptyView(emptyView);
    }

    public void setEmptyView(View empty_view) {
        if (this.mEmptyView != empty_view) {
            this.mEmptyView = empty_view;
            this.updateEmptyView();
        }
    }

    protected void updateEmptyView() {
        if (this.mEmptyView != null && !this.isInEditMode()) {
            final RecyclerView.Adapter adapter = this.getAdapter();
            this.post(new Runnable(){

                @Override
                public void run() {
                    RecyclerViewWithEmptyView.this.mEmptyView.setVisibility(adapter == null || adapter.getItemCount() == 0 ? 0 : 8);
                }
            });
        }
    }
}

