/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.serenegiant.common.R;
import com.serenegiant.view.MeasureSpecDelegater;
import com.serenegiant.widget.IScaledView;

public class AspectRatioFrameLayout
extends FrameLayout
implements IScaledView {
    private int mScaleMode = 0;
    private double mRequestedAspect = -1.0;
    private boolean mNeedResizeToKeepAspect;

    public AspectRatioFrameLayout(Context context) {
        this(context, null, 0);
    }

    public AspectRatioFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectRatioFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IScaledView, defStyleAttr, 0);
        try {
            this.mRequestedAspect = a.getFloat(R.styleable.IScaledView_aspect_ratio, -1.0f);
            this.mScaleMode = a.getInt(R.styleable.IScaledView_scale_mode, 0);
            this.mNeedResizeToKeepAspect = a.getBoolean(R.styleable.IScaledView_resize_to_keep_aspect, true);
        }
        finally {
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecDelegater.MeasureSpec spec = MeasureSpecDelegater.onMeasure((View)this, this.mRequestedAspect, this.mScaleMode, this.mNeedResizeToKeepAspect, widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(spec.widthMeasureSpec, spec.heightMeasureSpec);
    }

    @Override
    public void setScaleMode(int scaleMode) {
        if (this.mScaleMode != scaleMode) {
            this.mScaleMode = scaleMode;
            this.requestLayout();
        }
    }

    @Override
    public int getScaleMode() {
        return this.mScaleMode;
    }

    @Override
    public void setAspectRatio(double aspectRatio) {
        if (this.mRequestedAspect != aspectRatio) {
            this.mRequestedAspect = aspectRatio;
            this.requestLayout();
        }
    }

    @Override
    public void setAspectRatio(int width, int height) {
        this.setAspectRatio((double)width / (double)height);
    }

    @Override
    public double getAspectRatio() {
        return this.mRequestedAspect;
    }

    @Override
    public void setNeedResizeToKeepAspect(boolean keepAspect) {
        if (this.mNeedResizeToKeepAspect != keepAspect) {
            this.mNeedResizeToKeepAspect = keepAspect;
            this.requestLayout();
        }
    }
}

