/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadPool {
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAX_POOL_SIZE = 32;
    private static final int KEEP_ALIVE_TIME_SECS = 10;
    private static PausableThreadPoolExecutor EXECUTOR;

    private ThreadPool() {
    }

    @NonNull
    private static synchronized PausableThreadPoolExecutor getInstance() {
        if (EXECUTOR == null) {
            EXECUTOR = new PausableThreadPoolExecutor(1, 32, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
        return EXECUTOR;
    }

    public static synchronized boolean isShutdown() {
        return EXECUTOR == null || EXECUTOR.isShutdown();
    }

    public static synchronized void shutdown() {
        if (EXECUTOR != null) {
            EXECUTOR.resume();
            EXECUTOR.shutdown();
            EXECUTOR = null;
        }
    }

    @NonNull
    public static synchronized List<Runnable> shutdownNow() {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        if (EXECUTOR != null) {
            List<Runnable> list = EXECUTOR.shutdownNow();
            if (list != null) {
                result.addAll(list);
            }
            EXECUTOR = null;
        }
        return result;
    }

    public void resume() {
        ThreadPool.getInstance().resume();
    }

    public void pause() {
        ThreadPool.getInstance().pause();
    }

    public static void setCorePoolSize(int corePoolSize) {
        ThreadPool.getInstance().setCorePoolSize(corePoolSize);
    }

    public static void setMaximumPoolSize(int maximumPoolSize) {
        ThreadPool.getInstance().setMaximumPoolSize(maximumPoolSize);
    }

    public static void setKeepAliveTime(long time, TimeUnit unit) {
        ThreadPool.getInstance().setKeepAliveTime(time, unit);
    }

    public static void preStartAllCoreThreads() {
        ThreadPool.getInstance().prestartAllCoreThreads();
    }

    public static void queueEvent(@NonNull Runnable command) throws RejectedExecutionException {
        ThreadPool.getInstance().execute(command);
    }

    public static boolean removeEvent(@NonNull Runnable command) {
        return ThreadPool.getInstance().remove(command);
    }

    static {
        ThreadPool.getInstance();
    }

    private static class PausableThreadPoolExecutor
    extends ThreadPoolExecutor {
        private boolean isPaused = false;
        private ReentrantLock pauseLock = new ReentrantLock();
        private Condition unpaused = this.pauseLock.newCondition();

        public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
            this.allowCoreThreadTimeOut(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            this.pauseLock.lock();
            try {
                while (this.isPaused) {
                    this.unpaused.await();
                }
            }
            catch (InterruptedException ie) {
                t.interrupt();
            }
            finally {
                this.pauseLock.unlock();
            }
        }

        public void pause() {
            this.pauseLock.lock();
            try {
                this.isPaused = true;
            }
            finally {
                this.pauseLock.unlock();
            }
        }

        public void resume() {
            this.pauseLock.lock();
            try {
                this.isPaused = false;
                this.unpaused.signalAll();
            }
            finally {
                this.pauseLock.unlock();
            }
        }
    }
}

