/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.XmlResourceParser;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.XmlRes;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.usb.UsbDeviceInfo;
import com.serenegiant.utils.XmlHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class DeviceFilter
implements Parcelable {
    private static final String TAG = "DeviceFilter";
    public final int mVendorId;
    public final int mProductId;
    public final int mClass;
    public final int mSubclass;
    public final int mProtocol;
    @Nullable
    public final String mManufacturerName;
    @Nullable
    public final String mProductName;
    @Nullable
    public final String mSerialNumber;
    @NonNull
    public final int[] mIntfClass;
    @NonNull
    public final int[] mIntfSubClass;
    @NonNull
    public final int[] mIntfProtocol;
    public final boolean isExclude;
    public static final Parcelable.Creator<DeviceFilter> CREATOR = new Parcelable.Creator<DeviceFilter>(){

        public DeviceFilter createFromParcel(Parcel in) {
            return new DeviceFilter(in);
        }

        public DeviceFilter[] newArray(int size) {
            return new DeviceFilter[size];
        }
    };

    @NonNull
    public static List<DeviceFilter> getDeviceFilters(@NonNull Context context, @XmlRes int deviceFilterXmlId) {
        XmlResourceParser parser = context.getResources().getXml(deviceFilterXmlId);
        ArrayList<DeviceFilter> deviceFilters = new ArrayList<DeviceFilter>();
        try {
            int eventType = parser.getEventType();
            while (eventType != 1) {
                DeviceFilter deviceFilter;
                if (eventType == 2 && (deviceFilter = DeviceFilter.readEntryOne(context, (XmlPullParser)parser)) != null) {
                    deviceFilters.add(deviceFilter);
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            Log.d((String)TAG, (String)"XmlPullParserException", (Throwable)e);
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"IOException", (Throwable)e);
        }
        return Collections.unmodifiableList(deviceFilters);
    }

    @Nullable
    public static DeviceFilter readEntryOne(@NonNull Context context, @NonNull XmlPullParser parser) throws XmlPullParserException, IOException {
        int vendorId = -1;
        int productId = -1;
        int deviceClass = -1;
        int deviceSubclass = -1;
        int deviceProtocol = -1;
        boolean exclude = false;
        String manufacturerName = null;
        String productName = null;
        String serialNumber = null;
        int[] intfClass = null;
        int[] intfSubClass = null;
        int[] intfProtocol = null;
        boolean hasValue = false;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            String tag = parser.getName();
            if ("usb-device".equalsIgnoreCase(tag)) {
                if (eventType == 2) {
                    hasValue = true;
                    vendorId = XmlHelper.getAttribute(context, parser, null, "vendor-id", -1);
                    if (vendorId == -1) {
                        vendorId = XmlHelper.getAttribute(context, parser, null, "vendorId", -1);
                    }
                    if (vendorId == -1) {
                        vendorId = XmlHelper.getAttribute(context, parser, null, "venderId", -1);
                    }
                    if ((productId = XmlHelper.getAttribute(context, parser, null, "product-id", -1)) == -1) {
                        productId = XmlHelper.getAttribute(context, parser, null, "productId", -1);
                    }
                    deviceClass = XmlHelper.getAttribute(context, parser, null, "class", -1);
                    deviceSubclass = XmlHelper.getAttribute(context, parser, null, "subclass", -1);
                    deviceProtocol = XmlHelper.getAttribute(context, parser, null, "protocol", -1);
                    manufacturerName = XmlHelper.getAttribute(context, parser, null, "manufacturer-name", "");
                    if (TextUtils.isEmpty((CharSequence)manufacturerName)) {
                        manufacturerName = XmlHelper.getAttribute(context, parser, null, "manufacture", "");
                    }
                    if (TextUtils.isEmpty((CharSequence)(productName = XmlHelper.getAttribute(context, parser, null, "product-name", "")))) {
                        productName = XmlHelper.getAttribute(context, parser, null, "product", "");
                    }
                    if (TextUtils.isEmpty((CharSequence)(serialNumber = XmlHelper.getAttribute(context, parser, null, "serial-number", "")))) {
                        serialNumber = XmlHelper.getAttribute(context, parser, null, "serial", "");
                    }
                    exclude = XmlHelper.getAttribute(context, parser, null, "exclude", false);
                    if (!TextUtils.isEmpty((CharSequence)parser.getAttributeValue(null, "interfaceClass")) && (intfClass = XmlHelper.getAttribute(context, parser, null, "interfaceClass", new int[0])) != null && intfClass.length == 0) {
                        intfClass = null;
                    }
                    if (!TextUtils.isEmpty((CharSequence)parser.getAttributeValue(null, "interfaceSubClass")) && (intfSubClass = XmlHelper.getAttribute(context, parser, null, "interfaceSubClass", new int[0])) != null && intfSubClass.length == 0) {
                        intfSubClass = null;
                    }
                    if (!TextUtils.isEmpty((CharSequence)parser.getAttributeValue(null, "interfaceProtocol")) && (intfProtocol = XmlHelper.getAttribute(context, parser, null, "interfaceProtocol", new int[0])) != null && intfProtocol.length == 0) {
                        intfProtocol = null;
                    }
                } else if (eventType == 3 && hasValue) {
                    return new DeviceFilter(vendorId, productId, deviceClass, deviceSubclass, deviceProtocol, manufacturerName, productName, serialNumber, intfClass, intfSubClass, intfProtocol, exclude);
                }
            }
            eventType = parser.next();
        }
        return null;
    }

    public DeviceFilter(int vid, int pid) {
        this(vid, pid, -1, -1, -1, null, null, null, null, null, null, false);
    }

    public DeviceFilter(int vid, int pid, int clasz, int subclass, int protocol) {
        this(vid, pid, clasz, subclass, protocol, null, null, null, null, null, null, false);
    }

    public DeviceFilter(int vid, int pid, int clasz, int subclass, int protocol, String manufacturer, String product, String serialNum) {
        this(vid, pid, clasz, subclass, protocol, manufacturer, product, serialNum, null, null, null, false);
    }

    public DeviceFilter(int vid, int pid, int clazz, int subclass, int protocol, String manufacturer, String product, String serialNum, @Nullable int[] intfClass, @Nullable int[] intfSubClass, @Nullable int[] intfProtocol, boolean isExclude) {
        this.mVendorId = vid;
        this.mProductId = pid;
        this.mClass = clazz;
        this.mSubclass = subclass;
        this.mProtocol = protocol;
        this.mIntfClass = intfClass != null ? intfClass : new int[]{};
        this.mIntfSubClass = intfSubClass != null ? intfSubClass : new int[]{};
        this.mIntfProtocol = intfProtocol != null ? intfProtocol : new int[]{};
        this.mManufacturerName = TextUtils.isEmpty((CharSequence)manufacturer) ? null : manufacturer;
        this.mProductName = TextUtils.isEmpty((CharSequence)product) ? null : product;
        this.mSerialNumber = TextUtils.isEmpty((CharSequence)serialNum) ? null : serialNum;
        this.isExclude = isExclude;
    }

    public DeviceFilter(@NonNull UsbDevice device) {
        this(device, false);
    }

    @SuppressLint(value={"NewApi"})
    public DeviceFilter(@NonNull UsbDevice device, boolean isExclude) {
        this.mVendorId = device.getVendorId();
        this.mProductId = device.getProductId();
        this.mClass = device.getDeviceClass();
        this.mSubclass = device.getDeviceSubclass();
        this.mProtocol = device.getDeviceProtocol();
        int count = Math.max(device.getInterfaceCount(), 0);
        this.mIntfClass = new int[count];
        this.mIntfSubClass = new int[count];
        this.mIntfProtocol = new int[count];
        for (int i = 0; i < count; ++i) {
            UsbInterface intf = device.getInterface(i);
            this.mIntfClass[i] = intf.getInterfaceClass();
            this.mIntfSubClass[i] = intf.getInterfaceSubclass();
            this.mIntfProtocol[i] = intf.getInterfaceProtocol();
        }
        if (BuildCheck.isLollipop()) {
            this.mManufacturerName = device.getManufacturerName();
            this.mProductName = device.getProductName();
            this.mSerialNumber = device.getSerialNumber();
        } else {
            this.mManufacturerName = null;
            this.mProductName = null;
            this.mSerialNumber = null;
        }
        this.isExclude = isExclude;
    }

    protected DeviceFilter(@NonNull Parcel in) {
        this.mVendorId = in.readInt();
        this.mProductId = in.readInt();
        this.mClass = in.readInt();
        this.mSubclass = in.readInt();
        this.mProtocol = in.readInt();
        this.mManufacturerName = in.readString();
        this.mProductName = in.readString();
        this.mSerialNumber = in.readString();
        this.mIntfClass = in.createIntArray();
        this.mIntfSubClass = in.createIntArray();
        this.mIntfProtocol = in.createIntArray();
        this.isExclude = in.readByte() != 0;
    }

    public boolean matches(@NonNull UsbDevice device) {
        if (this.mVendorId != -1 && device.getVendorId() != this.mVendorId) {
            return false;
        }
        if (this.mProductId != -1 && device.getProductId() != this.mProductId) {
            return false;
        }
        if (this.matches(device.getDeviceClass(), device.getDeviceSubclass(), device.getDeviceProtocol())) {
            return true;
        }
        return this.interfaceMatches(device);
    }

    public boolean matches(@Nullable UsbDeviceInfo info) {
        if (info == null || info.device == null) {
            return false;
        }
        if (this.mManufacturerName != null && info.manufacturer != null && !this.mManufacturerName.equals(info.manufacturer)) {
            return false;
        }
        if (this.mProductName != null && info.product != null && !this.mProductName.equals(info.product)) {
            return false;
        }
        if (this.mSerialNumber != null && info.serial != null && !this.mSerialNumber.equals(info.serial)) {
            return false;
        }
        return this.matches(info.device);
    }

    public boolean isExclude(@NonNull UsbDevice device) {
        return this.isExclude && this.matches(device);
    }

    public boolean equals(Object obj) {
        if (this.mVendorId == -1 || this.mProductId == -1 || this.mClass == -1 || this.mSubclass == -1 || this.mProtocol == -1) {
            return false;
        }
        if (obj instanceof DeviceFilter) {
            DeviceFilter filter = (DeviceFilter)obj;
            if (filter.mVendorId != this.mVendorId || filter.mProductId != this.mProductId || filter.mClass != this.mClass || filter.mSubclass != this.mSubclass || filter.mProtocol != this.mProtocol) {
                return false;
            }
            if (filter.mManufacturerName != null && this.mManufacturerName == null || filter.mManufacturerName == null && this.mManufacturerName != null || filter.mProductName != null && this.mProductName == null || filter.mProductName == null && this.mProductName != null || filter.mSerialNumber != null && this.mSerialNumber == null || filter.mSerialNumber == null && this.mSerialNumber != null) {
                return false;
            }
            if (filter.mManufacturerName != null && this.mManufacturerName != null && !this.mManufacturerName.equals(filter.mManufacturerName) || filter.mProductName != null && this.mProductName != null && !this.mProductName.equals(filter.mProductName) || filter.mSerialNumber != null && this.mSerialNumber != null && !this.mSerialNumber.equals(filter.mSerialNumber)) {
                return false;
            }
            return filter.isExclude != this.isExclude;
        }
        if (obj instanceof UsbDevice) {
            UsbDevice device = (UsbDevice)obj;
            return !this.isExclude && device.getVendorId() == this.mVendorId && device.getProductId() == this.mProductId && device.getDeviceClass() == this.mClass && device.getDeviceSubclass() == this.mSubclass && device.getDeviceProtocol() == this.mProtocol;
        }
        return false;
    }

    public int hashCode() {
        return (this.mVendorId << 16 | this.mProductId) ^ (this.mClass << 16 | this.mSubclass << 8 | this.mProtocol);
    }

    @NonNull
    public String toString() {
        return "DeviceFilter{mVendorId=" + this.mVendorId + ", mProductId=" + this.mProductId + ", mClass=" + this.mClass + ", mSubclass=" + this.mSubclass + ", mProtocol=" + this.mProtocol + ", mManufacturerName='" + this.mManufacturerName + '\'' + ", mProductName='" + this.mProductName + '\'' + ", mSerialNumber='" + this.mSerialNumber + '\'' + ", mIntfClass=" + Arrays.toString(this.mIntfClass) + ", mIntfSubClass=" + Arrays.toString(this.mIntfSubClass) + ", mIntfProtocol=" + Arrays.toString(this.mIntfProtocol) + ", isExclude=" + this.isExclude + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mVendorId);
        dest.writeInt(this.mProductId);
        dest.writeInt(this.mClass);
        dest.writeInt(this.mSubclass);
        dest.writeInt(this.mProtocol);
        dest.writeString(this.mManufacturerName);
        dest.writeString(this.mProductName);
        dest.writeString(this.mSerialNumber);
        dest.writeIntArray(this.mIntfClass);
        dest.writeIntArray(this.mIntfSubClass);
        dest.writeIntArray(this.mIntfProtocol);
        dest.writeByte((byte)(this.isExclude ? 1 : 0));
    }

    private boolean matches(int clazz, int subclass, int protocol) {
        return !(this.mClass != -1 && clazz != this.mClass || this.mSubclass != -1 && subclass != this.mSubclass || this.mProtocol != -1 && protocol != this.mProtocol);
    }

    private boolean matchesIntfClass(int clazz) {
        if (this.mIntfClass.length > 0) {
            for (int intfClass : this.mIntfClass) {
                if (intfClass != clazz) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean matchesIntfSubClass(int subClazz) {
        if (this.mIntfSubClass.length > 0) {
            for (int value : this.mIntfSubClass) {
                if (value != subClazz) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean matchesIntfProtocol(int protocol) {
        if (this.mIntfProtocol.length > 0) {
            for (int value : this.mIntfProtocol) {
                if (value != protocol) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean interfaceMatches(int clazz, int subclass, int protocol) {
        return this.mIntfClass.length > 0 && this.mIntfSubClass.length > 0 && this.mIntfProtocol.length > 0 && this.matchesIntfClass(clazz) && this.matchesIntfSubClass(subclass) && this.matchesIntfProtocol(protocol);
    }

    private boolean interfaceMatches(@NonNull UsbDevice device) {
        int count = device.getInterfaceCount();
        for (int i = 0; i < count; ++i) {
            UsbInterface intf = device.getInterface(i);
            if (this.matches(intf.getInterfaceClass(), intf.getInterfaceSubclass(), intf.getInterfaceProtocol())) {
                return true;
            }
            if (!this.interfaceMatches(intf.getInterfaceClass(), intf.getInterfaceSubclass(), intf.getInterfaceProtocol())) continue;
            return true;
        }
        return false;
    }
}

