/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.notification;

import android.annotation.SuppressLint;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.content.Context;
import android.content.res.XmlResourceParser;
import android.media.AudioAttributes;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.XmlRes;
import androidx.core.app.NotificationManagerCompat;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.ContextUtils;
import com.serenegiant.utils.ObjectHelper;
import com.serenegiant.utils.XmlHelper;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@SuppressLint(value={"InlinedApi"})
public class ChannelBuilder {
    private static final boolean DEBUG = false;
    private static final String TAG = ChannelBuilder.class.getSimpleName();
    public static final String DEFAULT_CHANNEL_ID = "miscellaneous";
    public static final Set<Integer> IMPORTANCE = new HashSet<Integer>();
    public static final Set<Integer> NOTIFICATION_VISIBILITY;
    @NonNull
    private final Context mContext;
    @NonNull
    private String channelId;
    @Nullable
    private CharSequence name;
    private int importance;
    private int lockscreenVisibility = 0;
    private boolean bypassDnd = false;
    private boolean showBadge = true;
    private String description;
    private int argb = 0;
    private boolean lights;
    private long[] vibrationPattern;
    private boolean vibration;
    private Uri sound;
    private AudioAttributes audioAttributes;
    @Nullable
    private String groupId;
    @Nullable
    private String groupName;
    private boolean createIfExists = true;

    @NonNull
    public static ChannelBuilder getBuilder(@NonNull Context context, @NonNull String channelId) {
        NotificationChannel channel = NotificationManagerCompat.from((Context)context).getNotificationChannel(channelId);
        if (channel != null) {
            ChannelBuilder builder = new ChannelBuilder(context, channelId, channel.getName(), channel.getImportance());
            builder.setLockscreenVisibility(channel.getLockscreenVisibility()).setBypassDnd(channel.canBypassDnd()).setShowBadge(channel.canShowBadge()).setDescription(channel.getDescription()).setLightColor(channel.getLightColor()).setVibrationPattern(channel.getVibrationPattern()).enableLights(channel.shouldShowLights()).enableVibration(channel.shouldVibrate()).setSound(channel.getSound(), channel.getAudioAttributes()).setGroup(channel.getGroup(), null).setCreateIfExists(true);
            return builder;
        }
        return new ChannelBuilder(context, channelId, null, 0);
    }

    @NonNull
    public static List<String> updateNotificationChannel(@NonNull Context context, @XmlRes int channelInfoXmlId) {
        ArrayList<String> result = new ArrayList<String>();
        XmlResourceParser parser = context.getResources().getXml(channelInfoXmlId);
        try {
            int eventType = parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    ChannelBuilder.readEntryOne(context, (XmlPullParser)parser, result);
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            Log.d((String)TAG, (String)"XmlPullParserException", (Throwable)e);
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"IOException", (Throwable)e);
        }
        return result;
    }

    @SuppressLint(value={"InlinedApi"})
    private static void readEntryOne(@NonNull Context context, @NonNull XmlPullParser parser, @NonNull List<String> result) throws XmlPullParserException, IOException {
        ChannelBuilder builder = null;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            String tag = parser.getName();
            if (!TextUtils.isEmpty((CharSequence)tag) && tag.equalsIgnoreCase("notificationChannel")) {
                if (eventType == 2) {
                    String channelId = XmlHelper.getAttribute(context, parser, null, "channelId", "");
                    if (!TextUtils.isEmpty((CharSequence)channelId)) {
                        builder = ChannelBuilder.getBuilder(context, channelId).setCreateIfExists(false);
                        int n = parser.getAttributeCount();
                        block29: for (int i = 0; i < n; ++i) {
                            String attrName = parser.getAttributeName(i);
                            if (TextUtils.isEmpty((CharSequence)attrName)) continue;
                            switch (attrName) {
                                case "name": {
                                    builder.setName(XmlHelper.getAttribute(context, parser, null, "name", builder.getName()));
                                    continue block29;
                                }
                                case "importance": {
                                    int importance = XmlHelper.getAttribute(context, parser, null, "importance", builder.getImportance());
                                    builder.setImportance(importance);
                                    continue block29;
                                }
                                case "lockscreenVisibility": {
                                    int lockscreenVisibility = XmlHelper.getAttribute(context, parser, null, "lockscreenVisibility", builder.getLockscreenVisibility());
                                    if (!NOTIFICATION_VISIBILITY.contains(lockscreenVisibility)) continue block29;
                                    builder.setLockscreenVisibility(lockscreenVisibility);
                                    continue block29;
                                }
                                case "bypassDnd": {
                                    builder.setBypassDnd(XmlHelper.getAttribute(context, parser, null, "bypassDnd", builder.canBypassDnd()));
                                    continue block29;
                                }
                                case "showBadge": {
                                    builder.setShowBadge(XmlHelper.getAttribute(context, parser, null, "showBadge", builder.canShowBadge()));
                                    continue block29;
                                }
                                case "description": {
                                    builder.setDescription(XmlHelper.getAttribute(context, parser, null, "description", builder.getDescription()));
                                    continue block29;
                                }
                                case "light": {
                                    builder.setLightColor(XmlHelper.getAttribute(context, parser, null, "light", builder.getLightColor()));
                                }
                                case "enableLights": {
                                    builder.enableLights(XmlHelper.getAttribute(context, parser, null, "enableLights", builder.shouldShowLights()));
                                    continue block29;
                                }
                                case "vibrationPattern": {
                                    String[] pats;
                                    String patternString = XmlHelper.getAttribute(context, parser, null, "vibrationPattern", "");
                                    if (TextUtils.isEmpty((CharSequence)patternString) || (pats = patternString.trim().split(",")).length <= 0) continue block29;
                                    long[] pattern = new long[pats.length];
                                    int ix = -1;
                                    for (String v : pats) {
                                        long val = ObjectHelper.asLong(v, 0L);
                                        pattern[++ix] = val;
                                    }
                                    if (ix < 0) continue block29;
                                    long[] p = Arrays.copyOf(pattern, ix + 1);
                                    builder.setVibrationPattern(p);
                                    continue block29;
                                }
                                case "enableVibration": {
                                    builder.enableVibration(XmlHelper.getAttribute(context, parser, null, "enableVibration", builder.shouldVibrate()));
                                    continue block29;
                                }
                                case "sound": {
                                    String uriString = XmlHelper.getAttribute(context, parser, null, "sound", "");
                                    if (TextUtils.isEmpty((CharSequence)uriString)) continue block29;
                                    builder.setSound(Uri.parse((String)uriString), null);
                                    continue block29;
                                }
                                case "createIfExists": {
                                    builder.setCreateIfExists(XmlHelper.getAttribute(context, parser, null, "createIfExists", false));
                                }
                            }
                        }
                    }
                } else if (eventType == 3 && builder != null) {
                    builder.build();
                    result.add(builder.getId());
                    return;
                }
            }
            eventType = parser.next();
        }
    }

    public ChannelBuilder(@NonNull Context context) {
        this(context, DEFAULT_CHANNEL_ID, DEFAULT_CHANNEL_ID, 0, null, null);
    }

    public ChannelBuilder(@NonNull Context context, @Nullable String channelId, @Nullable CharSequence name, int importance) {
        this(context, channelId, name, importance, null, null);
    }

    public ChannelBuilder(@NonNull Context context, @Nullable String channelId, @Nullable CharSequence name, int importance, @Nullable String groupId, @Nullable String groupName) {
        this.mContext = context;
        this.channelId = TextUtils.isEmpty((CharSequence)channelId) ? DEFAULT_CHANNEL_ID : channelId;
        this.name = name;
        this.importance = importance;
        this.groupId = groupId;
        this.groupName = groupName;
    }

    @NonNull
    public String toString() {
        return "ChannelBuilder{channelId='" + this.channelId + '\'' + ", name=" + this.name + ", importance=" + this.importance + ", lockscreenVisibility=" + this.lockscreenVisibility + ", bypassDnd=" + this.bypassDnd + ", showBadge=" + this.showBadge + ", description='" + this.description + '\'' + ", argb=" + this.argb + ", lights=" + this.lights + ", vibrationPattern=" + Arrays.toString(this.vibrationPattern) + ", vibration=" + this.vibration + ", sound=" + this.sound + ", audioAttributes=" + this.audioAttributes + ", groupId='" + this.groupId + '\'' + ", groupName='" + this.groupName + '\'' + ", createIfExists=" + this.createIfExists + '}';
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public NotificationChannel build() {
        if (BuildCheck.isOreo()) {
            return this.createNotificationChannel(this.mContext);
        }
        return null;
    }

    public ChannelBuilder setId(@Nullable String channelId) {
        this.channelId = TextUtils.isEmpty((CharSequence)channelId) ? DEFAULT_CHANNEL_ID : channelId;
        return this;
    }

    @NonNull
    public String getId() {
        return this.channelId;
    }

    public ChannelBuilder setName(@Nullable CharSequence name) {
        this.name = name;
        return this;
    }

    @Nullable
    public CharSequence getName() {
        return this.name;
    }

    public ChannelBuilder setImportance(int importance) {
        this.importance = importance;
        return this;
    }

    public int getImportance() {
        return this.importance;
    }

    public ChannelBuilder setLockscreenVisibility(int lockscreenVisibility) {
        this.lockscreenVisibility = lockscreenVisibility;
        return this;
    }

    public int getLockscreenVisibility() {
        return this.lockscreenVisibility;
    }

    public ChannelBuilder setBypassDnd(boolean bypassDnd) {
        this.bypassDnd = bypassDnd;
        return this;
    }

    public boolean canBypassDnd() {
        return this.bypassDnd;
    }

    public ChannelBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ChannelBuilder setLightColor(int argb) {
        this.argb = argb;
        return this;
    }

    public int getLightColor() {
        return this.argb;
    }

    public ChannelBuilder enableLights(boolean lights) {
        this.lights = lights;
        return this;
    }

    public boolean shouldShowLights() {
        return this.lights;
    }

    public ChannelBuilder setShowBadge(boolean showBadge) {
        this.showBadge = showBadge;
        return this;
    }

    public boolean canShowBadge() {
        return this.showBadge;
    }

    public ChannelBuilder setVibrationPattern(long[] vibrationPattern) {
        this.vibration = vibrationPattern != null && vibrationPattern.length > 0;
        this.vibrationPattern = vibrationPattern;
        return this;
    }

    public long[] getVibrationPattern() {
        return this.vibrationPattern;
    }

    public ChannelBuilder enableVibration(boolean vibration) {
        this.vibration = vibration;
        return this;
    }

    public boolean shouldVibrate() {
        return this.vibration && this.vibrationPattern != null && this.vibrationPattern.length > 0;
    }

    public ChannelBuilder setSound(Uri sound, AudioAttributes audioAttributes) {
        this.sound = sound;
        this.audioAttributes = audioAttributes;
        return this;
    }

    public Uri getSound() {
        return this.sound;
    }

    public AudioAttributes getAudioAttributes() {
        return this.audioAttributes;
    }

    public ChannelBuilder setGroup(@Nullable String groupId, @Nullable String groupName) {
        this.groupId = groupId;
        this.groupName = groupName;
        return this;
    }

    @Nullable
    public String getGroup() {
        return this.groupId;
    }

    @Nullable
    public String getGroupName() {
        return this.groupName;
    }

    public ChannelBuilder setCreateIfExists(boolean createIfExists) {
        this.createIfExists = createIfExists;
        return this;
    }

    public boolean isCreateIfExists() {
        return this.createIfExists;
    }

    @RequiresApi(value=26)
    @Nullable
    protected NotificationChannel createNotificationChannel(@NonNull Context context) {
        NotificationManager manager = ContextUtils.requireSystemService(context, NotificationManager.class);
        NotificationChannel channel = manager.getNotificationChannel(this.channelId);
        if (this.createIfExists || channel == null) {
            if (this.importance == 0) {
                this.importance = 3;
            }
            if (channel == null) {
                channel = new NotificationChannel(this.channelId, this.name, this.importance);
            }
            channel.setImportance(this.importance);
            channel.setLockscreenVisibility(this.lockscreenVisibility);
            channel.setBypassDnd(this.bypassDnd);
            channel.setShowBadge(this.showBadge);
            channel.setLightColor(this.argb);
            channel.enableLights(this.lights);
            channel.setVibrationPattern(this.vibrationPattern);
            channel.enableVibration(this.vibration);
            channel.setSound(this.sound, this.audioAttributes);
        }
        if (channel != null) {
            if (!TextUtils.isEmpty((CharSequence)this.groupId)) {
                this.createNotificationChannelGroup(context, this.groupId, this.groupName);
            }
            channel.setName(this.name);
            channel.setDescription(this.description);
            channel.setGroup(this.groupId);
            manager.createNotificationChannel(this.setupNotificationChannel(channel));
        }
        return channel;
    }

    @NonNull
    protected NotificationChannel setupNotificationChannel(@NonNull NotificationChannel channel) {
        return channel;
    }

    @RequiresApi(value=26)
    protected void createNotificationChannelGroup(@NonNull Context context, @Nullable String groupId, @Nullable String groupName) {
        if (!TextUtils.isEmpty((CharSequence)groupId)) {
            NotificationManager manager = ContextUtils.requireSystemService(context, NotificationManager.class);
            List groups = manager.getNotificationChannelGroups();
            NotificationChannelGroup found = null;
            for (NotificationChannelGroup group : groups) {
                if (!groupId.equals(group.getId())) continue;
                found = group;
                break;
            }
            if (found == null) {
                found = new NotificationChannelGroup(groupId, (CharSequence)(TextUtils.isEmpty((CharSequence)groupName) ? groupId : groupName));
                manager.createNotificationChannelGroup(this.setupNotificationChannelGroup(found));
            }
        }
    }

    @NonNull
    protected NotificationChannelGroup setupNotificationChannelGroup(@NonNull NotificationChannelGroup group) {
        return group;
    }

    static {
        Collections.addAll(IMPORTANCE, -1000, 0, 1, 2, 3, 4, 5);
        NOTIFICATION_VISIBILITY = new HashSet<Integer>();
        Collections.addAll(NOTIFICATION_VISIBILITY, 1, 0, -1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotificationVisibility {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Importance {
    }
}

