/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.media.IAudioSampler;

public class AudioSampler
extends IAudioSampler {
    private static final String TAG = AudioSampler.class.getSimpleName();
    @NonNull
    private final Object mSync = new Object();
    @Nullable
    private AudioThread mAudioThread;
    private final int AUDIO_SOURCE;
    private final int SAMPLING_RATE;
    private final int CHANNEL_COUNT;
    private final int SAMPLES_PER_FRAME;
    private final int BUFFER_SIZE;
    private static final int AUDIO_FORMAT = 2;

    public AudioSampler(int audio_source, int channel_num, int sampling_rate, int samples_per_frame, int frames_per_buffer) {
        this.AUDIO_SOURCE = audio_source;
        this.CHANNEL_COUNT = channel_num;
        this.SAMPLING_RATE = sampling_rate;
        this.SAMPLES_PER_FRAME = samples_per_frame * channel_num;
        this.BUFFER_SIZE = AudioSampler.getAudioBufferSize(channel_num, sampling_rate, samples_per_frame, frames_per_buffer);
    }

    @Override
    public int getBufferSize() {
        return this.SAMPLES_PER_FRAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        super.start();
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAudioThread == null) {
                this.init_pool(this.SAMPLES_PER_FRAME);
                this.mAudioThread = new AudioThread();
                this.mAudioThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        Object object = this.mSync;
        synchronized (object) {
            this.mIsCapturing = false;
            this.mAudioThread = null;
            this.mSync.notify();
        }
        super.stop();
    }

    @Override
    public int getAudioSource() {
        return this.AUDIO_SOURCE;
    }

    public static int getAudioBufferSize(int channel_num, int sampling_rate, int samples_per_frame, int frames_per_buffer) {
        int buffer_size = samples_per_frame * frames_per_buffer;
        int min_buffer_size = AudioRecord.getMinBufferSize((int)sampling_rate, (int)(channel_num == 1 ? 16 : 12), (int)2);
        if (buffer_size < min_buffer_size) {
            buffer_size = (min_buffer_size / samples_per_frame + 1) * samples_per_frame * 2 * channel_num;
        }
        return buffer_size;
    }

    @Override
    public int getChannels() {
        return this.CHANNEL_COUNT;
    }

    @Override
    public int getSamplingFrequency() {
        return this.SAMPLING_RATE;
    }

    @Override
    public int getBitResolution() {
        return 16;
    }

    static /* synthetic */ int access$000(AudioSampler x0) {
        return x0.AUDIO_SOURCE;
    }

    static /* synthetic */ int access$100(AudioSampler x0) {
        return x0.SAMPLING_RATE;
    }

    static /* synthetic */ int access$200(AudioSampler x0) {
        return x0.CHANNEL_COUNT;
    }

    static /* synthetic */ int access$300(AudioSampler x0) {
        return x0.BUFFER_SIZE;
    }

    static /* synthetic */ String access$400() {
        return TAG;
    }

    static /* synthetic */ Object access$500(AudioSampler x0) {
        return x0.mSync;
    }

    static /* synthetic */ int access$600(AudioSampler x0) {
        return x0.SAMPLES_PER_FRAME;
    }

    private final class AudioThread
    extends Thread {
        public AudioThread() {
            super("AudioThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public final void run() {
            Process.setThreadPriority((int)-16);
            retry = 3;
            block18: while (AudioSampler.this.mIsCapturing && retry > 0) {
                block33: {
                    block32: {
                        audioRecord = IAudioSampler.createAudioRecord(AudioSampler.access$000(AudioSampler.this), AudioSampler.access$100(AudioSampler.this), AudioSampler.access$200(AudioSampler.this), 2, AudioSampler.access$300(AudioSampler.this));
                        err_count = 0;
                        if (audioRecord == null) break block33;
                        try {
                            if (!AudioSampler.this.mIsCapturing) break block32;
                            audioRecord.startRecording();
                            try {
                                while (AudioSampler.this.mIsCapturing) {
                                    block36: {
                                        block35: {
                                            block34: {
                                                data = AudioSampler.this.obtain();
                                                if (data == null) ** GOTO lbl89
                                                recordingState = audioRecord.getRecordingState();
                                                if (recordingState != 3) {
                                                    if (err_count == 0) {
                                                        Log.e((String)AudioSampler.access$400(), (String)("not a recording state," + recordingState));
                                                    }
                                                    data.recycle();
                                                    if (++err_count > 20) {
                                                        --retry;
                                                        break;
                                                    }
                                                    var8_10 = AudioSampler.access$500(AudioSampler.this);
                                                    synchronized (var8_10) {
                                                        AudioSampler.access$500(AudioSampler.this).wait(100L);
                                                        continue;
                                                    }
                                                }
                                                buffer = data.get();
                                                buffer.clear();
                                                try {
                                                    readBytes = audioRecord.read(buffer, AudioSampler.access$600(AudioSampler.this));
                                                }
                                                catch (Exception e) {
                                                    Log.e((String)AudioSampler.access$400(), (String)("AudioRecord#read failed:" + e));
                                                    ++err_count;
                                                    --retry;
                                                    data.recycle();
                                                    AudioSampler.this.callOnError(e);
                                                    break;
                                                }
                                                if (readBytes > 0) {
                                                    err_count = 0;
                                                    data.presentationTimeUs(AudioSampler.this.getInputPTSUs()).size(readBytes);
                                                    buffer.position(readBytes);
                                                    buffer.flip();
                                                    AudioSampler.this.addMediaData(data);
                                                    continue;
                                                }
                                                if (readBytes == 0) {
                                                    err_count = 0;
                                                    data.recycle();
                                                    continue;
                                                }
                                                if (readBytes != -1) break block34;
                                                if (err_count == 0) {
                                                    Log.e((String)AudioSampler.access$400(), (String)"Read error ERROR");
                                                }
                                                ** GOTO lbl87
                                            }
                                            if (readBytes != -2) break block35;
                                            if (err_count == 0) {
                                                Log.e((String)AudioSampler.access$400(), (String)"Read error ERROR_BAD_VALUE");
                                            }
                                            ** GOTO lbl87
                                        }
                                        if (readBytes != -3) break block36;
                                        if (err_count == 0) {
                                            Log.e((String)AudioSampler.access$400(), (String)"Read error ERROR_INVALID_OPERATION");
                                        }
                                        ** GOTO lbl87
                                    }
                                    if (readBytes == -6) {
                                        Log.e((String)AudioSampler.access$400(), (String)"Read error ERROR_DEAD_OBJECT");
                                        ++err_count;
                                        --retry;
                                        data.recycle();
                                    } else {
                                        if (readBytes < 0 && err_count == 0) {
                                            Log.e((String)AudioSampler.access$400(), (String)("Read returned unknown err " + readBytes));
                                        }
lbl87:
                                        // 6 sources

                                        ++err_count;
                                        data.recycle();
lbl89:
                                        // 2 sources

                                        if (err_count <= 10) continue;
                                        --retry;
                                    }
                                    break;
                                }
                            }
                            finally {
                                audioRecord.stop();
                            }
                        }
                        catch (Exception e) {
                            --retry;
                            AudioSampler.this.callOnError(e);
                        }
                        finally {
                            audioRecord.release();
                        }
                    }
                    if (!AudioSampler.this.mIsCapturing || err_count <= 0 || retry <= 0) continue;
                    for (i = 0; AudioSampler.this.mIsCapturing && i < 5; ++i) {
                        var5_6 = AudioSampler.access$500(AudioSampler.this);
                        synchronized (var5_6) {
                            try {
                                AudioSampler.access$500(AudioSampler.this).wait(100L);
                            }
                            catch (InterruptedException e) {
                                break block18;
                            }
                        }
                    }
                    continue;
                }
                AudioSampler.this.callOnError(new RuntimeException("AudioRecord failed to initialize"));
                retry = 0;
            }
            AudioSampler.this.stop();
        }
    }

    protected static final class AudioRecordRec {
        AudioRecord audioRecord;
        int bufferSize;

        protected AudioRecordRec() {
        }
    }
}

