/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.glutils.AbstractRendererHolder;
import com.serenegiant.glutils.IRendererHolder;

public class OverlayRendererHolder
extends AbstractRendererHolder {
    private static final boolean DEBUG = false;
    private static final String TAG = OverlayRendererHolder.class.getSimpleName();
    private static final String FRAGMENT_SHADER_BASE_ES2 = "#version 100\n%sprecision highp float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nvoid main() {\n    highp vec4 tex1 = texture2D(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture2D(sTexture2, vTextureCoord);\n    gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a), tex1.a);\n}\n";
    private static final String MY_FRAGMENT_SHADER_EXT_ES2 = String.format("#version 100\n%sprecision highp float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nvoid main() {\n    highp vec4 tex1 = texture2D(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture2D(sTexture2, vTextureCoord);\n    gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a), tex1.a);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "samplerExternalOES");
    private static final String FRAGMENT_SHADER_BASE_ES3 = "#version 300 es\n%sprecision highp float;\nin vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nlayout(location = 0) out vec4 o_FragColor;\nvoid main() {\n    highp vec4 tex1 = texture(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture(sTexture2, vTextureCoord);\n    o_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a), tex1.a);\n}\n";
    private static final String MY_FRAGMENT_SHADER_EXT_ES3 = String.format("#version 300 es\n%sprecision highp float;\nin vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nlayout(location = 0) out vec4 o_FragColor;\nvoid main() {\n    highp vec4 tex1 = texture(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture(sTexture2, vTextureCoord);\n    o_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a), tex1.a);\n}\n", "#extension GL_OES_EGL_image_external_essl3 : require\n", "samplerExternalOES", "samplerExternalOES");
    private static final int REQUEST_UPDATE_OVERLAY = 100;

    public OverlayRendererHolder(int width, int height, @Nullable IRendererHolder.RenderHolderCallback callback) {
        this(width, height, 3, null, 2, callback);
    }

    public OverlayRendererHolder(int width, int height, int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags, @Nullable IRendererHolder.RenderHolderCallback callback) {
        super(width, height, maxClientVersion, sharedContext, flags, callback);
        this.setOverlay(0, null);
    }

    @Override
    @NonNull
    protected AbstractRendererHolder.BaseRendererTask createRendererTask(int width, int height, int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags) {
        return new OverlayRendererTask(this, width, height, maxClientVersion, sharedContext, flags, null);
    }

    public void setOverlay(int id2, @Nullable Bitmap overlay) {
        ((OverlayRendererTask)this.mRendererTask).setOverlay(id2, overlay);
    }

    private static final class OverlayRendererTask
    extends AbstractRendererHolder.BaseRendererTask {
        @Size(min=16L)
        @NonNull
        private final float[] mTexMatrixOverlay = new float[16];
        private int mOverlayTexId;
        private SurfaceTexture mOverlayTexture;
        private Surface mOverlaySurface;

        public OverlayRendererTask(@NonNull AbstractRendererHolder parent, int width, int height, int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags, @Nullable GLDrawer2D.DrawerFactory factory) {
            super(parent, width, height, maxClientVersion, sharedContext, flags, factory);
        }

        public void setOverlay(int id2, @Nullable Bitmap overlay) {
            this.checkFinished();
            this.offer(100, id2, 0, overlay);
        }

        @Override
        @WorkerThread
        protected void internalOnStart() {
            super.internalOnStart();
            GLDrawer2D drawer = this.getDrawer();
            if (drawer != null) {
                if (this.isGLES3()) {
                    this.internalOnStartES3(drawer);
                } else {
                    this.internalOnStartES2(drawer);
                }
            }
        }

        @WorkerThread
        private void internalOnStartES2(@NonNull GLDrawer2D drawer) {
            drawer.updateShader(MY_FRAGMENT_SHADER_EXT_ES2);
            int uTex1 = drawer.glGetUniformLocation("sTexture");
            GLES20.glUniform1i((int)uTex1, (int)0);
            int uTex2 = drawer.glGetUniformLocation("sTexture2");
            this.mOverlayTexId = GLUtils.initTex(36197, 33985, 9729, 9729, 33071);
            this.mOverlayTexture = new SurfaceTexture(this.mOverlayTexId);
            this.mOverlayTexture.setDefaultBufferSize(this.width(), this.height());
            this.mOverlaySurface = new Surface(this.mOverlayTexture);
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)36197, (int)this.mOverlayTexId);
            GLES20.glUniform1i((int)uTex2, (int)1);
        }

        @WorkerThread
        private void internalOnStartES3(@NonNull GLDrawer2D drawer) {
            drawer.updateShader(MY_FRAGMENT_SHADER_EXT_ES3);
            int uTex1 = drawer.glGetUniformLocation("sTexture");
            GLES30.glUniform1i((int)uTex1, (int)0);
            int uTex2 = drawer.glGetUniformLocation("sTexture2");
            this.mOverlayTexId = GLUtils.initTex(36197, 33985, 9729, 9729, 33071);
            this.mOverlayTexture = new SurfaceTexture(this.mOverlayTexId);
            this.mOverlayTexture.setDefaultBufferSize(this.width(), this.height());
            this.mOverlaySurface = new Surface(this.mOverlayTexture);
            GLES30.glActiveTexture((int)33985);
            GLES30.glBindTexture((int)36197, (int)this.mOverlayTexId);
            GLES30.glUniform1i((int)uTex2, (int)1);
        }

        @Override
        @WorkerThread
        protected void internalOnStop() {
            if (this.mOverlayTexture != null) {
                this.mOverlayTexture.release();
                this.mOverlayTexture = null;
            }
            this.mOverlaySurface = null;
            if (this.mOverlayTexId >= 0) {
                GLUtils.deleteTex(this.mOverlayTexId);
                this.mOverlayTexId = -1;
            }
            super.internalOnStop();
        }

        @Override
        @WorkerThread
        protected Object handleRequest(int request, int arg1, int arg2, Object obj) {
            Object result = null;
            if (request == 100) {
                this.handleUpdateOverlay(arg1, (Bitmap)obj);
            } else {
                result = super.handleRequest(request, arg1, arg2, obj);
            }
            return result;
        }

        @Override
        protected void handleUpdateTexture() {
            super.handleUpdateTexture();
            this.mOverlayTexture.updateTexImage();
            this.mOverlayTexture.getTransformMatrix(this.mTexMatrixOverlay);
        }

        @Override
        protected void handleResize(int width, int height) {
            super.handleResize(width, height);
            if (this.mOverlayTexture != null) {
                this.mOverlayTexture.setDefaultBufferSize(this.width(), this.height());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"NewApi"})
        @WorkerThread
        private void handleUpdateOverlay(int targetId, @NonNull Bitmap overlay) {
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)36197, (int)this.mOverlayTexId);
            try {
                Canvas canvas = this.mOverlaySurface.lockCanvas(null);
                try {
                    if (overlay != null) {
                        canvas.drawBitmap(overlay, 0.0f, 0.0f, null);
                    } else {
                        canvas.drawColor(0);
                    }
                }
                finally {
                    this.mOverlaySurface.unlockCanvasAndPost(canvas);
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.requestFrame(true, this.getTexId(), this.getTexMatrix());
        }
    }
}

