/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.CallSuper;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.system.BuildCheck;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class GLImageReceiver {
    private static final boolean DEBUG = false;
    private static final String TAG = GLImageReceiver.class.getSimpleName();
    private static final int REQUEST_UPDATE_TEXTURE = 1;
    private static final int REQUEST_UPDATE_SIZE = 2;
    private static final int REQUEST_RECREATE_MASTER_SURFACE = 5;
    @NonNull
    private final Object mSync;
    @NonNull
    private final GLManager mManager;
    private final boolean mOwnManager;
    @NonNull
    private final Handler mGLHandler;
    private int mWidth;
    private int mHeight;
    @NonNull
    private final Callback mCallback;
    private volatile boolean mReleased;
    private boolean mIsReaderValid;
    @Size(min=16L)
    @NonNull
    final float[] mTexMatrix;
    private int mTexId;
    private SurfaceTexture mInputTexture;
    private Surface mInputSurface;
    private int drawCnt;
    private final SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener;

    public GLImageReceiver(@IntRange(from=1L) int width, @IntRange(from=1L) int height, @NonNull Callback callback) {
        this(new GLManager(), false, width, height, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GLImageReceiver(@NonNull GLManager manager, boolean useSharedContext, @IntRange(from=1L) int width, @IntRange(from=1L) int height, @NonNull Callback callback) {
        block11: {
            this.mSync = new Object();
            this.mReleased = false;
            this.mIsReaderValid = false;
            this.mTexMatrix = new float[16];
            this.mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    GLImageReceiver.this.mGLHandler.sendEmptyMessage(1);
                }
            };
            this.mOwnManager = useSharedContext;
            Handler.Callback handlerCallback = new Handler.Callback(){

                public boolean handleMessage(@NonNull Message msg) {
                    return GLImageReceiver.this.handleMessage(msg);
                }
            };
            if (useSharedContext) {
                this.mManager = manager.createShared(handlerCallback);
                this.mGLHandler = this.mManager.getGLHandler();
            } else {
                this.mManager = manager;
                this.mGLHandler = manager.createGLHandler(handlerCallback);
            }
            this.mWidth = width;
            this.mHeight = height;
            this.mCallback = callback;
            final Semaphore sem = new Semaphore(0);
            this.mGLHandler.post(new Runnable(){

                @Override
                public void run() {
                    GLImageReceiver.this.handleOnStart();
                    sem.release();
                }
            });
            try {
                if (!sem.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException("failed to init");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("failed to init", e);
            }
            sem.release(sem.availablePermits());
            this.mGLHandler.post(new Runnable(){

                @Override
                public void run() {
                    GLImageReceiver.this.handleReCreateInputSurface();
                    sem.release();
                }
            });
            try {
                Surface surface;
                Object object = this.mSync;
                synchronized (object) {
                    surface = this.mInputSurface;
                }
                if (surface != null) break block11;
                if (sem.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
                    this.mIsReaderValid = true;
                    break block11;
                }
                throw new RuntimeException("failed to create surface");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public final void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            this.mIsReaderValid = false;
            this.internalRelease();
        }
    }

    protected void internalRelease() {
        if (this.mManager.isValid()) {
            this.mGLHandler.post(new Runnable(){

                @Override
                public void run() {
                    GLImageReceiver.this.handleOnStop();
                    if (GLImageReceiver.this.mOwnManager) {
                        GLImageReceiver.this.mManager.release();
                    }
                }
            });
        }
    }

    public GLManager getGLManager() {
        return this.mManager;
    }

    public boolean isValid() {
        return !this.mReleased && this.mIsReaderValid && this.mManager.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTexId() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mInputSurface == null) {
                throw new IllegalStateException("surface not ready, already released?");
            }
            return this.mTexId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Size(min=16L)
    @NonNull
    public float[] getTexMatrix() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mTexMatrix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Surface getSurface() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mInputSurface == null) {
                throw new IllegalStateException("surface not ready, already released?");
            }
            return this.mInputSurface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public SurfaceTexture getSurfaceTexture() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mInputTexture == null) {
                throw new IllegalStateException("surface not ready, already released?");
            }
            return this.mInputTexture;
        }
    }

    protected boolean isGLES3() {
        return this.mManager.isGLES3();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(@IntRange(from=1L) int width, @IntRange(from=1L) int height) {
        int _width = Math.max(width, 1);
        int _height = Math.max(height, 1);
        Object object = this.mSync;
        synchronized (object) {
            if (this.mWidth != _width || this.mHeight != _height) {
                this.mGLHandler.sendMessage(this.mGLHandler.obtainMessage(2, _width, _height));
            }
        }
    }

    @WorkerThread
    private void handleOnStart() {
        this.mCallback.onInitialize(this);
    }

    @WorkerThread
    private void handleOnStop() {
        this.handleReleaseInputSurface();
        this.mCallback.onRelease();
    }

    @WorkerThread
    protected boolean handleMessage(@NonNull Message msg) {
        switch (msg.what) {
            case 1: {
                this.handleUpdateTexImage();
                return true;
            }
            case 2: {
                this.handleResize(msg.arg1, msg.arg2);
                return true;
            }
            case 5: {
                this.handleReCreateInputSurface();
                return true;
            }
        }
        return false;
    }

    @WorkerThread
    private void handleUpdateTexImage() {
        try {
            this.mManager.makeDefault();
            GLES20.glClearColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
            this.mManager.swap();
            this.mInputTexture.updateTexImage();
            this.mInputTexture.getTransformMatrix(this.mTexMatrix);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("handleDraw:thread id =" + Thread.currentThread().getId()), (Throwable)e);
            return;
        }
        this.mCallback.onFrameAvailable(this, true, this.mTexId, this.mTexMatrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    @WorkerThread
    @CallSuper
    private void handleResize(int width, int height) {
        Object object = this.mSync;
        synchronized (object) {
            this.mWidth = width;
            this.mHeight = height;
        }
        if (BuildCheck.isAndroid4_1() && this.mInputTexture != null) {
            this.mInputTexture.setDefaultBufferSize(width, height);
        }
        this.mCallback.onResize(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    @WorkerThread
    @CallSuper
    private void handleReCreateInputSurface() {
        Object object = this.mSync;
        synchronized (object) {
            this.mManager.makeDefault();
            this.handleReleaseInputSurface();
            this.mManager.makeDefault();
            this.mTexId = GLUtils.initTex(36197, 33984, 9728);
            this.mInputTexture = new SurfaceTexture(this.mTexId);
            this.mInputSurface = new Surface(this.mInputTexture);
            if (BuildCheck.isAndroid4_1()) {
                this.mInputTexture.setDefaultBufferSize(this.mWidth, this.mHeight);
            }
            this.mCallback.onCreateInputSurface(this);
            this.mInputTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    @WorkerThread
    @CallSuper
    private void handleReleaseInputSurface() {
        this.mCallback.onReleaseInputSurface(this);
        Object object = this.mSync;
        synchronized (object) {
            if (this.mInputSurface != null) {
                try {
                    this.mInputSurface.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mInputSurface = null;
            }
            if (this.mInputTexture != null) {
                try {
                    this.mInputTexture.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mInputTexture = null;
            }
            if (this.mTexId != 0) {
                GLUtils.deleteTex(this.mTexId);
                this.mTexId = 0;
            }
        }
    }

    public static interface Callback {
        @WorkerThread
        public void onInitialize(@NonNull GLImageReceiver var1);

        @WorkerThread
        public void onRelease();

        @WorkerThread
        public void onCreateInputSurface(@NonNull GLImageReceiver var1);

        @WorkerThread
        public void onReleaseInputSurface(@NonNull GLImageReceiver var1);

        @WorkerThread
        public void onResize(int var1, int var2);

        @WorkerThread
        public void onFrameAvailable(@NonNull GLImageReceiver var1, boolean var2, int var3, @Size(min=16L) @NonNull float[] var4);
    }
}

