/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.serenegiant.glpipeline.GLPipeline;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class DistributePipeline
implements GLPipeline {
    private static final boolean DEBUG = false;
    private static final String TAG = DistributePipeline.class.getSimpleName();
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    @NonNull
    private final Object mSync = new Object();
    private int mWidth;
    private int mHeight;
    @Nullable
    private GLPipeline mParent;
    @NonNull
    private final Set<GLPipeline> mPipelines = new CopyOnWriteArraySet<GLPipeline>();
    private volatile boolean mReleased = false;

    public DistributePipeline() {
        this(640, 480);
    }

    protected DistributePipeline(int width, int height) {
        if (width > 0 || height > 0) {
            this.mWidth = width;
            this.mHeight = height;
        } else {
            this.mWidth = 640;
            this.mHeight = 480;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public final void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            this.internalRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    protected void internalRelease() {
        this.mReleased = true;
        Iterator<GLPipeline> iterator = this.mSync;
        synchronized (iterator) {
            this.mParent = null;
        }
        for (GLPipeline pipeline : this.mPipelines) {
            pipeline.release();
        }
        this.mPipelines.clear();
    }

    @Override
    @CallSuper
    public void resize(int width, int height) throws IllegalStateException {
        if (!this.mReleased) {
            this.mWidth = width;
            this.mHeight = height;
            for (GLPipeline pipeline : this.mPipelines) {
                pipeline.resize(width, height);
            }
        } else {
            throw new IllegalStateException("already released!");
        }
    }

    @Override
    public boolean isValid() {
        return !this.mReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.mSync;
        synchronized (object) {
            return !this.mReleased && !this.mPipelines.isEmpty() && this.mParent != null;
        }
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CallSuper
    public void setParent(@Nullable GLPipeline parent) {
        if (!this.mReleased) {
            Object object = this.mSync;
            synchronized (object) {
                this.mParent = parent;
            }
        } else {
            throw new IllegalStateException("already released!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GLPipeline getParent() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mParent;
        }
    }

    @CallSuper
    public void addPipeline(@NonNull GLPipeline pipeline) {
        if (this.mReleased) {
            throw new IllegalStateException("already released!");
        }
        this.mPipelines.add(pipeline);
        pipeline.setParent(this);
        pipeline.resize(this.mWidth, this.mHeight);
    }

    @CallSuper
    public void removePipeline(@NonNull GLPipeline pipeline) {
        if (this.mReleased) {
            throw new IllegalStateException("already released!");
        }
        this.mPipelines.remove(pipeline);
        pipeline.setParent(null);
    }

    @Override
    @CallSuper
    public void setPipeline(@Nullable GLPipeline pipeline) {
        if (pipeline == null) {
            throw new IllegalArgumentException("DistributePipeline#setPipeline can't accept null!");
        }
        if (this.mReleased) {
            throw new IllegalStateException("already released!");
        }
        this.mPipelines.add(pipeline);
        pipeline.setParent(this);
        pipeline.resize(this.mWidth, this.mHeight);
    }

    @Override
    @Nullable
    public GLPipeline getPipeline() {
        Iterator<GLPipeline> iterator = this.mPipelines.iterator();
        if (iterator.hasNext()) {
            GLPipeline pipeline = iterator.next();
            return pipeline;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CallSuper
    public void remove() {
        GLPipeline parent;
        GLPipeline first = GLPipeline.findFirst(this);
        Object object = this.mSync;
        synchronized (object) {
            parent = this.mParent;
            if (this.mParent != null) {
                if (this.mPipelines.size() == 1) {
                    this.mParent.setPipeline(this.getPipeline());
                } else {
                    this.mParent.setPipeline(null);
                    Log.d((String)TAG, (String)"#remove can't rebuild pipeline chain!");
                }
            }
            this.mParent = null;
        }
        if (first != this) {
            GLPipeline.validatePipelineChain(first);
            parent.refresh();
        }
    }

    @Override
    @CallSuper
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        if (!this.mReleased) {
            for (GLPipeline pipeline : this.mPipelines) {
                if (pipeline == null) continue;
                pipeline.onFrameAvailable(isOES, texId, texMatrix);
            }
        }
    }

    @Override
    public void refresh() {
        if (!this.mReleased) {
            for (GLPipeline pipeline : this.mPipelines) {
                pipeline.refresh();
            }
        }
    }
}

