/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.gl;

import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLSurface;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.ISurface;
import com.serenegiant.gl.TextureWrapper;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.system.Time;

public class RendererTarget
implements IMirror {
    private Object mSurface;
    private final boolean mOwnSurface;
    private ISurface mTargetSurface;
    @Size(min=16L)
    @NonNull
    private final float[] mMvpMatrix = new float[16];
    private volatile boolean mEnable = true;
    private int mMirror = 0;

    public static RendererTarget newInstance(@NonNull EGLBase egl, @NonNull Object surface, float maxFps) {
        return maxFps > 0.0f ? new RendererTargetHasWait(egl, surface, maxFps) : new RendererTarget(egl, surface);
    }

    protected RendererTarget(@NonNull EGLBase egl, @NonNull Object surface) {
        this.mSurface = surface;
        if (surface instanceof ISurface) {
            this.mTargetSurface = (ISurface)surface;
            this.mOwnSurface = false;
        } else if (surface instanceof TextureWrapper) {
            TextureWrapper wrapper = (TextureWrapper)surface;
            this.mTargetSurface = GLSurface.wrap(egl.isGLES3(), wrapper.texTarget, wrapper.texUnit, wrapper.texId, wrapper.width, wrapper.height, false);
            this.mOwnSurface = true;
        } else if (GLUtils.isSupportedSurface(surface)) {
            this.mTargetSurface = egl.createFromSurface(surface);
            this.mOwnSurface = true;
        } else {
            throw new IllegalArgumentException("Unsupported surface," + surface);
        }
        Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
    }

    public void release() {
        if (this.mOwnSurface && this.mTargetSurface != null) {
            this.mTargetSurface.release();
        }
        this.mTargetSurface = null;
        this.mSurface = null;
    }

    @Nullable
    public Object getSurface() {
        return this.mSurface;
    }

    public int getId() {
        return this.mSurface != null ? this.mSurface.hashCode() : 0;
    }

    public boolean isValid() {
        return this.mTargetSurface != null && this.mTargetSurface.isValid();
    }

    public boolean isEnabled() {
        return this.mEnable;
    }

    public void setEnabled(boolean enable) {
        this.mEnable = enable;
    }

    public boolean canDraw() {
        return this.mEnable && this.mTargetSurface != null && this.mTargetSurface.isValid();
    }

    @Size(min=16L)
    @NonNull
    public float[] getMvpMatrix() {
        return this.mMvpMatrix;
    }

    @Override
    public void setMirror(int mirror) {
        int _mirror = mirror % 4;
        if (_mirror != this.mMirror) {
            this.mMirror = _mirror;
            GLUtils.setMirror(this.mMvpMatrix, _mirror);
        }
    }

    @Override
    public int getMirror() {
        return this.mMirror;
    }

    public int width() {
        return this.mTargetSurface != null ? this.mTargetSurface.getWidth() : 0;
    }

    public int height() {
        return this.mTargetSurface != null ? this.mTargetSurface.getHeight() : 0;
    }

    public void draw(@NonNull GLDrawer2D drawer, int texUnit, int textId, @Nullable float[] texMatrix) {
        if (this.mTargetSurface != null) {
            this.mTargetSurface.makeCurrent();
            this.mTargetSurface.setViewPort(0, 0, this.mTargetSurface.getWidth(), this.mTargetSurface.getHeight());
            GLES20.glClear((int)16384);
            RendererTarget.doDraw(drawer, texUnit, textId, texMatrix, this.mMvpMatrix);
            this.mTargetSurface.swap();
        }
    }

    protected static void doDraw(@NonNull GLDrawer2D drawer, int texUnit, int textId, @Nullable float[] texMatrix, @NonNull float[] mvpMatrix) {
        drawer.setMvpMatrix(mvpMatrix, 0);
        drawer.draw(texUnit, textId, texMatrix, 0);
    }

    public void clear(int color) {
        if (this.mTargetSurface != null) {
            this.mTargetSurface.makeCurrent();
            this.mTargetSurface.setViewPort(0, 0, this.mTargetSurface.getWidth(), this.mTargetSurface.getHeight());
            GLES20.glClearColor((float)((float)((color & 0xFF0000) >>> 16) / 255.0f), (float)((float)((color & 0xFF00) >>> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)((color & 0xFF000000) >>> 24) / 255.0f));
            GLES20.glClear((int)16384);
            this.mTargetSurface.swap();
        }
    }

    public void makeCurrent() throws IllegalStateException {
        this.check();
        this.mTargetSurface.makeCurrent();
        this.mTargetSurface.setViewPort(0, 0, this.mTargetSurface.getWidth(), this.mTargetSurface.getHeight());
    }

    public void swap() throws IllegalStateException {
        this.check();
        this.mTargetSurface.swap();
    }

    private void check() throws IllegalStateException {
        if (this.mTargetSurface == null || !this.mTargetSurface.isValid()) {
            throw new IllegalStateException("already released");
        }
    }

    static class RendererTargetHasWait
    extends RendererTarget {
        private long mNextDraw;
        private final long mIntervalsNs;
        private final long mIntervalsDeltaNs;

        protected RendererTargetHasWait(@NonNull EGLBase egl, @NonNull Object surface, float maxFps) {
            super(egl, surface);
            this.mIntervalsNs = Math.round(1.0E9 / (double)maxFps);
            this.mIntervalsDeltaNs = -Math.round((double)this.mIntervalsNs * 0.03);
            this.mNextDraw = Time.nanoTime() + this.mIntervalsNs;
        }

        @Override
        public boolean canDraw() {
            return super.canDraw() && Time.nanoTime() - this.mNextDraw > this.mIntervalsDeltaNs;
        }

        @Override
        public void draw(@NonNull GLDrawer2D drawer, int texUnit, int textId, @Nullable float[] texMatrix) {
            this.mNextDraw = Time.nanoTime() + this.mIntervalsNs;
            super.draw(drawer, texUnit, textId, texMatrix);
        }
    }
}

