/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.content.Context;
import android.content.res.AssetManager;
import android.hardware.usb.UsbDevice;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.AbstractCamera;
import com.serenegiant.camera.FuncMaxMinDef;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.camera.Size;
import com.serenegiant.camera.SizeUtils;
import com.serenegiant.usb.NativeLibLoader;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UsbDeviceInfo;
import com.serenegiant.usb.UsbUtils;
import com.serenegiant.usb.uvc.CameraConfig;
import com.serenegiant.usb.uvc.IButtonCallback;
import com.serenegiant.usb.uvc.IPipeline;
import com.serenegiant.usb.uvc.IPipelineSource;
import com.serenegiant.usb.uvc.IStatusCallback;
import com.serenegiant.usb.uvc.IUVCCameraControl;
import com.serenegiant.usb.uvc.PreviewFormat;
import com.serenegiant.utils.JSONHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

@Keep
public class UVCPipeline
extends AbstractCamera
implements IUVCCameraControl,
IPipelineSource {
    private static final boolean DEBUG = false;
    private static final String TAG = UVCPipeline.class.getSimpleName();
    private static final String DEFAULT_USBFS = "/dev/bus/usb";
    private static final int DEFAULT_NUM_TRANSFER_BUFS = 10;
    public static boolean USE_STATUS_CALLBACK;
    protected long mNativePtr;
    protected final Context mContext;
    protected int mNativeValue;
    protected int mBrightnessMin;
    protected int mBrightnessMax;
    protected int mBrightnessDef;
    protected int mFocusMin;
    protected int mFocusMax;
    protected int mFocusDef;
    protected int mContrastMin;
    protected int mContrastMax;
    protected int mContrastDef;
    protected int mSharpnessMin;
    protected int mSharpnessMax;
    protected int mSharpnessDef;
    protected int mGainMin;
    protected int mGainMax;
    protected int mGainDef;
    protected int mGammaMin;
    protected int mGammaMax;
    protected int mGammaDef;
    protected int mWhiteBlanceMin;
    protected int mWhiteBlanceMax;
    protected int mWhiteBlanceDef;
    protected int mSaturationMin;
    protected int mSaturationMax;
    protected int mSaturationDef;
    protected int mHueMin;
    protected int mHueMax;
    protected int mHueDef;
    protected int mZoomMin;
    protected int mZoomMax;
    protected int mZoomDef;
    protected int mScanningModeMin;
    protected int mScanningModeMax;
    protected int mScanningModeDef;
    protected int mExposureModeMin;
    protected int mExposureModeMax;
    protected int mExposureModeDef;
    protected int mExposurePriorityMin;
    protected int mExposurePriorityMax;
    protected int mExposurePriorityDef;
    protected int mExposureMin;
    protected int mExposureMax;
    protected int mExposureDef;
    protected int mExposureRelMin;
    protected int mExposureRelMax;
    protected int mExposureRelDef;
    protected int mAutoFocusMin;
    protected int mAutoFocusMax;
    protected int mAutoFocusDef;
    protected int mFocusRelMin;
    protected int mFocusRelMax;
    protected int mFocusRelDef;
    protected int mFocusRelSpeedMin;
    protected int mFocusRelSpeedMax;
    protected int mFocusRelSpeedDef;
    protected int mFocusSimpleMin;
    protected int mFocusSimpleMax;
    protected int mFocusSimpleDef;
    protected int mIrisMin;
    protected int mIrisMax;
    protected int mIrisDef;
    protected int mIrisRelMin;
    protected int mIrisRelMax;
    protected int mIrisRelDef;
    protected int mPanMin;
    protected int mPanMax;
    protected int mPanDef;
    protected int mTiltMin;
    protected int mTiltMax;
    protected int mTiltDef;
    protected int mRollMin;
    protected int mRollMax;
    protected int mRollDef;
    protected int mPanRelMin;
    protected int mPanRelMax;
    protected int mPanRelDef;
    protected int mTiltRelMin;
    protected int mTiltRelMax;
    protected int mTiltRelDef;
    protected int mRollRelMin;
    protected int mRollRelMax;
    protected int mRollRelDef;
    protected int mPrivacyMin;
    protected int mPrivacyMax;
    protected int mPrivacyDef;
    protected int mAutoWhiteBlanceMin;
    protected int mAutoWhiteBlanceMax;
    protected int mAutoWhiteBlanceDef;
    protected int mAutoWhiteBlanceCompoMin;
    protected int mAutoWhiteBlanceCompoMax;
    protected int mAutoWhiteBlanceCompoDef;
    protected int mWhiteBlanceCompoBlueMin;
    protected int mWhiteBlanceCompoBlueMax;
    protected int mWhiteBlanceCompoBlueDef;
    protected int mWhiteBlanceCompoRedMin;
    protected int mWhiteBlanceCompoRedMax;
    protected int mWhiteBlanceCompoRedDef;
    protected int mWhiteBlanceRelMin;
    protected int mWhiteBlanceRelMax;
    protected int mWhiteBlanceRelDef;
    protected int mBacklightCompMin;
    protected int mBacklightCompMax;
    protected int mBacklightCompDef;
    protected int mAutoContrastMin;
    protected int mAutoContrastMax;
    protected int mAutoContrastDef;
    protected int mAutoHueMin;
    protected int mAutoHueMax;
    protected int mAutoHueDef;
    protected int mZoomRelMin;
    protected int mZoomRelMax;
    protected int mZoomRelDef;
    protected int mPowerlineFrequencyMin;
    protected int mPowerlineFrequencyMax;
    protected int mPowerlineFrequencyDef;
    protected int mMultiplierMin;
    protected int mMultiplierMax;
    protected int mMultiplierDef;
    protected int mMultiplierLimitMin;
    protected int mMultiplierLimitMax;
    protected int mMultiplierLimitDef;
    protected int mAnalogVideoStandardMin;
    protected int mAnalogVideoStandardMax;
    protected int mAnalogVideoStandardDef;
    protected int mAnalogVideoLockStateMin;
    protected int mAnalogVideoLockStateMax;
    protected int mAnalogVideoLockStateDef;
    protected USBMonitor.UsbControlBlock mCtrlBlock;
    @NonNull
    private final PreviewFormat[] mPreviewFormats;
    protected PreviewFormat mCurrentPreviewFormat = PreviewFormat.PREVIEW_FORMAT_UNSPECIFIED;
    protected long mControlSupports;
    protected long mProcSupports;
    protected int mRequestWidth = 640;
    protected int mRequestHeight = 480;
    protected float mRequestMinFps = 1.0f;
    protected float mRequestMaxFps = 31.0f;
    protected float mRequestBandWidthFactor = 0.0f;
    @Nullable
    protected String mSupportedSize;
    @Nullable
    protected List<Size> mCurrentSizeList;
    private String mDescriptor;
    private static final String[] SUPPORTS_CTRL;
    private static final String[] SUPPORTS_PROC;

    public UVCPipeline(@NonNull Context context, @Nullable PreviewFormat[] formats) {
        this(context, formats, false);
    }

    public UVCPipeline(@NonNull Context context, @Nullable PreviewFormat[] formats, boolean useFirstConfig) {
        this.mContext = context;
        this.mPreviewFormats = formats == null ? CameraConfig.getPreviewFormats(2) : formats;
        this.mSupportedSize = null;
        this.mCurrentSizeList = null;
        this.mNativePtr = 0L;
        this.mNativeValue = 0;
        this.mNativePtr = this.nativeCreate(context.getAssets(), useFirstConfig);
        if (this.mNativePtr == 0L) {
            throw new UnsupportedOperationException();
        }
        this.setState(16);
    }

    @Override
    public void release() {
        this.close();
        if (this.mNativePtr != 0L) {
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
        super.release();
    }

    public synchronized void open(USBMonitor.UsbControlBlock ctrlBlock, int sanitaryCheck, boolean enableCaptureMethod) throws IOException {
        this.open(ctrlBlock, 4, 4, 1024, sanitaryCheck, 10, enableCaptureMethod);
    }

    public void open(USBMonitor.UsbControlBlock ctrlBlock, int maxBufferNum, int initPoolNum, int defaultFrameSize) throws IOException {
        this.open(ctrlBlock, maxBufferNum, initPoolNum, defaultFrameSize, 1, 10);
    }

    public void open(USBMonitor.UsbControlBlock ctrlBlock, int maxBufferNum, int initPoolNum, int defaultFrameSize, int sanitaryCheck) throws IOException {
        this.open(ctrlBlock, maxBufferNum, initPoolNum, defaultFrameSize, sanitaryCheck, 10);
    }

    public synchronized void open(USBMonitor.UsbControlBlock ctrlBlock, int maxBufferNum, int initPoolNum, int defaultFrameSize, int sanitaryCheck, @IntRange(from=5L, to=100L) int numTransferBufs) throws IOException {
        this.open(ctrlBlock, maxBufferNum, initPoolNum, defaultFrameSize, sanitaryCheck, numTransferBufs, false);
    }

    public synchronized void open(USBMonitor.UsbControlBlock ctrlBlock, int maxBufferNum, int initPoolNum, int defaultFrameSize, int sanitaryCheck, @IntRange(from=5L, to=100L) int numTransferBufs, boolean enableCaptureMethod) throws IOException {
        if (!this.isConnected()) {
            int result;
            this.setState(256, -257);
            try {
                this.mCtrlBlock = ctrlBlock.clone();
                result = this.nativeConnectEx2(this.mNativePtr, this.mCtrlBlock.getFileDescriptor(), maxBufferNum, initPoolNum, defaultFrameSize, sanitaryCheck, numTransferBufs, enableCaptureMethod);
            }
            catch (Exception e) {
                result = -1;
            }
            if (result != 0) {
                throw new IOException("open failed:result=" + result);
            }
            this.getSupportedSizeStringAll();
            this.setState(512, -513);
        }
    }

    public synchronized void open(USBMonitor.UsbControlBlock ctrlBlock) throws IOException {
        if (!this.isConnected()) {
            int result;
            this.setState(256, -257);
            try {
                this.mCtrlBlock = ctrlBlock.clone();
                result = this.nativeConnect(this.mNativePtr, this.mCtrlBlock.getFileDescriptor());
            }
            catch (Exception e) {
                result = -1;
            }
            this.setState(0, -257);
            if (result != 0) {
                throw new IOException("open failed:result=" + result);
            }
            this.getSupportedSizeStringAll();
            this.setState(512, -513);
        }
    }

    public synchronized void close() {
        this.stopStream();
        this.setState(0, -769);
        if (this.mNativePtr != 0L) {
            this.nativeDisconnect(this.mNativePtr);
        }
        if (this.mCtrlBlock != null) {
            this.mCtrlBlock.close();
            this.mCtrlBlock = null;
        }
        this.mProcSupports = 0L;
        this.mControlSupports = 0L;
        this.mCurrentPreviewFormat = PreviewFormat.PREVIEW_FORMAT_UNSPECIFIED;
        this.mSupportedSize = null;
        this.mCurrentSizeList = null;
    }

    public void setStatusCallback(IStatusCallback callback) throws IllegalStateException {
        this.readLock();
        try {
            if (this.mNativePtr != 0L) {
                UVCPipeline.nativeSetStatusCallback(this.mNativePtr, callback);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    public void setButtonCallback(IButtonCallback callback) throws IllegalStateException {
        this.readLock();
        try {
            if (this.mNativePtr != 0L) {
                UVCPipeline.nativeSetButtonCallback(this.mNativePtr, callback);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public synchronized String getDescriptor() {
        String result = this.mDescriptor;
        if (TextUtils.isEmpty((CharSequence)result) && this.mNativePtr != 0L && this.mCtrlBlock != null) {
            File dir = this.mContext.getExternalFilesDir("Descriptors");
            dir.mkdirs();
            if (dir.canWrite()) {
                File filepath = new File(dir, String.format("desc-%04x_%04x_%08x.txt", this.mCtrlBlock.getVenderId(), this.mCtrlBlock.getProductId(), UsbUtils.getDeviceKey((UsbDeviceInfo)this.mCtrlBlock.getInfo())));
                if (!filepath.exists()) {
                    UVCPipeline.nativeOutputDescriptor(this.mNativePtr, this.mCtrlBlock.getVenderId(), this.mCtrlBlock.getProductId(), this.mCtrlBlock.getFileDescriptor(), filepath.getAbsolutePath());
                }
                if (filepath.exists()) {
                    try (BufferedReader in = new BufferedReader(new FileReader(filepath));){
                        StringBuilder sb = new StringBuilder(1024);
                        char[] buffer = new char[512];
                        int n = 0;
                        while (n >= 0 && (n = in.read(buffer)) > 0) {
                            sb.append(buffer, 0, n);
                        }
                        result = this.mDescriptor = sb.toString();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    @Override
    public synchronized String getCurrentStream() {
        return UVCPipeline.nativeGetCurrentStream(this.mNativePtr);
    }

    public synchronized boolean setRotation(float degree) {
        int result = UVCPipeline.nativeSetRotation(this.mNativePtr, degree);
        return result != 0;
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    public int getState() {
        return this.mNativePtr != 0L ? UVCPipeline.nativeGetState(this.mNativePtr) : 0;
    }

    @Override
    public void setPipeline(IPipeline next_pipeline) {
        if (this.getState() < 20) {
            throw new IllegalStateException("already released");
        }
        UVCPipeline.nativeSetPipeline(this.mNativePtr, next_pipeline);
    }

    @Override
    public void start() throws IllegalStateException {
        this.startStream();
    }

    @Override
    public void stop() {
        this.stopStream();
    }

    @Override
    public boolean isRunning() {
        return this.isStreaming();
    }

    @Override
    public synchronized boolean isConnected() {
        try {
            return super.isConnected() && this.isValid();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public synchronized boolean startStream() {
        if (this.mNativePtr != 0L) {
            int result = this.nativeStartStream(this.mNativePtr);
            if (result != 0) {
                throw new RuntimeException("startStream: Failed result=" + result);
            }
        } else {
            throw new RuntimeException("startStream: not ready");
        }
        this.setState(1024, -1025);
        return this.isStreaming();
    }

    @Override
    public synchronized boolean stopStream() {
        this.setState(0, -1025);
        if (this.mNativePtr != 0L) {
            this.nativeStopStream(this.mNativePtr);
        }
        return false;
    }

    @Override
    public synchronized boolean isStreaming() {
        try {
            return super.isStreaming() && this.isValid();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getNativeValue() {
        return this.mNativeValue;
    }

    public synchronized boolean equals(UsbDevice device) {
        return this.mCtrlBlock != null && this.mCtrlBlock.equals((Object)device);
    }

    public synchronized boolean equals(USBMonitor.UsbControlBlock ctrlBlock) {
        return this.mCtrlBlock != null && this.mCtrlBlock.equals((Object)ctrlBlock);
    }

    public synchronized boolean equals(UVCPipeline other) {
        return this.mCtrlBlock != null && this.mCtrlBlock.equals((Object)other.mCtrlBlock);
    }

    public boolean equals(Object other) {
        return other instanceof UsbDevice && this.equals((UsbDevice)other) || other instanceof USBMonitor.UsbControlBlock && this.equals((USBMonitor.UsbControlBlock)other) || other instanceof UVCPipeline && this.equals((UVCPipeline)other) || super.equals(other);
    }

    public synchronized UsbDevice getCurrentDevice() {
        return this.mCtrlBlock != null ? this.mCtrlBlock.getDevice() : null;
    }

    @Override
    public synchronized String getDeviceKeyName() {
        return this.mCtrlBlock != null ? UsbUtils.getDeviceKeyName((UsbDeviceInfo)this.mCtrlBlock.getInfo()) : "";
    }

    @Override
    public int getDeviceKey() {
        return this.mCtrlBlock != null ? UsbUtils.getDeviceKey((UsbDeviceInfo)this.mCtrlBlock.getInfo()) : 0;
    }

    @Override
    @Nullable
    public UsbDevice getDevice() {
        return this.mCtrlBlock != null ? this.mCtrlBlock.getDevice() : null;
    }

    public int claimInterface(int interface_index, int altsetting) {
        throw new UnsupportedOperationException();
    }

    public int releaseInterface(int interface_index, int altsetting) {
        throw new UnsupportedOperationException();
    }

    public RawFrameType getCurrentRawFrameType() {
        Size sz = this.getCurrentVideoSize();
        return sz != null ? sz.frameType : RawFrameType.RAW_FRAME_UNKNOWN;
    }

    public PreviewFormat getCurrentPreviewFormat() {
        return this.mCurrentPreviewFormat == PreviewFormat.PREVIEW_FORMAT_UNSPECIFIED ? this.mPreviewFormats[0] : this.mCurrentPreviewFormat;
    }

    @Override
    public void setVideoSize(@Nullable Size size) throws IllegalArgumentException {
        this.setVideoSize(size, 0.0f);
    }

    @Override
    public void setVideoSize(@Nullable Size size, float bandwidthFactor) throws IllegalArgumentException {
        if (size == null) {
            List<Size> resolutions = this.getSupportedSizeList();
            if (resolutions.size() > 0) {
                Size sz = resolutions.get(0);
                if (sz == null) {
                    throw new IllegalArgumentException("invalid preview size index");
                }
                this.setVideoSize(sz.width, sz.height, this.mRequestMinFps, this.mRequestMaxFps, bandwidthFactor);
                return;
            }
            throw new IllegalArgumentException("invalid preview size index");
        }
        float maxFps = this.mRequestMaxFps;
        try {
            maxFps = size.getCurrentFrameRate() + 0.1f;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVideoSize(size.width, size.height, this.mRequestMinFps, maxFps, bandwidthFactor);
    }

    @Override
    public void setVideoSize(int width, int height, float minFps, float maxFps) throws IllegalArgumentException {
        this.setVideoSize(width, height, minFps, maxFps, 0.0f);
    }

    @Override
    public void setVideoSize(int width, int height, float minFps, float maxFps, float bandwidthFactor) throws IllegalArgumentException {
        int result = -1;
        int n = this.mPreviewFormats.length;
        for (int i = 0; i < n; ++i) {
            if (this.mPreviewFormats[i] == PreviewFormat.PREVIEW_FORMAT_UNSPECIFIED) continue;
            try {
                this.setVideoSize(this.mPreviewFormats[i], width, height, minFps, maxFps, bandwidthFactor);
                result = 0;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result != 0) {
            this.mCurrentPreviewFormat = PreviewFormat.PREVIEW_FORMAT_UNSPECIFIED;
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setVideoSize(PreviewFormat format, int width, int height, float minFps, float maxFps, float bandwidthFactor) throws IllegalArgumentException {
        this.mCurrentSizeList = null;
        Size sz = this.findVideoSize(format, width, height);
        if (sz != null) {
            float _maxFps = Math.min(maxFps, format == PreviewFormat.PREVIEW_FORMAT_H264 || format == PreviewFormat.PREVIEW_FORMAT_VP8 ? CameraConfig.maxFpsMediaCodec : maxFps);
            int result = UVCPipeline.nativeSetVideoSize(this.mNativePtr, SizeUtils.getFrameType(format).getValue(), sz.width, sz.height, minFps, _maxFps, bandwidthFactor);
            if (result == 0) {
                this.mCurrentPreviewFormat = format;
                this.mRequestWidth = sz.width;
                this.mRequestHeight = sz.height;
                this.mRequestMinFps = minFps;
                this.mRequestMaxFps = maxFps;
                this.mRequestBandWidthFactor = bandwidthFactor;
                return;
            }
        }
        this.mCurrentPreviewFormat = PreviewFormat.PREVIEW_FORMAT_UNSPECIFIED;
        throw new IllegalArgumentException("setVideoSize:");
    }

    public void setVideoSize(RawFrameType frameType, int width, int height, float minFps, float maxFps, float bandwidthFactor) throws IllegalArgumentException {
        PreviewFormat format = SizeUtils.getPreviewFormat(frameType);
        this.mCurrentSizeList = null;
        Size sz = this.findVideoSize(format, width, height);
        if (sz != null) {
            float _maxFps = Math.min(maxFps, format == PreviewFormat.PREVIEW_FORMAT_H264 || format == PreviewFormat.PREVIEW_FORMAT_VP8 ? CameraConfig.maxFpsMediaCodec : maxFps);
            int result = UVCPipeline.nativeSetVideoSize(this.mNativePtr, frameType.getValue(), sz.width, sz.height, minFps, _maxFps, bandwidthFactor);
            if (result == 0) {
                this.mCurrentPreviewFormat = format;
                this.mRequestWidth = sz.width;
                this.mRequestHeight = sz.height;
                this.mRequestMinFps = minFps;
                this.mRequestMaxFps = maxFps;
                this.mRequestBandWidthFactor = bandwidthFactor;
                return;
            }
        }
        this.mCurrentPreviewFormat = PreviewFormat.PREVIEW_FORMAT_UNSPECIFIED;
        throw new IllegalArgumentException("setVideoSize:");
    }

    @Override
    @Nullable
    public Size findVideoSize(PreviewFormat format, int width, int height) {
        Size result = null;
        List<Size> supported = SizeUtils.getSizeListFromPreviewFormat(this.getSupportedSizeStringAll(), format);
        if (supported != null && !supported.isEmpty()) {
            for (Size sz : supported) {
                if (sz.width != width || sz.height != height) continue;
                result = sz;
                break;
            }
            if (result == null) {
                result = supported.get(0);
            }
        }
        return result;
    }

    @Override
    @Nullable
    public Size getCurrentVideoSize() {
        Size result = null;
        List<Size> supported = this.getSupportedSizeList();
        if (supported != null && supported.size() > 0) {
            try {
                String current_stream = this.getCurrentStream();
                if (!TextUtils.isEmpty((CharSequence)current_stream)) {
                    int height;
                    int width;
                    JSONObject json = new JSONObject(current_stream);
                    int formatType = json.getInt("formatType");
                    int frameType = json.optInt("frameType", RawFrameType.RAW_FRAME_UNKNOWN.getValue());
                    int formatIndex = json.getInt("formatIndex");
                    int frameIndex = json.optInt("frameIndex", 0);
                    boolean isAuxStream = JSONHelper.optBoolean((JSONObject)json, (String)"isAuxStream", (boolean)false);
                    if (isAuxStream) {
                        width = this.mRequestWidth;
                        height = this.mRequestHeight;
                    } else {
                        width = json.optInt("width", this.mRequestWidth);
                        height = json.optInt("height", this.mRequestHeight);
                    }
                    int frameInterval = json.getInt("frameInterval");
                    for (Size sz : supported) {
                        if (sz.width != width || sz.height != height) continue;
                        result = sz;
                        break;
                    }
                    if (result != null && frameInterval != 0) {
                        result.setCurrentFrameRate(1.0E7f / (float)frameInterval);
                    }
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            if (result == null) {
                for (Size sz : supported) {
                    if (sz.width != this.mRequestWidth || sz.height != this.mRequestHeight) continue;
                    result = sz;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public double getAspectRatio() {
        return this.mRequestWidth > 0 && this.mRequestHeight > 0 ? (double)this.mRequestWidth / (double)this.mRequestHeight : 1.0;
    }

    @Override
    @NonNull
    public synchronized String getSupportedSizeStringAll() throws IllegalStateException {
        if (TextUtils.isEmpty((CharSequence)this.mSupportedSize)) {
            this.mSupportedSize = UVCPipeline.nativeGetSupportedSize(this.mNativePtr);
        }
        if (TextUtils.isEmpty((CharSequence)this.mSupportedSize)) {
            throw new IllegalStateException("Couldn't get supported size string, will be already released?");
        }
        return this.mSupportedSize;
    }

    @Override
    @NonNull
    public String getSupportedSizeString() throws IllegalStateException {
        return SizeUtils.toJsonString(this.getSupportedSizeList());
    }

    @Override
    @NonNull
    public List<Size> getSupportedSizeList() throws IllegalStateException {
        List<Size> result = this.mCurrentSizeList;
        if (result == null || result.isEmpty()) {
            this.mCurrentSizeList = result = this.getSupportedSizeList(this.getCurrentPreviewFormat());
        }
        return result;
    }

    @Override
    @NonNull
    public List<Size> getSupportedSizeListAll() throws IllegalStateException {
        return Collections.unmodifiableList(SizeUtils.getSizeList(this.getSupportedSizeStringAll()));
    }

    @Override
    @NonNull
    public List<Size> getSupportedSizeList(PreviewFormat format) throws IllegalStateException {
        return SizeUtils.getSizeListFromPreviewFormat(this.getSupportedSizeStringAll(), format);
    }

    @Override
    public long getSupportedCtrl() {
        return this.mControlSupports;
    }

    @Override
    public long getSupportedProc() {
        return this.mProcSupports;
    }

    @Override
    public boolean checkSupportFlag(long flag) {
        this.updateCameraParams();
        long _flag = flag;
        if (flag == 0x1000800L || flag == 0x2000800L || flag == 0x1001000L || flag == 0x2001000L) {
            _flag &= 0xFFFFFFL;
        }
        if ((flag & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return (this.mProcSupports & (_flag &= Integer.MAX_VALUE)) == _flag;
        }
        return (this.mControlSupports & _flag) == _flag;
    }

    @Override
    public synchronized void updateCameraParams() {
        if (this.mNativePtr != 0L) {
            if (this.mControlSupports == 0L || this.mProcSupports == 0L) {
                int i;
                if (this.mControlSupports == 0L) {
                    this.mControlSupports = this.nativeGetCtrlSupports(this.mNativePtr);
                }
                if (this.mProcSupports == 0L) {
                    this.mProcSupports = this.nativeGetProcSupports(this.mNativePtr);
                }
                if (this.mControlSupports != 0L) {
                    int[] ctrls = CTRLS;
                    for (i = ctrls.length - 1; i >= 0; --i) {
                        int ctrl = ctrls[i];
                        try {
                            switch ((int)(this.mControlSupports & (long)ctrl)) {
                                case 1: {
                                    this.nativeUpdateScanningMode(this.mNativePtr);
                                    break;
                                }
                                case 2: {
                                    this.nativeUpdateExposureMode(this.mNativePtr);
                                    break;
                                }
                                case 4: {
                                    this.nativeUpdateExposurePriority(this.mNativePtr);
                                    break;
                                }
                                case 8: {
                                    this.nativeUpdateExposure(this.mNativePtr);
                                    break;
                                }
                                case 16: {
                                    this.nativeUpdateExposureRel(this.mNativePtr);
                                    break;
                                }
                                case 32: {
                                    this.nativeUpdateFocus(this.mNativePtr);
                                    break;
                                }
                                case 64: {
                                    this.nativeUpdateExposureRel(this.mNativePtr);
                                    break;
                                }
                                case 128: {
                                    this.nativeUpdateIris(this.mNativePtr);
                                    break;
                                }
                                case 256: {
                                    this.nativeUpdateIrisRel(this.mNativePtr);
                                    break;
                                }
                                case 512: {
                                    this.nativeUpdateZoom(this.mNativePtr);
                                    break;
                                }
                                case 1024: {
                                    this.nativeUpdateZoomRel(this.mNativePtr);
                                    break;
                                }
                                case 2048: {
                                    this.nativeUpdatePanTilt(this.mNativePtr);
                                    break;
                                }
                                case 4096: {
                                    this.nativeUpdatePanRel(this.mNativePtr);
                                    this.nativeUpdateTiltRel(this.mNativePtr);
                                    break;
                                }
                                case 8192: {
                                    this.nativeUpdateRoll(this.mNativePtr);
                                    break;
                                }
                                case 16384: {
                                    this.nativeUpdateRollRel(this.mNativePtr);
                                    break;
                                }
                                case 131072: {
                                    this.nativeUpdateAutoFocus(this.mNativePtr);
                                    break;
                                }
                                case 262144: {
                                    this.nativeUpdatePrivacy(this.mNativePtr);
                                }
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.mProcSupports != 0L) {
                    int[] procs = PROCS;
                    for (i = procs.length - 1; i >= 0; --i) {
                        int proc = procs[i];
                        try {
                            switch ((int)(this.mProcSupports & (long)proc | Integer.MIN_VALUE)) {
                                case -2147483647: {
                                    this.nativeUpdateBrightness(this.mNativePtr);
                                    break;
                                }
                                case -2147483646: {
                                    this.nativeUpdateContrast(this.mNativePtr);
                                    break;
                                }
                                case -2147483644: {
                                    this.nativeUpdateHue(this.mNativePtr);
                                    break;
                                }
                                case -2147483640: {
                                    this.nativeUpdateSaturation(this.mNativePtr);
                                    break;
                                }
                                case -2147483632: {
                                    this.nativeUpdateSharpness(this.mNativePtr);
                                    break;
                                }
                                case -2147483616: {
                                    this.nativeUpdateGamma(this.mNativePtr);
                                    break;
                                }
                                case -2147483584: {
                                    this.nativeUpdateWhiteBlance(this.mNativePtr);
                                    break;
                                }
                                case -2147483520: {
                                    this.nativeUpdateWhiteBlanceCompo(this.mNativePtr);
                                    break;
                                }
                                case -2147483392: {
                                    this.nativeUpdateBacklightComp(this.mNativePtr);
                                    break;
                                }
                                case -2147483136: {
                                    this.nativeUpdateGain(this.mNativePtr);
                                    break;
                                }
                                case -2147482624: {
                                    this.nativeUpdatePowerlineFrequency(this.mNativePtr);
                                    break;
                                }
                                case -2147481600: {
                                    this.nativeUpdateAutoHue(this.mNativePtr);
                                    break;
                                }
                                case -2147479552: {
                                    this.nativeUpdateAutoWhiteBlance(this.mNativePtr);
                                    break;
                                }
                                case -2147475456: {
                                    this.nativeUpdateAutoWhiteBlanceCompo(this.mNativePtr);
                                    break;
                                }
                                case -2147467264: {
                                    this.nativeUpdateDigitalMultiplier(this.mNativePtr);
                                    break;
                                }
                                case -2147450880: {
                                    this.nativeUpdateDigitalMultiplierLimit(this.mNativePtr);
                                    break;
                                }
                                case -2147418112: {
                                    this.nativeUpdateAnalogVideoStandard(this.mNativePtr);
                                    break;
                                }
                                case -2147352576: {
                                    this.nativeUpdateAnalogVideoLockState(this.mNativePtr);
                                    break;
                                }
                                case -2147221504: {
                                    this.nativeUpdateAutoContrast(this.mNativePtr);
                                }
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        } else {
            this.mProcSupports = 0L;
            this.mControlSupports = 0L;
        }
    }

    public void testSupportedFuncs() {
        UVCPipeline.dumpControls(this.getSupportedCtrl());
        UVCPipeline.dumpProc(this.getSupportedProc());
    }

    @Override
    public int controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int offset, int length, int timeout) throws IllegalStateException {
        this.readLock();
        try {
            if (this.mNativePtr != 0L) {
                int n = this.nativeControlTransfer(this.mNativePtr, requestType, request, value, index, buffer, offset, length, timeout);
                return n;
            }
            throw new IllegalStateException("already released?");
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public synchronized boolean setAutoFocus(boolean autoFocus) {
        if (this.mNativePtr != 0L) {
            this.nativeSetAutoFocus(this.mNativePtr, autoFocus);
        }
        return this.getAutoFocus();
    }

    @Override
    public synchronized boolean getAutoFocus() {
        boolean result = true;
        if (this.mNativePtr != 0L) {
            result = this.nativeGetAutoFocus(this.mNativePtr) > 0;
        }
        return result;
    }

    @Override
    public synchronized boolean getAutoFocusDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAutoFocus(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mAutoFocusDef > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean resetAutoFocus() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAutoFocus(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetAutoFocus(this.mNativePtr, this.mAutoFocusDef > 0);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAutoFocus();
    }

    @Override
    public synchronized FuncMaxMinDef getAutoFocusInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateAutoFocus(this.mNativePtr);
        if (err != 0) {
            Log.d((String)TAG, (String)("getAutoFocusInfo:err=" + err));
            return new FuncMaxMinDef(0, 1, this.mAutoFocusDef, this.nativeGetAutoFocus(this.mNativePtr));
        }
        return new FuncMaxMinDef(this.mAutoFocusMin, this.mAutoFocusMax, this.mAutoFocusDef, this.nativeGetAutoFocus(this.mNativePtr));
    }

    @Override
    public synchronized int setFocus(int focus) {
        float range;
        if (this.mNativePtr != 0L && (range = (float)Math.abs(this.mFocusMax - this.mFocusMin)) > 0.0f) {
            this.nativeSetFocus(this.mNativePtr, (int)((float)focus / 100.0f * range) + this.mFocusMin);
        }
        return this.getFocus();
    }

    public synchronized int getFocus(int focus_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateFocus(this.mNativePtr);
            float range = Math.abs(this.mFocusMax - this.mFocusMin);
            if (range > 0.0f) {
                result = (int)((float)(focus_abs - this.mFocusMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public int getFocusDef() {
        return this.getFocus(this.mFocusDef);
    }

    @Override
    public synchronized int getFocus() {
        return this.getFocus(this.nativeGetFocus(this.mNativePtr));
    }

    @Override
    public synchronized int resetFocus() {
        if (this.mNativePtr != 0L) {
            this.nativeSetFocus(this.mNativePtr, this.mFocusDef);
        }
        return this.getFocus();
    }

    @Override
    public synchronized FuncMaxMinDef getFocusInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateFocus(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mFocusMin, this.mFocusMax, this.mFocusDef, this.nativeGetFocus(this.mNativePtr));
    }

    @Override
    public synchronized boolean setAutoWhiteBlance(boolean autoWhiteBlance) {
        if (this.mNativePtr != 0L) {
            this.nativeSetAutoWhiteBlance(this.mNativePtr, autoWhiteBlance);
        }
        return this.getAutoWhiteBlance();
    }

    @Override
    public synchronized boolean getAutoWhiteBlance() {
        boolean result = true;
        if (this.mNativePtr != 0L) {
            result = this.nativeGetAutoWhiteBlance(this.mNativePtr) > 0;
        }
        return result;
    }

    @Override
    public synchronized boolean getAutoWhiteBlanceDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAutoWhiteBlance(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mAutoWhiteBlanceDef > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean resetAutoWhiteBlance() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAutoWhiteBlance(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetAutoWhiteBlance(this.mNativePtr, this.mAutoWhiteBlanceDef > 0);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAutoWhiteBlance();
    }

    @Override
    public synchronized FuncMaxMinDef getAutoWhiteBlanceInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateAutoWhiteBlance(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mAutoWhiteBlanceMin, this.mAutoWhiteBlanceMax, this.mAutoWhiteBlanceDef, this.nativeGetAutoWhiteBlance(this.mNativePtr));
    }

    @Override
    public synchronized int setWhiteBlance(int whiteBlance) {
        float range;
        if (this.mNativePtr != 0L && (range = (float)Math.abs(this.mWhiteBlanceMax - this.mWhiteBlanceMin)) > 0.0f) {
            this.nativeSetWhiteBlance(this.mNativePtr, (int)((float)whiteBlance / 100.0f * range) + this.mWhiteBlanceMin);
        }
        return this.getWhiteBlance();
    }

    public synchronized int getWhiteBlance(int whiteBlance_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateWhiteBlance(this.mNativePtr);
            float range = Math.abs(this.mWhiteBlanceMax - this.mWhiteBlanceMin);
            if (range > 0.0f) {
                result = (int)((float)(whiteBlance_abs - this.mWhiteBlanceMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getWhiteBlance() {
        return this.getWhiteBlance(this.nativeGetWhiteBlance(this.mNativePtr));
    }

    @Override
    public int getWhiteBlanceDef() {
        return this.getWhiteBlance(this.mWhiteBlanceDef);
    }

    @Override
    public synchronized int resetWhiteBlance() {
        if (this.mNativePtr != 0L) {
            this.nativeSetWhiteBlance(this.mNativePtr, this.mWhiteBlanceDef);
        }
        return this.getWhiteBlance();
    }

    @Override
    public synchronized FuncMaxMinDef getWhiteBlanceInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateWhiteBlance(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mWhiteBlanceMin, this.mWhiteBlanceMax, this.mWhiteBlanceDef, this.nativeGetWhiteBlance(this.mNativePtr));
    }

    @Override
    public synchronized int setBrightness(int brightness) {
        float range;
        if (this.mNativePtr != 0L && (range = (float)Math.abs(this.mBrightnessMax - this.mBrightnessMin)) > 0.0f) {
            this.nativeSetBrightness(this.mNativePtr, (int)((float)brightness / 100.0f * range) + this.mBrightnessMin);
        }
        return this.getBrightness();
    }

    public synchronized int getBrightness(int brightness_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateBrightness(this.mNativePtr);
            float range = Math.abs(this.mBrightnessMax - this.mBrightnessMin);
            if (range > 0.0f) {
                result = (int)((float)(brightness_abs - this.mBrightnessMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getBrightness() {
        return this.getBrightness(this.nativeGetBrightness(this.mNativePtr));
    }

    @Override
    public int getBrightnessDef() {
        return this.getBrightness(this.mBrightnessDef);
    }

    @Override
    public synchronized int resetBrightness() {
        if (this.mNativePtr != 0L) {
            this.nativeSetBrightness(this.mNativePtr, this.mBrightnessDef);
        }
        return this.getBrightness();
    }

    @Override
    public synchronized FuncMaxMinDef getBrightnessInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateBrightness(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mBrightnessMin, this.mBrightnessMax, this.mBrightnessDef, this.nativeGetBrightness(this.mNativePtr));
    }

    @Override
    public synchronized int setContrast(int contrast) {
        if (this.mNativePtr != 0L) {
            this.nativeUpdateContrast(this.mNativePtr);
            float range = Math.abs(this.mContrastMax - this.mContrastMin);
            if (range > 0.0f) {
                this.nativeSetContrast(this.mNativePtr, (int)((float)contrast / 100.0f * range) + this.mContrastMin);
            }
        }
        return this.getContrast();
    }

    public synchronized int getContrast(int contrast_abs) {
        float range;
        int result = 0;
        if (this.mNativePtr != 0L && (range = (float)Math.abs(this.mContrastMax - this.mContrastMin)) > 0.0f) {
            result = (int)((float)(contrast_abs - this.mContrastMin) * 100.0f / range);
        }
        return result;
    }

    @Override
    public synchronized int getContrast() {
        return this.getContrast(this.nativeGetContrast(this.mNativePtr));
    }

    @Override
    public int getContrastDef() {
        return this.getContrast(this.mContrastDef);
    }

    @Override
    public synchronized int resetContrast() {
        if (this.mNativePtr != 0L) {
            this.nativeSetContrast(this.mNativePtr, this.mContrastDef);
        }
        return this.getContrast();
    }

    @Override
    public synchronized FuncMaxMinDef getContrastInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateContrast(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mContrastMin, this.mContrastMax, this.mContrastDef, this.nativeGetContrast(this.mNativePtr));
    }

    @Override
    public synchronized int setSharpness(int sharpness) {
        float range;
        if (this.mNativePtr != 0L && (range = (float)Math.abs(this.mSharpnessMax - this.mSharpnessMin)) > 0.0f) {
            this.nativeSetSharpness(this.mNativePtr, (int)((float)sharpness / 100.0f * range) + this.mSharpnessMin);
        }
        return this.getSharpness();
    }

    public synchronized int getSharpness(int sharpness_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateSharpness(this.mNativePtr);
            float range = Math.abs(this.mSharpnessMax - this.mSharpnessMin);
            if (range > 0.0f) {
                result = (int)((float)(sharpness_abs - this.mSharpnessMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getSharpness() {
        return this.getSharpness(this.nativeGetSharpness(this.mNativePtr));
    }

    @Override
    public int getSharpnessDef() {
        return this.getSharpness(this.mSharpnessDef);
    }

    @Override
    public synchronized int resetSharpness() {
        if (this.mNativePtr != 0L) {
            this.nativeSetSharpness(this.mNativePtr, this.mSharpnessDef);
        }
        return this.getSharpness();
    }

    @Override
    public synchronized FuncMaxMinDef getSharpnessInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateSharpness(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mSharpnessMin, this.mSharpnessMax, this.mSharpnessDef, this.nativeGetSharpness(this.mNativePtr));
    }

    @Override
    public synchronized int setGain(int gain) {
        float range;
        if (this.mNativePtr != 0L && (range = (float)Math.abs(this.mGainMax - this.mGainMin)) > 0.0f) {
            this.nativeSetGain(this.mNativePtr, (int)((float)gain / 100.0f * range) + this.mGainMin);
        }
        return this.getGain();
    }

    public synchronized int getGain(int gain_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateGain(this.mNativePtr);
            float range = Math.abs(this.mGainMax - this.mGainMin);
            if (range > 0.0f) {
                result = (int)((float)(gain_abs - this.mGainMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getGain() {
        return this.getGain(this.nativeGetGain(this.mNativePtr));
    }

    @Override
    public int getGainDef() {
        return this.getGain(this.mGainDef);
    }

    @Override
    public synchronized int resetGain() {
        if (this.mNativePtr != 0L) {
            this.nativeSetGain(this.mNativePtr, this.mGainDef);
        }
        return this.getGain();
    }

    @Override
    public synchronized FuncMaxMinDef getGainInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateGain(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mGainMin, this.mGainMax, this.mGainDef, this.nativeGetGain(this.mNativePtr));
    }

    @Override
    public synchronized int setGamma(int gamma) {
        float range;
        if (this.mNativePtr != 0L && (range = (float)Math.abs(this.mGammaMax - this.mGammaMin)) > 0.0f) {
            this.nativeSetGamma(this.mNativePtr, (int)((float)gamma / 100.0f * range) + this.mGammaMin);
        }
        return this.getGamma();
    }

    public synchronized int getGamma(int gamma_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateGamma(this.mNativePtr);
            float range = Math.abs(this.mGammaMax - this.mGammaMin);
            if (range > 0.0f) {
                result = (int)((float)(gamma_abs - this.mGammaMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getGamma() {
        return this.getGamma(this.nativeGetGamma(this.mNativePtr));
    }

    @Override
    public int getGammaDef() {
        return this.getGamma(this.mGammaDef);
    }

    @Override
    public synchronized int resetGamma() {
        if (this.mNativePtr != 0L) {
            this.nativeSetGamma(this.mNativePtr, this.mGammaDef);
        }
        return this.getGamma();
    }

    @Override
    public synchronized FuncMaxMinDef getGammaInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateGamma(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mGammaMin, this.mGammaMax, this.mGammaDef, this.nativeGetGamma(this.mNativePtr));
    }

    @Override
    public synchronized int setSaturation(int saturation) {
        float range;
        if (this.mNativePtr != 0L && (range = (float)Math.abs(this.mSaturationMax - this.mSaturationMin)) > 0.0f) {
            this.nativeSetSaturation(this.mNativePtr, (int)((float)saturation / 100.0f * range) + this.mSaturationMin);
        }
        return this.getSaturation();
    }

    public synchronized int getSaturation(int saturation_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateSaturation(this.mNativePtr);
            float range = Math.abs(this.mSaturationMax - this.mSaturationMin);
            if (range > 0.0f) {
                result = (int)((float)(saturation_abs - this.mSaturationMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getSaturation() {
        return this.getSaturation(this.nativeGetSaturation(this.mNativePtr));
    }

    @Override
    public int getSaturationDef() {
        return this.getSaturation(this.mSaturationDef);
    }

    @Override
    public synchronized int resetSaturation() {
        if (this.mNativePtr != 0L) {
            this.nativeSetSaturation(this.mNativePtr, this.mSaturationDef);
        }
        return this.getSaturation();
    }

    @Override
    public synchronized FuncMaxMinDef getSaturationInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateSaturation(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mSaturationMin, this.mSaturationMax, this.mSaturationDef, this.nativeGetSaturation(this.mNativePtr));
    }

    @Override
    public synchronized int setHue(int hue) {
        float range;
        if (this.mNativePtr != 0L && (range = (float)Math.abs(this.mHueMax - this.mHueMin)) > 0.0f) {
            this.nativeSetHue(this.mNativePtr, (int)((float)hue / 100.0f * range) + this.mHueMin);
        }
        return this.getHue();
    }

    public synchronized int getHue(int hue_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateHue(this.mNativePtr);
            float range = Math.abs(this.mHueMax - this.mHueMin);
            if (range > 0.0f) {
                result = (int)((float)(hue_abs - this.mHueMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getHue() {
        return this.getHue(this.nativeGetHue(this.mNativePtr));
    }

    @Override
    public int getHueDef() {
        return this.getHue(this.mHueDef);
    }

    @Override
    public synchronized int resetHue() {
        if (this.mNativePtr != 0L) {
            this.nativeSetHue(this.mNativePtr, this.mSaturationDef);
        }
        return this.getHue();
    }

    @Override
    public synchronized FuncMaxMinDef getHueInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateHue(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mHueMin, this.mHueMax, this.mHueDef, this.nativeGetHue(this.mNativePtr));
    }

    @Override
    public int setPowerlineFrequency(int frequency) {
        if (this.mNativePtr != 0L) {
            this.nativeSetPowerlineFrequency(this.mNativePtr, frequency);
        }
        return this.getPowerlineFrequency();
    }

    @Override
    public int getPowerlineFrequency() {
        return this.nativeGetPowerlineFrequency(this.mNativePtr);
    }

    @Override
    public int getPowerlineFrequencyDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdatePowerlineFrequency(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mPowerlineFrequencyDef;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int resetPowerlineFrequency() {
        return this.setPowerlineFrequency(-1);
    }

    @Override
    public synchronized FuncMaxMinDef getPowerlineFrequencyInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdatePowerlineFrequency(this.mNativePtr);
        if (err != 0) {
            Log.d((String)TAG, (String)("getPowerlineFrequencyInfo:err" + err));
            return new FuncMaxMinDef(0, 3, this.mPowerlineFrequencyDef, this.nativeGetPowerlineFrequency(this.mNativePtr));
        }
        return new FuncMaxMinDef(this.mPowerlineFrequencyMin, this.mPowerlineFrequencyMax, this.mPowerlineFrequencyDef, this.nativeGetPowerlineFrequency(this.mNativePtr));
    }

    @Override
    public synchronized int setZoom(int zoom) {
        float range;
        if (this.mNativePtr != 0L && (range = (float)Math.abs(this.mZoomMax - this.mZoomMin)) > 0.0f) {
            int z = (int)((float)zoom / 100.0f * range) + this.mZoomMin;
            this.nativeSetZoom(this.mNativePtr, z);
        }
        return this.getZoom();
    }

    public synchronized int getZoom(int zoom_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateZoom(this.mNativePtr);
            float range = Math.abs(this.mZoomMax - this.mZoomMin);
            if (range > 0.0f) {
                result = (int)((float)(zoom_abs - this.mZoomMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getZoom() {
        return this.getZoom(this.nativeGetZoom(this.mNativePtr));
    }

    @Override
    public int getZoomDef() {
        return this.getZoom(this.mZoomDef);
    }

    @Override
    public synchronized int resetZoom() {
        if (this.mNativePtr != 0L) {
            this.nativeSetZoom(this.mNativePtr, this.mZoomDef);
        }
        return this.getZoom();
    }

    @Override
    public synchronized FuncMaxMinDef getZoomInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateZoom(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mZoomMin, this.mZoomMax, this.mZoomDef, this.nativeGetZoom(this.mNativePtr));
    }

    @Override
    public synchronized boolean setScanningMode(boolean isProgressive) {
        if (this.mNativePtr != 0L) {
            int err = this.nativeSetScanningMode(this.mNativePtr, isProgressive);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getScanningMode();
    }

    @Override
    public synchronized boolean getScanningMode() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetScanningMode(this.mNativePtr) > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean getScanningModeDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateScanningMode(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.mScanningModeDef > 0;
    }

    @Override
    public synchronized boolean resetScanningMode() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateScanningMode(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetScanningMode(this.mNativePtr, this.mScanningModeDef > 0);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getScanningMode();
    }

    @Override
    public synchronized FuncMaxMinDef getScanningModeInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateScanningMode(this.mNativePtr);
        if (err != 0) {
            return new FuncMaxMinDef(0, 1, 0, this.nativeGetScanningMode(this.mNativePtr));
        }
        return new FuncMaxMinDef(this.mScanningModeMin, this.mScanningModeMax, this.mScanningModeDef, this.nativeGetScanningMode(this.mNativePtr));
    }

    @Override
    public synchronized int setExposureMode(int exposure_mode) {
        block5: {
            block4: {
                if (this.mNativePtr == 0L) break block4;
                switch (exposure_mode) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: {
                        int err = this.nativeSetExposureMode(this.mNativePtr, exposure_mode);
                        if (err != 0) {
                            throw new IllegalArgumentException("err=" + err);
                        }
                        break block5;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            throw new IllegalStateException("camera is not ready");
        }
        return this.getExposureMode();
    }

    @Override
    public synchronized int getExposureMode() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetExposureMode(this.mNativePtr);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int getExposureModeDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateExposureMode(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.mExposureModeDef;
    }

    @Override
    public synchronized int resetExposureMode() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateExposureMode(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetExposureMode(this.mNativePtr, this.mExposureModeDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getExposureMode();
    }

    @Override
    public synchronized FuncMaxMinDef getExposureModeInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateExposureMode(this.mNativePtr);
        if (err != 0) {
            Log.d((String)TAG, (String)("getExposureModeInfo:err=" + err));
            int cur = this.nativeGetExposureMode(this.mNativePtr);
            return new FuncMaxMinDef(1, 8, cur, cur);
        }
        return new FuncMaxMinDef(this.mExposureModeMin, this.mExposureModeMax, this.mExposureModeDef, this.nativeGetExposureMode(this.mNativePtr));
    }

    @Override
    public synchronized int setExposurePriority(int exposure_priority) {
        if (this.mNativePtr != 0L) {
            int z;
            int err;
            float range = Math.abs(this.mExposurePriorityMax - this.mExposurePriorityMin);
            if (range > 0.0f && (err = this.nativeSetExposurePriority(this.mNativePtr, z = (int)((float)exposure_priority / 100.0f * range) + this.mExposurePriorityMin)) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getExposurePriority();
    }

    public int getExposurePriority(int exposure_priority_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateExposurePriority(this.mNativePtr);
            float range = Math.abs(this.mExposurePriorityMax - this.mExposurePriorityMin);
            if (range > 0.0f) {
                result = (int)((float)(exposure_priority_abs - this.mExposurePriorityMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getExposurePriority() {
        if (this.mNativePtr != 0L) {
            return this.getExposurePriority(this.nativeGetExposurePriority(this.mNativePtr));
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getExposurePriorityDef() {
        return this.getExposurePriority(this.mExposurePriorityDef);
    }

    @Override
    public synchronized int resetExposurePriority() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateExposurePriority(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetExposurePriority(this.mNativePtr, this.mExposurePriorityDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getExposurePriority();
    }

    @Override
    public synchronized FuncMaxMinDef getExposurePriorityInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateExposurePriority(this.mNativePtr);
        if (err != 0) {
            Log.d((String)TAG, (String)("getExposurePriorityInfo:err=" + err));
            return new FuncMaxMinDef(0, 1, 0, this.nativeGetExposurePriority(this.mNativePtr));
        }
        return new FuncMaxMinDef(this.mExposurePriorityMin, this.mExposurePriorityMax, this.mExposurePriorityDef, this.nativeGetExposurePriority(this.mNativePtr));
    }

    @Override
    public synchronized int setExposure(int exposure) {
        if (this.mNativePtr != 0L) {
            int value;
            int err;
            float range = Math.abs(this.mExposureMax - this.mExposureMin);
            if (range > 0.0f && (err = this.nativeSetExposure(this.mNativePtr, value = (int)((float)exposure / 100.0f * range) + this.mExposureMin)) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getExposure();
    }

    public synchronized int getExposure(int exposure_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateExposure(this.mNativePtr);
            float range = Math.abs(this.mExposureMax - this.mExposureMin);
            if (range > 0.0f) {
                result = (int)((float)(exposure_abs - this.mExposureMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getExposure() {
        if (this.mNativePtr != 0L) {
            return this.getExposure(this.nativeGetExposure(this.mNativePtr));
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getExposureDef() {
        return this.getExposure(this.mExposureDef);
    }

    @Override
    public synchronized int resetExposure() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateExposure(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetExposure(this.mNativePtr, this.mExposureDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getExposure();
    }

    @Override
    public synchronized FuncMaxMinDef getExposureInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateExposure(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mExposureMin, this.mExposureMax, this.mExposureDef, this.nativeGetExposure(this.mNativePtr));
    }

    @Override
    public synchronized int setExposureRel(int exposure_rel) {
        if (this.mNativePtr != 0L) {
            int value = exposure_rel < 0 ? 255 : (exposure_rel > 0 ? 1 : 0);
            int err = this.nativeSetExposureRel(this.mNativePtr, value);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getExposureRel();
    }

    @Override
    public synchronized int getExposureRel() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetExposureRel(this.mNativePtr);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int getExposureRelDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateExposureRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mExposureRelDef;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int resetExposureRel() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateExposureRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetExposureRel(this.mNativePtr, this.mExposureRelDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getExposureRel();
    }

    @Override
    public synchronized FuncMaxMinDef getExposureRelInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateExposureRel(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mExposureRelMin, this.mExposureRelMax, this.mExposureRelDef, this.nativeGetExposureRel(this.mNativePtr));
    }

    @Override
    public synchronized int setFocusRel(int focus_rel) {
        if (this.mNativePtr != 0L) {
            int value = focus_rel < 0 ? 255 : (focus_rel > 0 ? 1 : 0);
            int err = this.nativeSetFocusRel(this.mNativePtr, value);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getExposure();
    }

    @Override
    public synchronized int getFocusRel() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetFocusRel(this.mNativePtr);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int getFocusRelDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateFocusRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mFocusRelDef;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int resetFocusRel() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateFocusRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetFocusRel(this.mNativePtr, this.mFocusRelDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getFocusRel();
    }

    @Override
    public synchronized FuncMaxMinDef getFocusRelInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateFocusRel(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mFocusRelMin, this.mFocusRelMax, this.mFocusRelDef, this.nativeGetFocusRel(this.mNativePtr));
    }

    @Override
    public synchronized int setIris(int iris) {
        if (this.mNativePtr != 0L) {
            int value;
            int err;
            float range = Math.abs(this.mIrisMax - this.mIrisMin);
            if (range > 0.0f && (err = this.nativeSetIris(this.mNativePtr, value = (int)((float)iris / 100.0f * range) + this.mIrisMin)) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getIris();
    }

    public synchronized int getIris(int iris_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateIris(this.mNativePtr);
            float range = Math.abs(this.mIrisMax - this.mIrisMin);
            if (range > 0.0f) {
                result = (int)((float)(iris_abs - this.mIrisMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getIris() {
        if (this.mNativePtr != 0L) {
            return this.getIris(this.nativeGetIris(this.mNativePtr));
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getIrisDef() {
        return this.getIris(this.mIrisDef);
    }

    @Override
    public synchronized int resetIris() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateIris(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetIris(this.mNativePtr, this.mIrisDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getIris();
    }

    @Override
    public synchronized FuncMaxMinDef getIrisInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateIris(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mIrisMin, this.mIrisMax, this.mIrisDef, this.nativeGetIris(this.mNativePtr));
    }

    @Override
    public synchronized int setIrisRel(int iris_rel) {
        if (this.mNativePtr != 0L) {
            int value = iris_rel < 0 ? 255 : (iris_rel > 0 ? 1 : 0);
            int err = this.nativeSetIrisRel(this.mNativePtr, value);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getIrisRel();
    }

    @Override
    public synchronized int getIrisRel() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetIrisRel(this.mNativePtr);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int getIrisRelDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateIrisRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mIrisRelDef;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int resetIrisRel() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateIrisRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetIrisRel(this.mNativePtr, this.mIrisRelDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getIrisRel();
    }

    @Override
    public synchronized FuncMaxMinDef getIrisRelInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateIrisRel(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mIrisRelMin, this.mIrisRelMax, this.mIrisRelDef, this.nativeGetIrisRel(this.mNativePtr));
    }

    @Override
    public synchronized int setPanTilt(int pan, int tilt) {
        if (this.mNativePtr != 0L) {
            int value_tilt;
            int value_pan;
            int err;
            float range_pan = Math.abs(this.mPanMax - this.mPanMin);
            float range_tilt = Math.abs(this.mTiltMax - this.mTiltMin);
            if (range_pan > 0.0f && range_tilt > 0.0f && (err = this.nativeSetPanTilt(this.mNativePtr, value_pan = (int)((float)pan / 100.0f * range_pan) + this.mPanMin, value_tilt = (int)((float)tilt / 100.0f * range_tilt) + this.mTiltMin)) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getPanTilt();
    }

    public synchronized int getPanTilt(int pan_abs, int tilt_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdatePanTilt(this.mNativePtr);
            float range_pan = Math.abs(this.mPanMax - this.mPanMin);
            float range_tilt = Math.abs(this.mTiltMax - this.mTiltMin);
            if (range_pan > 0.0f && range_tilt > 0.0f) {
                result = ((int)((float)(pan_abs - this.mPanMin) * 100.0f / range_pan) << 16) + (int)((float)(tilt_abs - this.mTiltMin) * 100.0f / range_tilt);
            }
        }
        return result;
    }

    @Override
    public synchronized int getPanTilt() {
        if (this.mNativePtr != 0L) {
            int pan_abs = this.nativeGetPan(this.mNativePtr);
            int tilt_abs = this.nativeGetTilt(this.mNativePtr);
            return this.getPanTilt(pan_abs, tilt_abs);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getPanTiltDef() {
        return this.getPanTilt(this.mPanDef, this.mTiltDef);
    }

    @Override
    public synchronized int resetPanTilt() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdatePanTilt(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetPanTilt(this.mNativePtr, this.mPanDef, this.mTiltDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getPanTilt();
    }

    @Override
    public synchronized int setPan(int pan) {
        if (this.mNativePtr != 0L) {
            int value;
            int err;
            float range = Math.abs(this.mPanMax - this.mPanMin);
            if (range > 0.0f && (err = this.nativeSetPan(this.mNativePtr, value = (int)((float)pan / 100.0f * range) + this.mPanMin)) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getPan();
    }

    public synchronized int getPan(int pan_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdatePan(this.mNativePtr);
            float range = Math.abs(this.mPanMax - this.mPanMin);
            if (range > 0.0f) {
                result = (int)((float)(pan_abs - this.mPanMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getPan() {
        if (this.mNativePtr != 0L) {
            return this.getPan(this.nativeGetPan(this.mNativePtr));
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getPanDef() {
        return this.getPan(this.mPanDef);
    }

    @Override
    public synchronized int resetPan() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdatePan(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetPan(this.mNativePtr, this.mPanDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getPan();
    }

    @Override
    public synchronized FuncMaxMinDef getPanInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdatePan(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mPanMin, this.mPanMax, this.mPanDef, this.nativeGetPan(this.mNativePtr));
    }

    @Override
    public synchronized int setPanRel(int pan_rel, int pan_speed) {
        if (this.mNativePtr != 0L) {
            int value = pan_rel < 0 ? 255 : (pan_rel > 0 ? 1 : 0);
            int err = this.nativeSetPanRel(this.mNativePtr, value, pan_speed);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getPanRel();
    }

    @Override
    public synchronized int getPanRel() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetPanRel(this.mNativePtr);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int getPanRelDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdatePanRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mPanRelDef;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int resetPanRel() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdatePanRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetPanRel(this.mNativePtr, 0, this.mPanRelDef & 0xFFFF);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getPanRel();
    }

    @Override
    public synchronized FuncMaxMinDef getPanRelInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdatePanRel(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mPanRelMin, this.mPanRelMax, this.mPanRelDef, this.nativeGetPanRel(this.mNativePtr));
    }

    @Override
    public synchronized int setTilt(int tilt) {
        if (this.mNativePtr != 0L) {
            int value;
            int err;
            float range = Math.abs(this.mTiltMax - this.mTiltMin);
            if (range > 0.0f && (err = this.nativeSetTilt(this.mNativePtr, value = (int)((float)tilt / 100.0f * range) + this.mTiltMin)) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getTilt();
    }

    public synchronized int getTilt(int tilt_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateTilt(this.mNativePtr);
            float range = Math.abs(this.mTiltMax - this.mTiltMin);
            if (range > 0.0f) {
                result = (int)((float)(tilt_abs - this.mTiltMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getTilt() {
        if (this.mNativePtr != 0L) {
            return this.getTilt(this.nativeGetTilt(this.mNativePtr));
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getTiltDef() {
        return this.getTilt(this.mTiltDef);
    }

    @Override
    public synchronized int resetTilt() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateTilt(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetTilt(this.mNativePtr, this.mTiltDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getTilt();
    }

    @Override
    public synchronized FuncMaxMinDef getTiltInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateTilt(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mTiltMin, this.mTiltMax, this.mTiltDef, this.nativeGetTilt(this.mNativePtr));
    }

    @Override
    public synchronized int setTiltRel(int tilt_rel, int tilt_speed) {
        if (this.mNativePtr != 0L) {
            int value = tilt_rel < 0 ? 255 : (tilt_rel > 0 ? 1 : 0);
            int err = this.nativeSetTiltRel(this.mNativePtr, value, tilt_speed);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getTiltRel();
    }

    @Override
    public synchronized int getTiltRel() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetTiltRel(this.mNativePtr);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int getTiltRelDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateTiltRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mTiltRelDef;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int resetTiltRel() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateTiltRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetTiltRel(this.mNativePtr, 0, this.mTiltRelDef & 0xFFFF);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getTiltRel();
    }

    @Override
    public synchronized FuncMaxMinDef getTiltRelInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateTiltRel(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mTiltRelMin, this.mTiltRelMax, this.mTiltRelDef, this.nativeGetTiltRel(this.mNativePtr));
    }

    @Override
    public synchronized int setRoll(int roll) {
        if (this.mNativePtr != 0L) {
            int value;
            int err;
            float range = Math.abs(this.mRollMax - this.mRollMin);
            if (range > 0.0f && (err = this.nativeSetTilt(this.mNativePtr, value = (int)((float)roll / 100.0f * range) + this.mRollMin)) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getRoll();
    }

    public synchronized int getRoll(int roll_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateRoll(this.mNativePtr);
            float range = Math.abs(this.mRollMax - this.mRollMin);
            if (range > 0.0f) {
                result = (int)((float)(roll_abs - this.mRollMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getRoll() {
        if (this.mNativePtr != 0L) {
            return this.getRoll(this.nativeGetRoll(this.mNativePtr));
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getRollDef() {
        return this.getRoll(this.mRollDef);
    }

    @Override
    public synchronized int resetRoll() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateRoll(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetRoll(this.mNativePtr, this.mRollDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getRoll();
    }

    @Override
    public synchronized FuncMaxMinDef getRollInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateRoll(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mRollMin, this.mRollMax, this.mRollDef, this.nativeGetRoll(this.mNativePtr));
    }

    @Override
    public synchronized int setRollRel(int roll_rel, int roll_speed) {
        if (this.mNativePtr != 0L) {
            int value = roll_rel < 0 ? 255 : (roll_rel > 0 ? 1 : 0);
            int err = this.nativeSetRollRel(this.mNativePtr, value, roll_speed);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getRollRel();
    }

    @Override
    public synchronized int getRollRel() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetRollRel(this.mNativePtr);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int getRollRelDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateRollRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mRollRelDef;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int resetRollRel() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateRollRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetRollRel(this.mNativePtr, 0, this.mRollRelDef & 0xFFFF);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getRollRel();
    }

    @Override
    public synchronized FuncMaxMinDef getRollRelInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateRollRel(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mRollRelMin, this.mRollRelMax, this.mRollRelDef, this.nativeGetRollRel(this.mNativePtr));
    }

    @Override
    public synchronized boolean setPrivacy(boolean privacy) {
        if (this.mNativePtr != 0L) {
            int err = this.nativeSetPrivacy(this.mNativePtr, privacy);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getPrivacy();
    }

    @Override
    public synchronized boolean getPrivacy() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetPrivacy(this.mNativePtr) > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean getPrivacyDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdatePrivacy(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mPrivacyDef > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean resetPrivacy() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdatePrivacy(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetPrivacy(this.mNativePtr, this.mPrivacyDef > 0);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getPrivacy();
    }

    @Override
    public synchronized FuncMaxMinDef getPrivacyInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdatePrivacy(this.mNativePtr);
        if (err != 0) {
            Log.d((String)TAG, (String)("getPrivacyInfo:err=" + err));
            return new FuncMaxMinDef(0, 1, 0, this.nativeGetPrivacy(this.mNativePtr));
        }
        return new FuncMaxMinDef(this.mPrivacyMin, this.mPrivacyMax, this.mPrivacyDef, this.nativeGetPrivacy(this.mNativePtr));
    }

    @Override
    public synchronized boolean setAutoWhiteBlanceCompo(boolean autoWhiteBlanceCompo) {
        if (this.mNativePtr != 0L) {
            int err = this.nativeSetAutoWhiteBlanceCompo(this.mNativePtr, autoWhiteBlanceCompo);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAutoWhiteBlanceCompo();
    }

    @Override
    public synchronized boolean getAutoWhiteBlanceCompo() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetAutoWhiteBlanceCompo(this.mNativePtr) > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean getAutoWhiteBlanceCompoDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAutoWhiteBlanceCompo(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mAutoWhiteBlanceCompoDef > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean resetAutoWhiteBlanceCompo() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAutoWhiteBlanceCompo(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetAutoWhiteBlanceCompo(this.mNativePtr, this.mAutoWhiteBlanceCompoDef > 0);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAutoWhiteBlanceCompo();
    }

    @Override
    public synchronized FuncMaxMinDef getAutoWhiteBlanceCompoInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateAutoWhiteBlanceCompo(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mAutoWhiteBlanceCompoMin, this.mAutoWhiteBlanceCompoMax, this.mAutoWhiteBlanceCompoDef, this.nativeGetAutoWhiteBlanceCompo(this.mNativePtr));
    }

    @Override
    public synchronized int setWhiteBlanceCompo(int whiteBalanceCompo) {
        if (this.mNativePtr != 0L) {
            int value_red;
            int value_blue;
            int err;
            int blue = whiteBalanceCompo >>> 16;
            int red = whiteBalanceCompo & 0xFFFF;
            float range_blue = Math.abs(this.mWhiteBlanceCompoBlueMax - this.mWhiteBlanceCompoBlueMin);
            float range_red = Math.abs(this.mWhiteBlanceCompoRedMax - this.mWhiteBlanceCompoRedMin);
            if (range_blue > 0.0f && range_red > 0.0f && (err = this.nativeSetWhiteBlanceCompo(this.mNativePtr, (value_blue = (int)((float)blue / 100.0f * range_blue) + this.mWhiteBlanceCompoBlueMin) << 16 + ((value_red = (int)((float)red / 100.0f * range_red) + this.mWhiteBlanceCompoRedMin) & 0xFFFF))) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getWhiteBlanceCompo();
    }

    public synchronized int getWhiteBlanceCompo(int whiteBalanceCompo_abs_blue, int whiteBalanceCompo_abs_red) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateWhiteBlanceCompo(this.mNativePtr);
            float range_blue = Math.abs(this.mWhiteBlanceCompoBlueMax - this.mWhiteBlanceCompoBlueMin);
            float range_red = Math.abs(this.mWhiteBlanceCompoRedMax - this.mWhiteBlanceCompoRedMin);
            if (range_blue > 0.0f && range_red > 0.0f) {
                int result_blue = (int)((float)(whiteBalanceCompo_abs_blue - this.mWhiteBlanceCompoBlueMin) * 100.0f / range_blue);
                int result_red = (int)((float)(whiteBalanceCompo_abs_red - this.mWhiteBlanceCompoRedMin) * 100.0f / range_red);
                result = result_blue << 16 + result_red;
            }
        }
        return result;
    }

    @Override
    public synchronized int getWhiteBlanceCompo() {
        if (this.mNativePtr != 0L) {
            int value = this.nativeGetWhiteBlanceCompo(this.mNativePtr);
            return this.getWhiteBlanceCompo(value >>> 16, value & 0xFFFF);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getWhiteBlanceCompoDef() {
        return this.getWhiteBlanceCompo(this.mWhiteBlanceCompoBlueDef, this.mWhiteBlanceCompoRedDef);
    }

    @Override
    public synchronized int resetWhiteBlanceCompo() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateWhiteBlanceCompo(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetWhiteBlanceCompo(this.mNativePtr, this.mWhiteBlanceCompoBlueDef << 16 + this.mWhiteBlanceCompoRedDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getWhiteBlanceCompo();
    }

    @Override
    public synchronized FuncMaxMinDef getWhiteBlanceCompoInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateWhiteBlanceCompo(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        int value = this.nativeGetWhiteBlanceCompo(this.mNativePtr);
        return new FuncMaxMinDef(this.mWhiteBlanceCompoBlueMin, this.mWhiteBlanceCompoBlueMax, this.mWhiteBlanceCompoBlueDef, value >>> 16, this.mWhiteBlanceCompoRedMin, this.mWhiteBlanceCompoRedMax, this.mWhiteBlanceCompoRedDef, value & 0xFFFF);
    }

    @Override
    public synchronized int setBacklightComp(int backlight) {
        if (this.mNativePtr != 0L) {
            int value;
            int err;
            float range = Math.abs(this.mBacklightCompMax - this.mBacklightCompMin);
            if (range > 0.0f && (err = this.nativeSetWhiteBlanceCompo(this.mNativePtr, value = (int)((float)backlight / 100.0f * range) + this.mBacklightCompMin)) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getBacklightComp();
    }

    public synchronized int getBacklightComp(int backlight_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateBacklightComp(this.mNativePtr);
            float range = Math.abs(this.mBacklightCompMax - this.mBacklightCompMin);
            if (range > 0.0f) {
                result = (int)((float)(backlight_abs - this.mBacklightCompMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getBacklightComp() {
        if (this.mNativePtr != 0L) {
            return this.getBacklightComp(this.nativeGetBacklightComp(this.mNativePtr));
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getBacklightCompDef() {
        return this.getBacklightComp(this.mBacklightCompDef);
    }

    @Override
    public synchronized int resetBacklightComp() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateBacklightComp(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetBacklightComp(this.mNativePtr, this.mBacklightCompDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getBacklightComp();
    }

    @Override
    public synchronized FuncMaxMinDef getBacklightCompInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateBacklightComp(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mBacklightCompMin, this.mBacklightCompMax, this.mBacklightCompDef, this.nativeGetBacklightComp(this.mNativePtr));
    }

    @Override
    public synchronized boolean setAutoContrast(boolean autoContrast) {
        if (this.mNativePtr != 0L) {
            int err = this.nativeSetAutoContrast(this.mNativePtr, autoContrast);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAutoContrast();
    }

    @Override
    public synchronized boolean getAutoContrast() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetAutoContrast(this.mNativePtr) > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean getAutoContrastDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAutoContrast(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mAutoContrastDef > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean resetAutoContrast() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAutoContrast(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetAutoContrast(this.mNativePtr, this.mAutoContrastDef > 0);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAutoContrast();
    }

    @Override
    public synchronized FuncMaxMinDef getAutoContrastInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateAutoContrast(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mAutoContrastMin, this.mAutoContrastMax, this.mAutoContrastDef, this.nativeGetAutoContrast(this.mNativePtr));
    }

    @Override
    public synchronized boolean setAutoHue(boolean autoHue) {
        if (this.mNativePtr != 0L) {
            int err = this.nativeSetAutoHue(this.mNativePtr, autoHue);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAutoHue();
    }

    @Override
    public synchronized boolean getAutoHue() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetAutoHue(this.mNativePtr) > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean getAutoHueDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAutoHue(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mAutoHueDef > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean resetAutoHue() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAutoHue(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetAutoHue(this.mNativePtr, this.mAutoHueDef > 0);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAutoHue();
    }

    @Override
    public synchronized FuncMaxMinDef getAutoHueInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateAutoHue(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mAutoHueMin, this.mAutoHueMax, this.mAutoHueDef, this.nativeGetAutoHue(this.mNativePtr));
    }

    @Override
    public synchronized int setZoomRel(int zoom_rel, boolean digital_zoom) {
        if (this.mNativePtr != 0L) {
            int zoom = (zoom_rel < 0 ? 255 : (zoom_rel > 0 ? 1 : 0)) << 8 + (digital_zoom ? 1 : 0);
            int err = this.nativeSetZoomRel(this.mNativePtr, zoom);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getZoomRel();
    }

    @Override
    public synchronized int getZoomRel() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetExposureRel(this.mNativePtr);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int getZoomRelDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateZoomRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mZoomRelDef;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int resetZoomRel() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateZoomRel(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetZoomRel(this.mNativePtr, this.mZoomRelDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getZoomRel();
    }

    @Override
    public synchronized FuncMaxMinDef getZoomRelInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateZoomRel(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mZoomRelMin, this.mZoomRelMax, this.mZoomRelDef, this.nativeGetZoomRel(this.mNativePtr));
    }

    @Override
    public synchronized int setDigitalMultiplier(int multiplier) {
        if (this.mNativePtr != 0L) {
            int value;
            int err;
            float range = Math.abs(this.mMultiplierMax - this.mMultiplierMin);
            if (range > 0.0f && (err = this.nativeSetDigitalMultiplier(this.mNativePtr, value = (int)((float)multiplier / 100.0f * range) + this.mMultiplierMin)) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getDigitalMultiplier();
    }

    public synchronized int getDigitalMultiplier(int multiplier_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateDigitalMultiplier(this.mNativePtr);
            float range = Math.abs(this.mMultiplierMax - this.mMultiplierMin);
            if (range > 0.0f) {
                result = (int)((float)(multiplier_abs - this.mMultiplierMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getDigitalMultiplier() {
        if (this.mNativePtr != 0L) {
            return this.getTilt(this.nativeGetDigitalMultiplier(this.mNativePtr));
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getDigitalMultiplierDef() {
        return this.getDigitalMultiplier(this.mMultiplierDef);
    }

    @Override
    public synchronized int resetDigitalMultiplier() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateDigitalMultiplier(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetDigitalMultiplier(this.mNativePtr, this.mMultiplierDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getDigitalMultiplier();
    }

    @Override
    public synchronized FuncMaxMinDef getDigitalMultiplierInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateDigitalMultiplier(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mMultiplierMin, this.mMultiplierMax, this.mMultiplierDef, this.nativeGetDigitalMultiplier(this.mNativePtr));
    }

    @Override
    public synchronized int setDigitalMultiplierLimit(int multiplier_limit_abs) {
        if (this.mNativePtr != 0L) {
            int value;
            int err;
            float range = Math.abs(this.mMultiplierLimitMax - this.mMultiplierLimitMin);
            if (range > 0.0f && (err = this.nativeSetDigitalMultiplierLimit(this.mNativePtr, value = (int)((float)multiplier_limit_abs / 100.0f * range) + this.mMultiplierLimitMin)) != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getDigitalMultiplierLimit();
    }

    public synchronized int getDigitalMultiplierLimit(int multiplier_limit_abs) {
        int result = 0;
        if (this.mNativePtr != 0L) {
            this.nativeUpdateDigitalMultiplierLimit(this.mNativePtr);
            float range = Math.abs(this.mMultiplierLimitMax - this.mMultiplierLimitMin);
            if (range > 0.0f) {
                result = (int)((float)(multiplier_limit_abs - this.mMultiplierLimitMin) * 100.0f / range);
            }
        }
        return result;
    }

    @Override
    public synchronized int getDigitalMultiplierLimit() {
        if (this.mNativePtr != 0L) {
            return this.getTilt(this.nativeGetDigitalMultiplierLimit(this.mNativePtr));
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public int getDigitalMultiplierLimitDef() {
        return this.getDigitalMultiplierLimit(this.mMultiplierLimitDef);
    }

    @Override
    public synchronized int resetDigitalMultiplierLimit() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateDigitalMultiplierLimit(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetDigitalMultiplierLimit(this.mNativePtr, this.mMultiplierLimitDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getDigitalMultiplierLimit();
    }

    @Override
    public synchronized FuncMaxMinDef getDigitalMultiplierLimitInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateDigitalMultiplierLimit(this.mNativePtr);
        if (err != 0) {
            throw new IllegalArgumentException("err=" + err);
        }
        return new FuncMaxMinDef(this.mMultiplierLimitMin, this.mMultiplierLimitMax, this.mMultiplierLimitDef, this.nativeGetDigitalMultiplierLimit(this.mNativePtr));
    }

    @Override
    public synchronized int setAnalogVideoStandard(int standard) {
        if (this.mNativePtr != 0L) {
            if (standard < this.mAnalogVideoStandardMin || standard > this.mAnalogVideoStandardMax) {
                throw new IllegalArgumentException();
            }
            int err = this.nativeSetAnalogVideoStandard(this.mNativePtr, standard);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAnalogVideoStandard();
    }

    @Override
    public synchronized int getAnalogVideoStandard() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetAnalogVideoStandard(this.mNativePtr);
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int getAnalogVideoStandardDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAnalogVideoStandard(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mAnalogVideoStandardDef;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized int resetAnalogVideoStandard() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAnalogVideoStandard(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetAnalogVideoStandard(this.mNativePtr, this.mAnalogVideoStandardDef);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAnalogVideoStandard();
    }

    @Override
    public synchronized FuncMaxMinDef getAnalogVideoStandardInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateAnalogVideoStandard(this.mNativePtr);
        if (err != 0) {
            Log.d((String)TAG, (String)("getAnalogVideoStandardInfo:err=" + err));
            return new FuncMaxMinDef(0, 5, this.mAnalogVideoStandardDef, this.nativeGetAnalogVideoStandard(this.mNativePtr));
        }
        return new FuncMaxMinDef(this.mAnalogVideoStandardMin, this.mAnalogVideoStandardMax, this.mAnalogVideoStandardDef, this.nativeGetAnalogVideoStandard(this.mNativePtr));
    }

    @Override
    public synchronized boolean setAnalogVideoLockState(boolean locked) {
        if (this.mNativePtr != 0L) {
            int err = this.nativeSetAnalogVideoLockState(this.mNativePtr, locked);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAnalogVideoLockState();
    }

    @Override
    public synchronized boolean getAnalogVideoLockState() {
        if (this.mNativePtr != 0L) {
            return this.nativeGetAnalogVideoLockState(this.mNativePtr) > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean getAnalogVideoLockStateDef() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAnalogVideoLockState(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            return this.mAnalogVideoLockStateDef > 0;
        }
        throw new IllegalStateException("camera is not ready");
    }

    @Override
    public synchronized boolean resetAnalogVideoLockState() {
        if (this.mNativePtr != 0L) {
            int err = this.nativeUpdateAnalogVideoLockState(this.mNativePtr);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
            err = this.nativeSetAnalogVideoLockState(this.mNativePtr, this.mAnalogVideoLockStateDef > 0);
            if (err != 0) {
                throw new IllegalArgumentException("err=" + err);
            }
        } else {
            throw new IllegalStateException("camera is not ready");
        }
        return this.getAnalogVideoLockState();
    }

    @Override
    public synchronized FuncMaxMinDef getAnalogVideoLockStateInfo() {
        this.checkNativeReady();
        int err = this.nativeUpdateAnalogVideoLockState(this.mNativePtr);
        if (err != 0) {
            Log.d((String)TAG, (String)("getAnalogVideoLockStateInfo:err=" + err));
            return new FuncMaxMinDef(0, 1, 0, this.nativeGetAnalogVideoLockState(this.mNativePtr));
        }
        return new FuncMaxMinDef(this.mAnalogVideoStandardMin, this.mAnalogVideoStandardMax, this.mAnalogVideoStandardDef, this.nativeGetAnalogVideoLockState(this.mNativePtr));
    }

    protected void checkNativeReady() throws IllegalStateException {
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("camera is not ready");
        }
    }

    protected boolean isValid() {
        try {
            return this.mNativePtr != 0L && this.mCtrlBlock != null && this.mCtrlBlock.getFileDescriptor() >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final String getUSBFSName(USBMonitor.UsbControlBlock ctrlBlock) {
        String[] v;
        String result = null;
        String name = ctrlBlock.getDeviceName();
        String[] stringArray = v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
        if (v != null && v.length > 2) {
            StringBuilder sb = new StringBuilder(v[0]);
            for (int i = 1; i < v.length - 2; ++i) {
                sb.append("/").append(v[i]);
            }
            result = sb.toString();
        }
        if (TextUtils.isEmpty(result)) {
            Log.w((String)TAG, (String)("failed to get USBFS path, try to use default path:" + name));
            result = DEFAULT_USBFS;
        }
        return result;
    }

    protected static final void dumpControls(long controlSupports) {
        Log.i((String)TAG, (String)String.format("controlSupports=%x", controlSupports));
        for (int i = 0; i < SUPPORTS_CTRL.length; ++i) {
            Log.i((String)TAG, (String)(SUPPORTS_CTRL[i] + ((controlSupports & (long)(1 << i)) != 0L ? "=enabled" : "=disabled")));
        }
    }

    protected static final void dumpProc(long procSupports) {
        Log.i((String)TAG, (String)String.format("procSupports=%x", procSupports));
        for (int i = 0; i < SUPPORTS_PROC.length; ++i) {
            Log.i((String)TAG, (String)(SUPPORTS_PROC[i] + ((procSupports & (long)(1 << i)) != 0L ? "=enabled" : "=disabled")));
        }
    }

    private final native long nativeCreate(AssetManager var1, boolean var2);

    private final native void nativeDestroy(long var1);

    private final native int nativeConnect(long var1, int var3);

    private final native int nativeConnectEx(long var1, int var3, int var4, int var5, int var6);

    private final native int nativeConnectEx2(long var1, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private final native int nativeDisconnect(long var1);

    private final native int nativeStartStream(long var1);

    private final native int nativeStopStream(long var1);

    private static final native int nativeGetState(long var0);

    private static final native int nativeSetPipeline(long var0, IPipeline var2);

    private static final native int nativeSetStatusCallback(long var0, IStatusCallback var2);

    private static final native int nativeSetButtonCallback(long var0, IButtonCallback var2);

    private static final native int nativeOutputDescriptor(long var0, int var2, int var3, int var4, String var5);

    private static final native String nativeGetSupportedSize(long var0);

    private static final native String nativeGetCurrentStream(long var0);

    private static final native int nativeSetVideoSize(long var0, int var2, int var3, int var4, float var5, float var6, float var7);

    private static final native int nativeSetRotation(long var0, float var2);

    private final native int nativeControlTransfer(long var1, int var3, int var4, int var5, int var6, byte[] var7, int var8, int var9, int var10);

    private final native long nativeGetCtrlSupports(long var1);

    private final native long nativeGetProcSupports(long var1);

    protected final native int nativeUpdateExposureMode(long var1);

    protected final native int nativeSetExposureMode(long var1, int var3);

    protected final native int nativeGetExposureMode(long var1);

    protected final native int nativeUpdateAutoFocus(long var1);

    protected final native int nativeSetAutoFocus(long var1, boolean var3);

    protected final native int nativeGetAutoFocus(long var1);

    protected final native int nativeUpdateFocus(long var1);

    protected final native int nativeSetFocus(long var1, int var3);

    protected final native int nativeGetFocus(long var1);

    protected final native int nativeUpdateAutoWhiteBlance(long var1);

    protected final native int nativeSetAutoWhiteBlance(long var1, boolean var3);

    protected final native int nativeGetAutoWhiteBlance(long var1);

    protected final native int nativeUpdateWhiteBlance(long var1);

    protected final native int nativeSetWhiteBlance(long var1, int var3);

    protected final native int nativeGetWhiteBlance(long var1);

    protected final native int nativeUpdateBrightness(long var1);

    protected final native int nativeSetBrightness(long var1, int var3);

    protected final native int nativeGetBrightness(long var1);

    protected final native int nativeUpdateContrast(long var1);

    protected final native int nativeSetContrast(long var1, int var3);

    protected final native int nativeGetContrast(long var1);

    protected final native int nativeUpdateSharpness(long var1);

    protected final native int nativeSetSharpness(long var1, int var3);

    protected final native int nativeGetSharpness(long var1);

    protected final native int nativeUpdateGain(long var1);

    protected final native int nativeSetGain(long var1, int var3);

    protected final native int nativeGetGain(long var1);

    protected final native int nativeUpdateGamma(long var1);

    protected final native int nativeSetGamma(long var1, int var3);

    protected final native int nativeGetGamma(long var1);

    protected final native int nativeUpdateSaturation(long var1);

    protected final native int nativeSetSaturation(long var1, int var3);

    protected final native int nativeGetSaturation(long var1);

    protected final native int nativeUpdateHue(long var1);

    protected final native int nativeSetHue(long var1, int var3);

    protected final native int nativeGetHue(long var1);

    protected final native int nativeUpdatePowerlineFrequency(long var1);

    protected final native int nativeSetPowerlineFrequency(long var1, int var3);

    protected final native int nativeGetPowerlineFrequency(long var1);

    protected final native int nativeUpdateZoom(long var1);

    protected final native int nativeSetZoom(long var1, int var3);

    protected final native int nativeGetZoom(long var1);

    protected final native int nativeUpdateScanningMode(long var1);

    protected final native int nativeSetScanningMode(long var1, boolean var3);

    protected final native int nativeGetScanningMode(long var1);

    protected final native int nativeUpdateExposurePriority(long var1);

    protected final native int nativeSetExposurePriority(long var1, int var3);

    protected final native int nativeGetExposurePriority(long var1);

    protected final native int nativeUpdateExposure(long var1);

    protected final native int nativeSetExposure(long var1, int var3);

    protected final native int nativeGetExposure(long var1);

    protected final native int nativeUpdateExposureRel(long var1);

    protected final native int nativeSetExposureRel(long var1, int var3);

    protected final native int nativeGetExposureRel(long var1);

    protected final native int nativeUpdateFocusRel(long var1);

    protected final native int nativeSetFocusRel(long var1, int var3);

    protected final native int nativeGetFocusRel(long var1);

    protected final native int nativeUpdateIris(long var1);

    protected final native int nativeSetIris(long var1, int var3);

    protected final native int nativeGetIris(long var1);

    protected final native int nativeUpdateIrisRel(long var1);

    protected final native int nativeSetIrisRel(long var1, int var3);

    protected final native int nativeGetIrisRel(long var1);

    protected final native int nativeUpdatePanTilt(long var1);

    protected final native int nativeSetPanTilt(long var1, int var3, int var4);

    protected final native long nativeGetPanTilt(long var1);

    protected final native int nativeUpdatePan(long var1);

    protected final native int nativeSetPan(long var1, int var3);

    protected final native int nativeGetPan(long var1);

    protected final native int nativeUpdatePanRel(long var1);

    protected final native int nativeSetPanRel(long var1, int var3, int var4);

    protected final native int nativeGetPanRel(long var1);

    protected final native int nativeUpdateTilt(long var1);

    protected final native int nativeSetTilt(long var1, int var3);

    protected final native int nativeGetTilt(long var1);

    protected final native int nativeUpdateTiltRel(long var1);

    protected final native int nativeSetTiltRel(long var1, int var3, int var4);

    protected final native int nativeGetTiltRel(long var1);

    protected final native int nativeUpdateRoll(long var1);

    protected final native int nativeSetRoll(long var1, int var3);

    protected final native int nativeGetRoll(long var1);

    protected final native int nativeUpdateRollRel(long var1);

    protected final native int nativeSetRollRel(long var1, int var3, int var4);

    protected final native int nativeGetRollRel(long var1);

    protected final native int nativeUpdateAutoWhiteBlanceCompo(long var1);

    protected final native int nativeSetAutoWhiteBlanceCompo(long var1, boolean var3);

    protected final native int nativeGetAutoWhiteBlanceCompo(long var1);

    protected final native int nativeUpdateWhiteBlanceCompo(long var1);

    protected final native int nativeSetWhiteBlanceCompo(long var1, int var3);

    protected final native int nativeGetWhiteBlanceCompo(long var1);

    protected final native int nativeUpdateBacklightComp(long var1);

    protected final native int nativeSetBacklightComp(long var1, int var3);

    protected final native int nativeGetBacklightComp(long var1);

    protected final native int nativeUpdateAutoContrast(long var1);

    protected final native int nativeSetAutoContrast(long var1, boolean var3);

    protected final native int nativeGetAutoContrast(long var1);

    protected final native int nativeUpdateAutoHue(long var1);

    protected final native int nativeSetAutoHue(long var1, boolean var3);

    protected final native int nativeGetAutoHue(long var1);

    protected final native int nativeUpdateZoomRel(long var1);

    protected final native int nativeSetZoomRel(long var1, int var3);

    protected final native int nativeGetZoomRel(long var1);

    protected final native int nativeUpdateDigitalMultiplier(long var1);

    protected final native int nativeSetDigitalMultiplier(long var1, int var3);

    protected final native int nativeGetDigitalMultiplier(long var1);

    protected final native int nativeUpdateDigitalMultiplierLimit(long var1);

    protected final native int nativeSetDigitalMultiplierLimit(long var1, int var3);

    protected final native int nativeGetDigitalMultiplierLimit(long var1);

    protected final native int nativeUpdateAnalogVideoStandard(long var1);

    protected final native int nativeSetAnalogVideoStandard(long var1, int var3);

    protected final native int nativeGetAnalogVideoStandard(long var1);

    protected final native int nativeUpdateAnalogVideoLockState(long var1);

    protected final native int nativeSetAnalogVideoLockState(long var1, boolean var3);

    protected final native int nativeGetAnalogVideoLockState(long var1);

    protected final native int nativeUpdatePrivacy(long var1);

    protected final native int nativeSetPrivacy(long var1, boolean var3);

    protected final native int nativeGetPrivacy(long var1);

    static {
        NativeLibLoader.loadNative();
        USE_STATUS_CALLBACK = false;
        SUPPORTS_CTRL = new String[]{"D0:  Scanning Mode", "D1:  Auto-Exposure Mode", "D2:  Auto-Exposure Priority", "D3:  Exposure Time (Absolute)", "D4:  Exposure Time (Relative)", "D5:  Focus (Absolute)", "D6:  Focus (Relative)", "D7:  Iris (Absolute)", "D8:  Iris (Relative)", "D9:  Zoom (Absolute)", "D10: Zoom (Relative)", "D11: PanTilt (Absolute)", "D12: PanTilt (Relative)", "D13: Roll (Absolute)", "D14: Roll (Relative)", "D15: Reserved", "D16: Reserved", "D17: Focus, Auto", "D18: Privacy", "D19: Focus, Simple", "D20: Window", "D21: Region of Interest", "D22: Reserved, set to zero", "D23: Reserved, set to zero"};
        SUPPORTS_PROC = new String[]{"D0: Brightness", "D1: Contrast", "D2: Hue", "D3: Saturation", "D4: Sharpness", "D5: Gamma", "D6: White Balance Temperature", "D7: White Balance Component", "D8: Backlight Compensation", "D9: Gain", "D10: Power Line Frequency", "D11: Hue, Auto", "D12: White Balance Temperature, Auto", "D13: White Balance Component, Auto", "D14: Digital Multiplier", "D15: Digital Multiplier Limit", "D16: Analog Video Standard", "D17: Analog Video Lock Status", "D18: Contrast, Auto", "D19: Reserved. Set to zero", "D20: Reserved. Set to zero", "D21: Reserved. Set to zero", "D22: Reserved. Set to zero", "D23: Reserved. Set to zero"};
    }
}

