/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.serenegiant.usb.uvc.IPipeline;
import com.serenegiant.usb.uvc.NativeCallback;

@Keep
public class NativeCallbackPipeline
extends IPipeline {
    private static final String TAG = NativeCallbackPipeline.class.getSimpleName();
    private boolean mIsAssigned;

    public NativeCallbackPipeline() {
        super(310);
        this.mNativePtr = this.nativeCreate();
        this.mIsAssigned = false;
    }

    @Override
    public int getState() {
        return this.nativeGetState(this.mNativePtr);
    }

    @Override
    public void setPipeline(@Nullable IPipeline next_pipeline) {
        if (this.getState() < 20) {
            throw new IllegalStateException("already released");
        }
        this.nativeSetPipeline(this.mNativePtr, next_pipeline);
    }

    @Override
    public void start() {
        int result = NativeCallbackPipeline.nativeStart(this.mNativePtr);
        if (result != 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void stop() {
        int result = NativeCallbackPipeline.nativeStop(this.mNativePtr);
        if (result != 0) {
            Log.w((String)TAG, (String)("nativeStop returned " + result));
        }
    }

    @Override
    public void release() {
        if (!this.mIsAssigned) {
            this.nativeDestroy(this.mNativePtr);
        }
        this.mNativePtr = 0L;
        this.mIsAssigned = false;
    }

    public void setCallback(@Nullable NativeCallback callback) {
        NativeCallbackPipeline.nativeSetCallback(this.mNativePtr, callback);
    }

    protected void assignNative(long id_pipeline) {
        this.release();
        this.mNativePtr = id_pipeline;
        this.mIsAssigned = id_pipeline != 0L;
    }

    private final native long nativeCreate();

    private final native void nativeDestroy(long var1);

    private final native int nativeGetState(long var1);

    private final native int nativeSetPipeline(long var1, IPipeline var3);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);

    private static final native int nativeSetCallback(long var0, @Nullable NativeCallback var2);
}

