/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.opengl.Matrix;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.usb.uvc.IPipeline;

@Keep
public class GLRendererPipeline
extends IPipeline
implements IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = GLRendererPipeline.class.getSimpleName();
    @NonNull
    private final float[] mMvpMatrix = new float[16];
    private int mMirror = 0;

    public GLRendererPipeline(@IntRange(from=2L, to=3L) int glVersion, boolean keepLastFrame) {
        this(glVersion, keepLastFrame, false);
    }

    public GLRendererPipeline(@IntRange(from=2L, to=3L) int glVersion, boolean keepLastFrame, boolean enable_hw_buffer) {
        super(510);
        this.mNativePtr = this.nativeCreate(glVersion, keepLastFrame, enable_hw_buffer);
        Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
    }

    @Override
    public int getState() {
        return this.nativeGetState(this.mNativePtr);
    }

    @Override
    public void setPipeline(@Nullable IPipeline nextPipeline) {
        if (this.getState() < 20) {
            throw new IllegalStateException("already released");
        }
        this.nativeSetPipeline(this.mNativePtr, nextPipeline);
    }

    @Override
    public void start() {
        int result = GLRendererPipeline.nativeStart(this.mNativePtr);
        if (result != 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void stop() {
        int result = GLRendererPipeline.nativeStop(this.mNativePtr);
        if (result != 0) {
            Log.w((String)TAG, (String)("nativeStop returned " + result));
        }
    }

    @Override
    public void release() {
        this.nativeDestroy(this.mNativePtr);
        this.mNativePtr = 0L;
        this.nativeDestroy(this.mNativePtr);
    }

    public void onDraw() {
        GLRendererPipeline.nativeOnDraw(this.mNativePtr);
    }

    public void setMirror(int mirror) {
        if (this.mMirror != mirror) {
            Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
            GLUtils.setMirror((float[])this.mMvpMatrix, (int)mirror);
            GLRendererPipeline.nativeSetMvpMatrix(this.mNativePtr, this.mMvpMatrix, 0);
            this.mMirror = mirror;
        }
    }

    public int getMirror() {
        return this.mMirror;
    }

    private final native long nativeCreate(int var1, boolean var2, boolean var3);

    private final native void nativeDestroy(long var1);

    private final native int nativeGetState(long var1);

    private final native int nativeSetPipeline(long var1, IPipeline var3);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);

    private static final native int nativeOnDraw(long var0);

    private static final native int nativeSetMvpMatrix(long var0, @Nullable float[] var2, int var3);
}

