/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import android.util.SparseArray;
import androidx.annotation.NonNull;

public enum RawFrameType {
    RAW_FRAME_UNKNOWN(0, "UNKNOWN"),
    RAW_FRAME_UNCOMPRESSED(5, "RAW_FRAME_UNCOMPRESSED"),
    RAW_FRAME_UNCOMPRESSED_YUYV(65541, "YUYV"),
    RAW_FRAME_UNCOMPRESSED_UYVY(131077, "UYVY"),
    RAW_FRAME_UNCOMPRESSED_GRAY8(196613, "GRAY8"),
    RAW_FRAME_UNCOMPRESSED_BY8(262149, "BY8"),
    RAW_FRAME_UNCOMPRESSED_NV21(327685, "NV21"),
    RAW_FRAME_UNCOMPRESSED_YV12(393221, "YV12"),
    RAW_FRAME_UNCOMPRESSED_I420(458757, "I420"),
    RAW_FRAME_UNCOMPRESSED_Y16(524293, "Y16"),
    RAW_FRAME_UNCOMPRESSED_RGBP(589829, "RGBP"),
    RAW_FRAME_UNCOMPRESSED_M420(655365, "M420"),
    RAW_FRAME_UNCOMPRESSED_NV12(720901, "NV12"),
    RAW_FRAME_UNCOMPRESSED_YCbCr(786437, "YCbCr"),
    RAW_FRAME_UNCOMPRESSED_RGB565(851973, "RGB565"),
    RAW_FRAME_UNCOMPRESSED_RGB(917509, "RGB"),
    RAW_FRAME_UNCOMPRESSED_BGR(983045, "BGR"),
    RAW_FRAME_UNCOMPRESSED_RGBX(0x100005, "RGBX"),
    RAW_FRAME_UNCOMPRESSED_444p(0x110005, "444p"),
    RAW_FRAME_UNCOMPRESSED_444sp(1179653, "444sp"),
    RAW_FRAME_UNCOMPRESSED_422p(1245189, "422p"),
    RAW_FRAME_UNCOMPRESSED_422sp(1310725, "422sp"),
    RAW_FRAME_UNCOMPRESSED_440p(0x150005, "440p"),
    RAW_FRAME_UNCOMPRESSED_440sp(1441797, "440sp"),
    RAW_FRAME_UNCOMPRESSED_411p(1507333, "411p"),
    RAW_FRAME_UNCOMPRESSED_411sp(1572869, "411sp"),
    RAW_FRAME_UNCOMPRESSED_YUV_ANY(1638405, "YUV_ANY"),
    RAW_FRAME_UNCOMPRESSED_XRGB(1703941, "XRGB"),
    RAW_FRAME_UNCOMPRESSED_XBGR(1769477, "XBGR"),
    RAW_FRAME_UNCOMPRESSED_BGRX(1835013, "BGRX"),
    RAW_FRAME_MJPEG(7, "MJPEG"),
    RAW_FRAME_FRAME_BASED(17, "FRAME_BASED"),
    RAW_FRAME_MPEG2TS(65553, "MPEG2TS"),
    RAW_FRAME_DV(131089, "DV"),
    RAW_FRAME_FRAME_H264(196625, "H264Frame"),
    RAW_FRAME_FRAME_VP8(262161, "VP8Frame"),
    RAW_FRAME_H264(20, "H264"),
    RAW_FRAME_H264_SIMULCAST(65556, "H264SIMULCAST"),
    RAW_FRAME_VP8(23, "VP8"),
    RAW_FRAME_VP8_SIMULCAST(65559, "VP8SIMULCAST"),
    RAW_FRAME_STILL(3, "STILL"),
    RAW_FRAME_INTERNAL_CAMERA(255, "INTERNAL");

    private final int value;
    @NonNull
    private final String label;
    private static final SparseArray<RawFrameType> mMap;

    private RawFrameType(int value, String label) {
        this.value = value;
        this.label = label;
    }

    public int getValue() {
        return this.value;
    }

    @NonNull
    public String getLabel() {
        return this.label;
    }

    public static RawFrameType from(int value) {
        return (RawFrameType)((Object)mMap.get(value, (Object)RAW_FRAME_UNKNOWN));
    }

    static {
        mMap = new SparseArray();
        mMap.put(RAW_FRAME_UNKNOWN.getValue(), (Object)RAW_FRAME_UNKNOWN);
        mMap.put(RAW_FRAME_UNCOMPRESSED.getValue(), (Object)RAW_FRAME_UNCOMPRESSED);
        mMap.put(RAW_FRAME_UNCOMPRESSED_YUYV.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_YUYV);
        mMap.put(RAW_FRAME_UNCOMPRESSED_UYVY.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_UYVY);
        mMap.put(RAW_FRAME_UNCOMPRESSED_GRAY8.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_GRAY8);
        mMap.put(RAW_FRAME_UNCOMPRESSED_BY8.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_BY8);
        mMap.put(RAW_FRAME_UNCOMPRESSED_NV21.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_NV21);
        mMap.put(RAW_FRAME_UNCOMPRESSED_YV12.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_YV12);
        mMap.put(RAW_FRAME_UNCOMPRESSED_I420.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_I420);
        mMap.put(RAW_FRAME_UNCOMPRESSED_Y16.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_Y16);
        mMap.put(RAW_FRAME_UNCOMPRESSED_RGBP.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_RGBP);
        mMap.put(RAW_FRAME_UNCOMPRESSED_NV12.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_NV12);
        mMap.put(RAW_FRAME_UNCOMPRESSED_YCbCr.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_YCbCr);
        mMap.put(RAW_FRAME_UNCOMPRESSED_RGB565.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_RGB565);
        mMap.put(RAW_FRAME_UNCOMPRESSED_RGB.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_RGB);
        mMap.put(RAW_FRAME_UNCOMPRESSED_BGR.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_BGR);
        mMap.put(RAW_FRAME_UNCOMPRESSED_RGBX.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_RGBX);
        mMap.put(RAW_FRAME_UNCOMPRESSED_444p.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_444p);
        mMap.put(RAW_FRAME_UNCOMPRESSED_444sp.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_444sp);
        mMap.put(RAW_FRAME_UNCOMPRESSED_422p.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_422p);
        mMap.put(RAW_FRAME_UNCOMPRESSED_422sp.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_422sp);
        mMap.put(RAW_FRAME_UNCOMPRESSED_440p.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_440p);
        mMap.put(RAW_FRAME_UNCOMPRESSED_440sp.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_440sp);
        mMap.put(RAW_FRAME_UNCOMPRESSED_411p.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_411p);
        mMap.put(RAW_FRAME_UNCOMPRESSED_411sp.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_411sp);
        mMap.put(RAW_FRAME_UNCOMPRESSED_YUV_ANY.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_YUV_ANY);
        mMap.put(RAW_FRAME_UNCOMPRESSED_XRGB.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_XRGB);
        mMap.put(RAW_FRAME_UNCOMPRESSED_XBGR.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_XBGR);
        mMap.put(RAW_FRAME_UNCOMPRESSED_BGRX.getValue(), (Object)RAW_FRAME_UNCOMPRESSED_BGRX);
        mMap.put(RAW_FRAME_MJPEG.getValue(), (Object)RAW_FRAME_MJPEG);
        mMap.put(RAW_FRAME_FRAME_BASED.getValue(), (Object)RAW_FRAME_FRAME_BASED);
        mMap.put(RAW_FRAME_MPEG2TS.getValue(), (Object)RAW_FRAME_MPEG2TS);
        mMap.put(RAW_FRAME_DV.getValue(), (Object)RAW_FRAME_DV);
        mMap.put(RAW_FRAME_FRAME_H264.getValue(), (Object)RAW_FRAME_FRAME_H264);
        mMap.put(RAW_FRAME_FRAME_VP8.getValue(), (Object)RAW_FRAME_FRAME_VP8);
        mMap.put(RAW_FRAME_H264.getValue(), (Object)RAW_FRAME_H264);
        mMap.put(RAW_FRAME_H264_SIMULCAST.getValue(), (Object)RAW_FRAME_H264_SIMULCAST);
        mMap.put(RAW_FRAME_VP8.getValue(), (Object)RAW_FRAME_VP8);
        mMap.put(RAW_FRAME_VP8_SIMULCAST.getValue(), (Object)RAW_FRAME_VP8_SIMULCAST);
        mMap.put(RAW_FRAME_STILL.getValue(), (Object)RAW_FRAME_STILL);
        mMap.put(RAW_FRAME_INTERNAL_CAMERA.getValue(), (Object)RAW_FRAME_INTERNAL_CAMERA);
    }
}

