/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.serenegiant.camera.AbstractBuiltInCamera2;
import java.util.Arrays;
import java.util.List;

@RequiresApi(value=21)
public class BuiltInCamera2i
extends AbstractBuiltInCamera2 {
    private static final boolean DEBUG = false;
    private static final String TAG = BuiltInCamera2i.class.getSimpleName();
    private ImageReader mImageReader;
    private Surface mPreviewSurface;
    private long mStartTimeNs;
    private int mCount;
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            if (BuiltInCamera2i.this.mCount == 0) {
                BuiltInCamera2i.this.mStartTimeNs = System.nanoTime();
            }
            if (BuiltInCamera2i.this.mCount++ % 100 == 0) {
                Log.i((String)TAG, (String)String.format("onImageAvailable:%6d,%5.2f", BuiltInCamera2i.this.mCount, Float.valueOf((float)BuiltInCamera2i.this.mCount / ((float)(System.nanoTime() - BuiltInCamera2i.this.mStartTimeNs) / 1.0E9f))));
            }
            try {
                Image image;
                if (BuiltInCamera2i.this.mImageReader != null && (image = BuiltInCamera2i.this.mImageReader.acquireLatestImage()) != null) {
                    image.close();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    };
    private final Runnable mImageAvailableTask = new Runnable(){

        @Override
        public void run() {
            BuiltInCamera2i.this.mCameraHandler.removeCallbacks(BuiltInCamera2i.this.mImageAvailableTask);
            try {
                Image image;
                if (BuiltInCamera2i.this.mImageReader != null && (image = BuiltInCamera2i.this.mImageReader.acquireLatestImage()) != null) {
                    image.close();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    };

    protected BuiltInCamera2i(@NonNull Context context, int face) throws Exception {
        super(context, face, 3, false);
    }

    protected BuiltInCamera2i(@NonNull Context context, int face, int templateType) throws Exception {
        super(context, face, templateType, false);
    }

    protected BuiltInCamera2i(@NonNull Context context, @NonNull Handler cameraHandler, int face, int templateType, boolean needCaptureCallback, int burstNum, int afMode) throws Exception {
        super(context, cameraHandler, face, templateType, needCaptureCallback, burstNum, afMode);
    }

    @Override
    protected void internalCreateImageReader(CameraManager manager) {
        super.internalCreateImageReader(manager);
    }

    @Override
    @TargetApi(value=23)
    protected void internalCloseImageReader() {
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
        super.internalCloseImageReader();
    }

    @Override
    @NonNull
    protected CaptureRequest.Builder createCaptureRequestBuilder(CameraDevice camera, int templateType, Surface previewSurface) throws CameraAccessException {
        this.mPreviewSurface = previewSurface;
        this.mImageReader = ImageReader.newInstance((int)this.mInfo.width, (int)this.mInfo.height, (int)35, (int)2);
        this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, this.mCameraHandler);
        CaptureRequest.Builder builder = camera.createCaptureRequest(this.mTemplateType);
        builder.addTarget(this.mImageReader.getSurface());
        builder.addTarget(previewSurface);
        return builder;
    }

    @Override
    protected List<Surface> createCaptureSurfaceList(Surface previewSurface) {
        return Arrays.asList(this.mImageReader.getSurface(), this.mPreviewSurface);
    }
}

