/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.camera.IFrameCallback;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.usb.uvc.FrameCallbackPipeline;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class FrameSavePipeline
extends FrameCallbackPipeline {
    private static final String TAG = FrameSavePipeline.class.getSimpleName();
    private static final int BUF_SZ = 4096;
    private final RawFrameType mRawFrameType;
    private final int mRawFrameTypeValue;
    private final byte[] mBuffer = new byte[4096];
    private OutputStream output;
    private final IFrameCallback mFrameCallback = new IFrameCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrame(@NonNull ByteBuffer frame, int width, int height, long presentationTimeUs, int raw_frame_t, int flags) {
            if (FrameSavePipeline.this.mRawFrameTypeValue == raw_frame_t) {
                Object object = FrameSavePipeline.this.mSync;
                synchronized (object) {
                    FrameSavePipeline.this.onFrame(frame, width, height, presentationTimeUs, raw_frame_t, flags);
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameSavePipeline(@NonNull String outputPath, RawFrameType rawFrameType, int sanitaryCheck) throws IOException {
        super(sanitaryCheck);
        File path = new File(outputPath);
        path.getParentFile().mkdirs();
        Object object = this.mSync;
        synchronized (object) {
            this.output = new BufferedOutputStream(new FileOutputStream(path));
            this.mRawFrameType = rawFrameType;
            this.mRawFrameTypeValue = rawFrameType.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameSavePipeline(@NonNull String outputPath, RawFrameType rawFrameType) throws IOException {
        File path = new File(outputPath);
        path.getParentFile().mkdirs();
        Object object = this.mSync;
        synchronized (object) {
            this.output = new BufferedOutputStream(new FileOutputStream(path));
            this.mRawFrameType = rawFrameType;
            this.mRawFrameTypeValue = rawFrameType.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameSavePipeline(@NonNull Context context, @NonNull DocumentFile outputDoc, RawFrameType rawFrameType) throws IOException {
        Object object = this.mSync;
        synchronized (object) {
            this.output = new BufferedOutputStream(context.getContentResolver().openOutputStream(outputDoc.getUri(), "rw"));
            this.mRawFrameType = rawFrameType;
            this.mRawFrameTypeValue = rawFrameType.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameSavePipeline(@NonNull Context context, @NonNull DocumentFile outputDoc, RawFrameType rawFrameType, int sanitaryCheck) throws IOException {
        super(sanitaryCheck);
        Object object = this.mSync;
        synchronized (object) {
            this.output = new BufferedOutputStream(context.getContentResolver().openOutputStream(outputDoc.getUri(), "rw"));
            this.mRawFrameType = rawFrameType;
            this.mRawFrameTypeValue = rawFrameType.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        Object object = this.mSync;
        synchronized (object) {
            super.setFrameCallback(this.mFrameCallback, this.mRawFrameType);
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        super.stop();
        Object object = this.mSync;
        synchronized (object) {
            super.setFrameCallback(null, this.mRawFrameType);
            if (this.output != null) {
                try {
                    this.output.flush();
                    this.output.close();
                }
                catch (IOException e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.output = null;
            }
        }
    }

    @Override
    public void setFrameCallback(@Nullable IFrameCallback callback, RawFrameType rawFrameType) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("FrameSavePipeline#setFrameCallback can not call");
    }

    protected void internalSetFrameCallback(@Nullable IFrameCallback callback, RawFrameType raw_frame_type) {
        super.setFrameCallback(callback, raw_frame_type);
    }

    protected void onFrame(@NonNull ByteBuffer frame, int width, int height, long presentationTimeUs, int rawFrameType, int flags) {
        if (this.output != null) {
            frame.clear();
            int sz = frame.capacity();
            for (int i = 0; i < sz; i += 4096) {
                int n = i + 4096 < sz ? 4096 : sz - i;
                frame.get(this.mBuffer, 0, n);
                try {
                    this.output.write(this.mBuffer, 0, n);
                    continue;
                }
                catch (IOException e) {
                    break;
                }
            }
        }
    }
}

