/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uac;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import com.serenegiant.media.IAudioSampler;
import com.serenegiant.media.RecycleMediaData;
import com.serenegiant.usb.NativeLibLoader;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UsbDeviceInfo;
import com.serenegiant.usb.UsbUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;

@Keep
public class UACClient
extends IAudioSampler {
    private static final boolean DEBUG = false;
    private static final String TAG = UACClient.class.getSimpleName();
    protected USBMonitor.UsbControlBlock mCtrlBlock;
    protected long mNativePtr;
    protected final Context mContext;
    protected int mNativeValue;
    protected int mChannels = 2;
    protected int mBitResolution = 16;
    protected int minSamplingFreq = 32000;
    protected int maxSamplingFreq = 32000;
    protected int mSamplingFrequency = 32000;

    public UACClient(Context context) {
        this.mContext = context;
        this.mNativePtr = this.nativeCreate();
        if (this.mNativePtr == 0L) {
            throw new UnsupportedOperationException();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void release() {
        this.close();
        if (this.mNativePtr != 0L) {
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
        super.release();
    }

    public synchronized void open(USBMonitor.UsbControlBlock ctrlBlock) {
        int result;
        try {
            this.mCtrlBlock = ctrlBlock.clone();
            result = this.nativeConnect(this.mNativePtr, this.mCtrlBlock.getFileDescriptor());
        }
        catch (Exception e) {
            result = -1;
        }
        if (result != 0) {
            throw new UnsupportedOperationException("open failed:result=" + result);
        }
    }

    public synchronized void close() {
        if (this.mNativePtr != 0L) {
            this.nativeDisconnect(this.mNativePtr);
        }
        if (this.mCtrlBlock != null) {
            this.mCtrlBlock.close();
            this.mCtrlBlock = null;
        }
    }

    public synchronized void start() {
        if (this.mNativePtr != 0L) {
            super.start();
            this.init_pool(2048);
            int result = UACClient.nativeStart(this.mNativePtr);
            if (result != 0 && result != -6) {
                super.stop();
                throw new RuntimeException("start: Failed result=" + result);
            }
        }
    }

    public synchronized void stop() {
        if (this.mNativePtr != 0L) {
            UACClient.nativeStop(this.mNativePtr);
        }
        super.stop();
    }

    public boolean isStarted() {
        return super.isStarted() && UACClient.nativeIsStarted(this.mNativePtr) != 0;
    }

    public int getAudioSource() {
        return 100;
    }

    public int getChannels() {
        return this.mChannels;
    }

    public int getSamplingFrequency() {
        return this.mSamplingFrequency;
    }

    public int getBitResolution() {
        return this.mBitResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getDescriptor() {
        String result = null;
        if (this.mNativePtr != 0L && this.mCtrlBlock != null) {
            File dir = this.mContext.getExternalFilesDir("Descriptors");
            dir.mkdirs();
            if (dir.canWrite()) {
                File filepath = new File(dir, String.format("uac-%04x_%04x_%08x.txt", this.mCtrlBlock.getVenderId(), this.mCtrlBlock.getProductId(), UsbUtils.getDeviceKey((UsbDeviceInfo)this.mCtrlBlock.getInfo())));
                if (!filepath.exists()) {
                    UACClient.nativeOutputDescriptor(this.mNativePtr, this.mCtrlBlock.getVenderId(), this.mCtrlBlock.getProductId(), this.mCtrlBlock.getFileDescriptor(), filepath.getAbsolutePath());
                }
                if (filepath.exists()) {
                    try (BufferedReader in = new BufferedReader(new FileReader(filepath));){
                        StringBuilder sb = new StringBuilder(1024);
                        char[] buffer = new char[512];
                        int n = 0;
                        while (n >= 0 && (n = in.read(buffer)) > 0) {
                            sb.append(buffer, 0, n);
                        }
                        result = sb.toString();
                    }
                    catch (FileNotFoundException e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                    catch (IOException e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    protected void onData(ByteBuffer buffer, int size, long presentationTimeUs) {
        this.mDefaultBufferSize = size;
        try {
            RecycleMediaData data = this.obtain();
            if (data != null) {
                data.set(buffer, size, presentationTimeUs);
                this.addMediaData(data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long nativeCreate();

    private final native void nativeDestroy(long var1);

    private final native int nativeConnect(long var1, int var3);

    private final native int nativeDisconnect(long var1);

    private static final native int nativeOutputDescriptor(long var0, int var2, int var3, int var4, String var5);

    private static final native String nativeGetCurrentStream(long var0);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);

    private static final native int nativeIsStarted(long var0);

    static {
        NativeLibLoader.loadNative();
    }
}

