/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.serenegiant.common.R;
import com.serenegiant.widget.Dividable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class ArrayListRecyclerViewAdapter<T>
extends RecyclerView.Adapter<ViewHolder<T>> {
    private static final boolean DEBUG = false;
    private static final String TAG = ArrayListRecyclerViewAdapter.class.getSimpleName();
    @LayoutRes
    private final int mItemViewId;
    @NonNull
    private final List<T> mItems;
    private LayoutInflater mLayoutInflater;
    private RecyclerView mRecycleView;
    private ArrayListRecyclerViewListener<T> mCustomRecycleViewListener;
    private int mSelectedPosition = -1;
    protected final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(final View v) {
            if (ArrayListRecyclerViewAdapter.this.mRecycleView != null) {
                if (v instanceof Checkable) {
                    ((Checkable)v).setChecked(true);
                    v.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ((Checkable)v).setChecked(false);
                        }
                    }, 100L);
                }
                if (ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener != null) {
                    Object pos = v.getTag(R.id.position);
                    if (pos instanceof Integer) {
                        try {
                            int position = (Integer)pos;
                            Object item = ArrayListRecyclerViewAdapter.this.getItem(position);
                            ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener.onItemClick(ArrayListRecyclerViewAdapter.this, v, position, item);
                            return;
                        }
                        catch (Exception e) {
                            Log.w((String)TAG, (Throwable)e);
                        }
                    }
                    try {
                        int position = ArrayListRecyclerViewAdapter.this.mRecycleView.getChildAdapterPosition(v);
                        Object item = ArrayListRecyclerViewAdapter.this.getItem(position);
                        ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener.onItemClick(ArrayListRecyclerViewAdapter.this, v, position, item);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
            }
        }
    };
    protected final View.OnLongClickListener mOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            if (ArrayListRecyclerViewAdapter.this.mRecycleView != null) {
                try {
                    if (ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener != null) {
                        Object pos = v.getTag(R.id.position);
                        if (pos instanceof Integer) {
                            int position = (Integer)pos;
                            Object item = ArrayListRecyclerViewAdapter.this.getItem(position);
                            return ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener.onItemLongClick(ArrayListRecyclerViewAdapter.this, v, position, item);
                        }
                        int position = ArrayListRecyclerViewAdapter.this.mRecycleView.getChildAdapterPosition(v);
                        Object item = ArrayListRecyclerViewAdapter.this.getItem(position);
                        return ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener.onItemLongClick(ArrayListRecyclerViewAdapter.this, v, position, item);
                    }
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
            return false;
        }
    };
    protected final View.OnFocusChangeListener mOnFocusChangeListener = new View.OnFocusChangeListener(){

        public void onFocusChange(View v, boolean hasFocus) {
            if (!hasFocus) {
                ArrayListRecyclerViewAdapter.this.mSelectedPosition = -1;
            } else if (hasFocus && ArrayListRecyclerViewAdapter.this.mRecycleView != null) {
                try {
                    Object pos = v.getTag(R.id.position);
                    if (pos instanceof Integer) {
                        int position = ArrayListRecyclerViewAdapter.this.mSelectedPosition = (Integer)pos;
                        if (ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener != null) {
                            Object item = ArrayListRecyclerViewAdapter.this.getItem(position);
                            ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener.onItemSelected(ArrayListRecyclerViewAdapter.this, v, position, item);
                        }
                        return;
                    }
                    int position = ArrayListRecyclerViewAdapter.this.mSelectedPosition = ArrayListRecyclerViewAdapter.this.mRecycleView.getChildAdapterPosition(v);
                    Object item = ArrayListRecyclerViewAdapter.this.getItem(position);
                    if (ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener != null) {
                        ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener.onItemSelected(ArrayListRecyclerViewAdapter.this, v, position, item);
                    }
                    return;
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
            if (ArrayListRecyclerViewAdapter.this.mSelectedPosition < 0 && ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener != null) {
                ArrayListRecyclerViewAdapter.this.mCustomRecycleViewListener.onNothingSelected(ArrayListRecyclerViewAdapter.this);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayListRecyclerViewAdapter(@LayoutRes int itemViewLayoutId, @NonNull List<T> items) {
        this.mItemViewId = itemViewLayoutId;
        List<T> list = this.mItems = items;
        synchronized (list) {
            this.registerDataSetObserver(this.mItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        List<T> list = this.mItems;
        synchronized (list) {
            this.unregisterDataSetObserver(this.mItems);
        }
        super.finalize();
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mSelectedPosition = -1;
        this.mRecycleView = recyclerView;
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mRecycleView = null;
        this.mSelectedPosition = -1;
        super.onDetachedFromRecyclerView(recyclerView);
    }

    @NonNull
    public ViewHolder<T> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = this.getLayoutInflater(parent.getContext());
        View view = this.onCreateItemView(inflater, parent, viewType);
        view.setOnClickListener(this.mOnClickListener);
        view.setOnLongClickListener(this.mOnLongClickListener);
        view.setOnFocusChangeListener(this.mOnFocusChangeListener);
        return this.onCreateViewHolder(view);
    }

    protected View onCreateItemView(LayoutInflater inflater, ViewGroup parent, int viewType) {
        return inflater.inflate(this.mItemViewId, parent, false);
    }

    protected ViewHolder<T> onCreateViewHolder(View item) {
        return new ViewHolder(item);
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public int getSelectedPosition() {
        return this.mSelectedPosition;
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.mItems);
    }

    public T getItem(int position) throws IndexOutOfBoundsException {
        if (position >= 0 && position < this.mItems.size()) {
            return this.mItems.get(position);
        }
        throw new IndexOutOfBoundsException();
    }

    public void setOnItemClickListener(ArrayListRecyclerViewListener<T> listener) {
        this.mCustomRecycleViewListener = listener;
    }

    @Nullable
    public RecyclerView getParent() {
        return this.mRecycleView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<T> list = this.mItems;
        synchronized (list) {
            this.unregisterDataSetObserver(this.mItems);
            this.mItems.clear();
        }
        this.notifyDataSetChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<? extends T> collection) {
        int m;
        int n;
        List<T> list = this.mItems;
        synchronized (list) {
            n = this.mItems.size() - 1;
            this.unregisterDataSetObserver(this.mItems);
            this.mItems.addAll(collection);
            m = this.mItems.size() - 1;
            this.registerDataSetObserver(this.mItems);
        }
        if (m > n) {
            this.notifyItemRangeChanged(n, m - n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAll(Collection<? extends T> collection) {
        List<T> list = this.mItems;
        synchronized (list) {
            this.unregisterDataSetObserver(this.mItems);
            this.mItems.clear();
            this.mItems.addAll(collection);
            this.registerDataSetObserver(this.mItems);
        }
        this.notifyDataSetChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Comparator<? super T> comparator) {
        List<T> list = this.mItems;
        synchronized (list) {
            Collections.sort(this.mItems, comparator);
        }
        this.notifyDataSetChanged();
    }

    protected LayoutInflater getLayoutInflater(Context context) {
        if (this.mLayoutInflater == null) {
            this.mLayoutInflater = LayoutInflater.from((Context)context);
        }
        return this.mLayoutInflater;
    }

    protected abstract void registerDataSetObserver(@NonNull List<T> var1);

    protected abstract void unregisterDataSetObserver(@NonNull List<T> var1);

    public static class ViewHolder<T>
    extends RecyclerView.ViewHolder {
        public final View mView;
        public int position;
        public T mItem;

        public ViewHolder(View view) {
            super(view);
            this.mView = view;
        }

        @NonNull
        public String toString() {
            return super.toString() + " '" + this.mItem + "'";
        }

        public void setEnable(boolean enable) {
            this.mView.setEnabled(enable);
        }

        public void hasDivider(boolean hasDivider) {
            if (this.mView instanceof Dividable) {
                ((Dividable)this.mView).hasDivider(hasDivider);
            } else {
                this.mView.setTag(R.id.has_divider, (Object)hasDivider);
            }
        }

        public boolean hasDivider() {
            if (this.mView instanceof Dividable) {
                return ((Dividable)this.mView).hasDivider();
            }
            Boolean b = (Boolean)this.mView.getTag(R.id.has_divider);
            return b != null && b != false;
        }
    }

    public static interface ArrayListRecyclerViewListener<T> {
        public void onItemClick(@NonNull RecyclerView.Adapter<?> var1, @NonNull View var2, int var3, @Nullable T var4);

        public boolean onItemLongClick(@NonNull RecyclerView.Adapter<?> var1, @NonNull View var2, int var3, @Nullable T var4);

        public void onItemSelected(@NonNull RecyclerView.Adapter<?> var1, @NonNull View var2, int var3, @Nullable T var4);

        public void onNothingSelected(@NonNull RecyclerView.Adapter<?> var1);
    }
}

