/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.Animation;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.serenegiant.common.R;
import com.serenegiant.system.ContextHolder;
import com.serenegiant.view.animation.ResizeAnimation;
import java.io.Serializable;

public abstract class MessagePanelUtils
extends ContextHolder<Context> {
    private static final boolean DEBUG = false;
    private static final String TAG = MessagePanelUtils.class.getSimpleName();
    public static final long MESSAGE_DURATION_INFINITY = 0L;
    public static final long MESSAGE_DURATION_FLASH = 1500L;
    public static final long MESSAGE_DURATION_SHORT = 2500L;
    public static final long MESSAGE_DURATION_LONG = 5000L;
    public static final String APP_EXTRA_KEY_CLICK_START_ACTIVITY = "APP_EXTRA_KEY_CLICK_START_ACTIVITY";
    public static final String APP_ACTION_CLICK_MESSAGE = "APP_ACTION_CLICK_MESSAGE";
    private static final String APP_ACTION_SHOW_MESSAGE = "APP_ACTION_SHOW_MESSAGE";
    private static final String APP_EXTRA_KEY_MESSAGE_AUTO_HIDE = "APP_EXTRA_KEY_MESSAGE_AUTO_HIDE";
    private static final String APP_EXTRA_KEY_EXCEPTION = "APP_EXTRA_KEY_EXCEPTION";
    private static final String APP_EXTRA_KEY_MESSAGE_ID = "APP_EXTRA_KEY_MESSAGE_ID";
    private static final String APP_EXTRA_KEY_MESSAGE = "APP_EXTRA_KEY_MESSAGE";
    private static final String APP_EXTRA_KEY_CLICK_INTENT = "APP_EXTRA_KEY_CLICK_INTENT";
    private static final String APP_ACTION_HIDE_MESSAGE = "APP_ACTION_HIDE_MESSAGE";
    private static final String APP_EXTRA_KEY_MESSAGE_HIDE_DELAY_MS = "APP_EXTRA_KEY_MESSAGE_HIDE_DELAY_MS";

    private MessagePanelUtils(@NonNull Context context) {
        super(context);
    }

    public static class MessageReceiver
    extends MessagePanelUtils {
        private static final int DURATION_RESIZE_MS = 300;
        @NonNull
        private final View mParentView;
        @NonNull
        final View mPanelView;
        @NonNull
        final TextView mMessageTv;
        private final Animation.AnimationListener mAnimationListener = new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                Object visibility = mPanelView.getTag(R.id.visibility);
                if (visibility instanceof Integer && (Integer)visibility == 1) {
                    long duration;
                    Object durationObj = mPanelView.getTag(R.id.auto_hide_duration);
                    long l = duration = durationObj instanceof Long ? (Long)durationObj : 0L;
                    if (duration > 0L) {
                        mPanelView.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                this.hideMessage(300L);
                            }
                        }, duration);
                    }
                } else {
                    mPanelView.setVisibility(8);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        };
        private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action;
                String string2 = action = intent != null ? intent.getAction() : null;
                if (!TextUtils.isEmpty((CharSequence)action)) {
                    switch (action) {
                        case "APP_ACTION_SHOW_MESSAGE": {
                            this.showMessage(context, intent);
                            break;
                        }
                        case "APP_ACTION_HIDE_MESSAGE": {
                            this.hideMessage(intent.getLongExtra(MessagePanelUtils.APP_EXTRA_KEY_MESSAGE_HIDE_DELAY_MS, 0L));
                        }
                    }
                }
            }
        };

        public MessageReceiver(@NonNull Context context, @NonNull View panelView, @NonNull TextView messageTv) {
            super(context);
            ViewParent parent = panelView.getParent();
            if (parent instanceof View) {
                this.mParentView = (View)parent;
            } else {
                Log.w((String)TAG, (String)("parent is not a instance of View," + parent));
                this.mParentView = panelView;
            }
            this.mPanelView = panelView;
            this.mPanelView.setVisibility(8);
            this.mPanelView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Object obj = v.getTag(R.id.intent);
                    if (obj instanceof Intent) {
                        Intent clickIntent = (Intent)obj;
                        boolean startActivity = clickIntent.getBooleanExtra(MessagePanelUtils.APP_EXTRA_KEY_CLICK_START_ACTIVITY, false);
                        if (startActivity) {
                            v.getContext().startActivity(clickIntent);
                        } else {
                            this.sendLocalBroadcast(clickIntent);
                        }
                    } else {
                        this.hideMessage(300L);
                    }
                }
            });
            this.mMessageTv = messageTv;
            IntentFilter filter = new IntentFilter(MessagePanelUtils.APP_ACTION_SHOW_MESSAGE);
            filter.addAction(MessagePanelUtils.APP_ACTION_HIDE_MESSAGE);
            this.requireLocalBroadcastManager().registerReceiver(this.mReceiver, filter);
        }

        @Override
        protected void internalRelease() {
            try {
                this.requireLocalBroadcastManager().unregisterReceiver(this.mReceiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void showMessage(@NonNull Context context, @NonNull Intent intent) {
            long autoHideDurationMs = intent.getLongExtra(MessagePanelUtils.APP_EXTRA_KEY_MESSAGE_AUTO_HIDE, 0L);
            int msgId = intent.getIntExtra(MessagePanelUtils.APP_EXTRA_KEY_MESSAGE_ID, 0);
            String msg = intent.getStringExtra(MessagePanelUtils.APP_EXTRA_KEY_MESSAGE);
            Intent clickIntent = (Intent)intent.getParcelableExtra(MessagePanelUtils.APP_EXTRA_KEY_CLICK_INTENT);
            if (msgId != 0 && !TextUtils.isEmpty((CharSequence)msg)) {
                this.showMessage(this.getString(msgId, msg), autoHideDurationMs, clickIntent);
            } else if (msgId != 0) {
                this.showMessage(this.getString(msgId), autoHideDurationMs, clickIntent);
            } else if (!TextUtils.isEmpty((CharSequence)msg)) {
                this.showMessage(msg, autoHideDurationMs, clickIntent);
            } else {
                try {
                    String error;
                    Exception e = (Exception)intent.getSerializableExtra(MessagePanelUtils.APP_EXTRA_KEY_EXCEPTION);
                    if (e != null && !TextUtils.isEmpty((CharSequence)(error = e.getMessage()))) {
                        this.showMessage(error, autoHideDurationMs, clickIntent);
                    }
                }
                catch (Exception e1) {
                    Log.w((String)TAG, (Throwable)e1);
                }
            }
        }

        private void showMessage(final String message, final long autoHideDurationMs, final @Nullable Intent clickIntent) {
            this.mPanelView.post(new Runnable(){

                @Override
                public void run() {
                    mMessageTv.setText((CharSequence)message);
                    mPanelView.clearAnimation();
                    ResizeAnimation expandAnimation = new ResizeAnimation(mPanelView, mParentView.getWidth(), 0, mParentView.getWidth(), this.getResources().getDimensionPixelSize(R.dimen.bottom_message_panel_height));
                    expandAnimation.setDuration(300L);
                    expandAnimation.setAnimationListener(mAnimationListener);
                    mPanelView.setVisibility(0);
                    mPanelView.setTag(R.id.visibility, (Object)1);
                    mPanelView.setTag(R.id.auto_hide_duration, (Object)autoHideDurationMs);
                    mPanelView.setTag(R.id.intent, (Object)clickIntent);
                    mPanelView.startAnimation((Animation)expandAnimation);
                }
            });
        }

        private void hideMessage(final long durationMs) {
            this.mPanelView.post(new Runnable(){

                @Override
                public void run() {
                    if (mPanelView.getVisibility() == 0) {
                        mPanelView.clearAnimation();
                        ResizeAnimation collapseAnimation = new ResizeAnimation(mPanelView, mParentView.getWidth(), mPanelView.getHeight(), mParentView.getWidth(), 0);
                        collapseAnimation.setDuration(durationMs);
                        collapseAnimation.setAnimationListener(mAnimationListener);
                        mPanelView.setTag(R.id.visibility, (Object)0);
                        mPanelView.startAnimation((Animation)collapseAnimation);
                    }
                }
            });
        }
    }

    public static class MessageSender
    extends MessagePanelUtils {
        public MessageSender(@NonNull Context context) {
            super(context);
        }

        @Override
        protected void internalRelease() {
        }

        public void showMessage(@NonNull Intent intent) {
            this.sendLocalBroadcast(intent);
        }

        public void showMessage(@StringRes int msgId, long autoHideDurationMs) {
            this.showMessage(msgId, autoHideDurationMs, null);
        }

        public void showMessage(@StringRes int msgId, long autoHideDurationMs, @Nullable Intent clickIntent) {
            Intent intent = new Intent(MessagePanelUtils.APP_ACTION_SHOW_MESSAGE).putExtra(MessagePanelUtils.APP_EXTRA_KEY_MESSAGE_AUTO_HIDE, autoHideDurationMs).putExtra(MessagePanelUtils.APP_EXTRA_KEY_MESSAGE_ID, msgId).putExtra(MessagePanelUtils.APP_EXTRA_KEY_CLICK_INTENT, (Parcelable)clickIntent);
            this.sendLocalBroadcast(intent);
        }

        public void showMessage(String msg, long autoHideDurationMs) {
            this.showMessage(msg, autoHideDurationMs, null);
        }

        public void showMessage(String msg, long autoHideDurationMs, @Nullable Intent clickIntent) {
            Intent intent = new Intent(MessagePanelUtils.APP_ACTION_SHOW_MESSAGE).putExtra(MessagePanelUtils.APP_EXTRA_KEY_MESSAGE_AUTO_HIDE, autoHideDurationMs).putExtra(MessagePanelUtils.APP_EXTRA_KEY_MESSAGE, msg).putExtra(MessagePanelUtils.APP_EXTRA_KEY_CLICK_INTENT, (Parcelable)clickIntent);
            this.sendLocalBroadcast(intent);
        }

        public void showMessage(Exception e, long autoHideDurationMs) {
            this.showMessage(e, autoHideDurationMs, null);
        }

        public void showMessage(Exception e, long autoHideDurationMs, @Nullable Intent clickIntent) {
            Intent intent = new Intent(MessagePanelUtils.APP_ACTION_SHOW_MESSAGE).putExtra(MessagePanelUtils.APP_EXTRA_KEY_MESSAGE_AUTO_HIDE, autoHideDurationMs).putExtra(MessagePanelUtils.APP_EXTRA_KEY_EXCEPTION, (Serializable)e).putExtra(MessagePanelUtils.APP_EXTRA_KEY_CLICK_INTENT, (Parcelable)clickIntent);
            this.sendLocalBroadcast(intent);
        }

        public void hideMessage(long delayMs) {
            Intent intent = new Intent(MessagePanelUtils.APP_ACTION_HIDE_MESSAGE).putExtra(MessagePanelUtils.APP_EXTRA_KEY_MESSAGE_HIDE_DELAY_MS, delayMs);
            this.sendLocalBroadcast(intent);
        }
    }
}

