/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.ContextUtils;
import com.serenegiant.usb.Const;
import com.serenegiant.usb.DeviceFilter;
import com.serenegiant.usb.UsbAttachException;
import com.serenegiant.usb.UsbDetachException;
import com.serenegiant.usb.UsbDeviceInfo;
import com.serenegiant.usb.UsbPermissionException;
import com.serenegiant.usb.UsbUtils;
import com.serenegiant.utils.BufferHelper;
import com.serenegiant.utils.HandlerThreadHandler;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class USBMonitor
implements Const {
    private static final boolean DEBUG = false;
    private static final String TAG = "USBMonitor";
    private static final String ACTION_USB_PERMISSION_BASE = "com.serenegiant.USB_PERMISSION.";
    private final String ACTION_USB_PERMISSION = "com.serenegiant.USB_PERMISSION." + this.hashCode();
    @NonNull
    private final List<UsbControlBlock> mCtrlBlocks = new ArrayList<UsbControlBlock>();
    @NonNull
    private final WeakReference<Context> mWeakContext;
    @NonNull
    private final UsbManager mUsbManager;
    @NonNull
    private final OnDeviceConnectListener mOnDeviceConnectListener;
    @Nullable
    private PendingIntent mPermissionIntent = null;
    @NonNull
    private final List<DeviceFilter> mDeviceFilters = new ArrayList<DeviceFilter>();
    @NonNull
    private final Set<UsbDevice> mAttachedDevices = new HashSet<UsbDevice>();
    private final Handler mAsyncHandler;
    private volatile boolean destroyed;
    private boolean mEnablePolling = !BuildCheck.isAndroid5();
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (USBMonitor.this.destroyed) {
                return;
            }
            USBMonitor.this.onReceive(context, intent);
        }
    };
    private final Runnable mDeviceCheckRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet prevDevices;
            if (USBMonitor.this.destroyed) {
                return;
            }
            USBMonitor.this.mAsyncHandler.removeCallbacks(USBMonitor.this.mDeviceCheckRunnable);
            List<UsbDevice> currentDevices = USBMonitor.this.getDeviceList();
            ArrayList<UsbDevice> mChanged = new ArrayList<UsbDevice>();
            Set set = USBMonitor.this.mAttachedDevices;
            synchronized (set) {
                prevDevices = new HashSet(USBMonitor.this.mAttachedDevices);
                USBMonitor.this.mAttachedDevices.clear();
                USBMonitor.this.mAttachedDevices.addAll(currentDevices);
            }
            for (UsbDevice device : currentDevices) {
                if (prevDevices.contains(device)) continue;
                mChanged.add(device);
            }
            int n = mChanged.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    final UsbDevice device = (UsbDevice)mChanged.get(i);
                    USBMonitor.this.mAsyncHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            USBMonitor.this.mOnDeviceConnectListener.onAttach(device);
                        }
                    });
                }
            }
            if (USBMonitor.this.mEnablePolling) {
                USBMonitor.this.mAsyncHandler.postDelayed(USBMonitor.this.mDeviceCheckRunnable, 1000L);
            }
        }
    };

    public USBMonitor(@NonNull Context context, @NonNull OnDeviceConnectListener listener) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mUsbManager = ContextUtils.requireSystemService(context, UsbManager.class);
        this.mOnDeviceConnectListener = listener;
        this.mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
        this.destroyed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.unregister();
        if (!this.destroyed) {
            ArrayList<UsbControlBlock> ctrlBlocks;
            this.destroyed = true;
            this.mAsyncHandler.removeCallbacksAndMessages(null);
            List<UsbControlBlock> list = this.mCtrlBlocks;
            synchronized (list) {
                ctrlBlocks = new ArrayList<UsbControlBlock>(this.mCtrlBlocks);
                this.mCtrlBlocks.clear();
            }
            for (UsbControlBlock ctrlBlock : ctrlBlocks) {
                try {
                    ctrlBlock.close();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"release:", (Throwable)e);
                }
            }
            try {
                this.mAsyncHandler.getLooper().quit();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"release:", (Throwable)e);
            }
        }
    }

    public void destroy() {
        this.release();
    }

    @SuppressLint(value={"InlinedApi", "WrongConstant"})
    public synchronized void register() throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        if (this.mPermissionIntent == null) {
            int flags;
            Context context = (Context)this.mWeakContext.get();
            if (context != null) {
                flags = 0;
                if (BuildCheck.isAPI31()) {
                    flags |= 0x2000000;
                }
            } else {
                throw new IllegalStateException("context already released");
            }
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)flags);
            IntentFilter filter = this.createIntentFilter();
            context.registerReceiver(this.mUsbReceiver, filter);
            this.mAsyncHandler.postDelayed(this.mDeviceCheckRunnable, 500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister() throws IllegalStateException {
        if (!this.destroyed) {
            this.mAsyncHandler.removeCallbacksAndMessages(null);
        }
        if (this.mPermissionIntent != null) {
            Context context = (Context)this.mWeakContext.get();
            try {
                if (context != null) {
                    context.unregisterReceiver(this.mUsbReceiver);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPermissionIntent = null;
        }
        Set<UsbDevice> set = this.mAttachedDevices;
        synchronized (set) {
            this.mAttachedDevices.clear();
        }
    }

    public synchronized boolean isRegistered() {
        return !this.destroyed && this.mPermissionIntent != null;
    }

    public void setDeviceFilter(@Nullable DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.clear();
        if (filter != null) {
            this.mDeviceFilters.add(filter);
        }
    }

    public void addDeviceFilter(@NonNull DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.add(filter);
    }

    public void removeDeviceFilter(@Nullable DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.remove(filter);
    }

    public void setDeviceFilter(@Nullable List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.clear();
        if (filters != null) {
            this.mDeviceFilters.addAll(filters);
        }
    }

    public void addDeviceFilter(@NonNull List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.addAll(filters);
    }

    public void removeDeviceFilter(List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.removeAll(filters);
    }

    public int getDeviceCount() {
        return this.getDeviceList().size();
    }

    @NonNull
    public List<UsbDevice> getDeviceList() {
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        if (this.destroyed) {
            return result;
        }
        HashMap deviceList = this.mUsbManager.getDeviceList();
        if (deviceList != null) {
            if (this.mDeviceFilters.isEmpty()) {
                result.addAll(deviceList.values());
            } else {
                for (UsbDevice device : deviceList.values()) {
                    if (!this.matches(device)) continue;
                    result.add(device);
                }
            }
        }
        return result;
    }

    private boolean matches(@NonNull UsbDevice device) {
        if (this.mDeviceFilters.isEmpty()) {
            return true;
        }
        for (DeviceFilter filter : this.mDeviceFilters) {
            if (filter == null || !filter.matches(device)) continue;
            if (filter.isExclude) break;
            return true;
        }
        return false;
    }

    @Nullable
    public UsbDevice findDevice(String name) {
        return UsbUtils.findDevice(this.getDeviceList(), name);
    }

    public void refreshDevices() {
        List<UsbDevice> devices = this.getDeviceList();
        for (final UsbDevice device : devices) {
            this.mAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onAttach(device);
                }
            });
        }
    }

    public boolean isEnablePolling() {
        return this.mEnablePolling;
    }

    public synchronized void setEnablePolling(boolean enable) {
        if (this.mEnablePolling != enable) {
            this.mEnablePolling = enable;
            this.mAsyncHandler.removeCallbacks(this.mDeviceCheckRunnable);
            if (enable && this.isRegistered()) {
                this.mAsyncHandler.postDelayed(this.mDeviceCheckRunnable, 500L);
            }
        }
    }

    public boolean hasPermission(UsbDevice device) {
        return !this.destroyed && device != null && this.mUsbManager.hasPermission(device);
    }

    public synchronized boolean requestPermission(@Nullable UsbDevice device) throws IllegalStateException {
        boolean result = false;
        if (this.isRegistered()) {
            if (device != null) {
                if (this.mUsbManager.hasPermission(device)) {
                    this.processPermission(device);
                } else {
                    try {
                        this.mUsbManager.requestPermission(device, this.mPermissionIntent);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                        this.processCancel(device);
                        result = true;
                    }
                }
            } else {
                this.callOnError(device, new UsbPermissionException("device is null"));
                result = true;
            }
        } else {
            throw new IllegalStateException("USBMonitor not registered or already destroyed");
        }
        return result;
    }

    public UsbControlBlock openDevice(UsbDevice device) throws IOException {
        if (this.hasPermission(device)) {
            return new UsbControlBlock(this, device);
        }
        throw new IOException("has no permission or invalid UsbDevice(already disconnected?)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (this.ACTION_USB_PERMISSION.equals(action)) {
            USBMonitor uSBMonitor = this;
            synchronized (uSBMonitor) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                if (device != null && (this.hasPermission(device) || intent.getBooleanExtra("permission", false))) {
                    this.processPermission(device);
                } else if (device != null) {
                    this.processCancel(device);
                } else {
                    this.callOnError(device, new UsbPermissionException("device is null"));
                }
            }
        } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
            UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
            if (device != null) {
                this.processAttach(device);
            } else {
                this.callOnError(device, new UsbAttachException("device is null"));
            }
        } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
            UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
            if (device != null) {
                this.processDettach(device);
            } else {
                this.callOnError(device, new UsbDetachException("device is null"));
            }
        }
    }

    private IntentFilter createIntentFilter() {
        IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
        if (BuildCheck.isAndroid5()) {
            filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        }
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        return filter;
    }

    private void processPermission(@NonNull UsbDevice device) {
        this.mOnDeviceConnectListener.onPermission(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnect(final @NonNull UsbDevice device, final @NonNull UsbControlBlock ctrlBlock) {
        if (this.destroyed) {
            return;
        }
        List<UsbControlBlock> list = this.mCtrlBlocks;
        synchronized (list) {
            this.mCtrlBlocks.add(ctrlBlock);
        }
        if (this.hasPermission(device)) {
            this.mAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onConnected(device, ctrlBlock);
                }
            });
        }
    }

    private void processCancel(final @NonNull UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        this.mAsyncHandler.post(new Runnable(){

            @Override
            public void run() {
                USBMonitor.this.mOnDeviceConnectListener.onCancel(device);
            }
        });
    }

    private void processAttach(final @NonNull UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        if (this.matches(device)) {
            this.hasPermission(device);
            this.mAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onAttach(device);
                }
            });
        }
    }

    private void processDettach(final @NonNull UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        if (this.matches(device)) {
            this.removeAll(device);
            this.mAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onDetach(device);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnDisconnect(@NonNull UsbDevice device, final @NonNull UsbControlBlock ctrlBlock) {
        if (this.destroyed) {
            return;
        }
        List<UsbControlBlock> list = this.mCtrlBlocks;
        synchronized (list) {
            this.mCtrlBlocks.remove(ctrlBlock);
        }
        this.mAsyncHandler.post(new Runnable(){

            @Override
            public void run() {
                USBMonitor.this.mOnDeviceConnectListener.onDisconnect(ctrlBlock.getDevice());
            }
        });
    }

    private void callOnError(final @Nullable UsbDevice device, final @NonNull Throwable t) {
        this.mAsyncHandler.post(new Runnable(){

            @Override
            public void run() {
                USBMonitor.this.mOnDeviceConnectListener.onError(device, t);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private List<UsbControlBlock> findCtrlBlocks(@NonNull UsbDevice device) {
        ArrayList<UsbControlBlock> result = new ArrayList<UsbControlBlock>();
        List<UsbControlBlock> list = this.mCtrlBlocks;
        synchronized (list) {
            for (UsbControlBlock ctrlBlock : this.mCtrlBlocks) {
                if (!ctrlBlock.getDevice().equals((Object)device)) continue;
                result.add(ctrlBlock);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAll(@NonNull UsbDevice device) {
        List<UsbControlBlock> list = this.findCtrlBlocks(device);
        List<UsbControlBlock> list2 = this.mCtrlBlocks;
        synchronized (list2) {
            this.mCtrlBlocks.removeAll(list);
        }
        for (UsbControlBlock ctrlBlock : list) {
            ctrlBlock.close();
        }
    }

    public static final class UsbControlBlock
    implements Cloneable {
        @NonNull
        private final WeakReference<USBMonitor> mWeakMonitor;
        @NonNull
        private final WeakReference<UsbDevice> mWeakDevice;
        @NonNull
        private final UsbDeviceInfo mInfo;
        @NonNull
        private final SparseArray<SparseArray<UsbInterface>> mInterfaces = new SparseArray();
        @Nullable
        private UsbDeviceConnection mConnection;

        private UsbControlBlock(@NonNull USBMonitor monitor, @NonNull UsbDevice device) throws IOException {
            this.mWeakMonitor = new WeakReference<USBMonitor>(monitor);
            this.mWeakDevice = new WeakReference<UsbDevice>(device);
            try {
                this.mConnection = monitor.mUsbManager.openDevice(device);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            String name = device.getDeviceName();
            if (this.mConnection == null) {
                throw new IOException("could not connect to device " + name);
            }
            int fd = this.mConnection.getFileDescriptor();
            byte[] rawDesc = this.mConnection.getRawDescriptors();
            Log.i((String)USBMonitor.TAG, (String)(String.format(Locale.US, "name=%s,fd=%d,rawDesc=", name, fd) + BufferHelper.toHexString(rawDesc, 0, 16)));
            this.mInfo = UsbDeviceInfo.getDeviceInfo(monitor.mUsbManager, device, null);
            monitor.processConnect(device, this);
        }

        private UsbControlBlock(UsbControlBlock src) throws IllegalStateException {
            USBMonitor monitor = src.getMonitor();
            UsbDevice device = src.getDevice();
            if (device == null) {
                throw new IllegalStateException("device may already be removed");
            }
            this.mConnection = monitor.mUsbManager.openDevice(device);
            if (this.mConnection == null) {
                throw new IllegalStateException("device may already be removed or have no permission");
            }
            this.mInfo = UsbDeviceInfo.getDeviceInfo(monitor.mUsbManager, device, null);
            this.mWeakMonitor = new WeakReference<USBMonitor>(monitor);
            this.mWeakDevice = new WeakReference<UsbDevice>(device);
            monitor.processConnect(device, this);
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        public synchronized boolean isValid() {
            return this.mConnection != null;
        }

        @NonNull
        public UsbControlBlock clone() throws CloneNotSupportedException {
            UsbControlBlock ctrlblock;
            try {
                ctrlblock = new UsbControlBlock(this);
            }
            catch (IllegalStateException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
            return ctrlblock;
        }

        @Nullable
        public USBMonitor getMonitor() {
            return (USBMonitor)this.mWeakMonitor.get();
        }

        @Nullable
        public UsbDevice getDevice() {
            return (UsbDevice)this.mWeakDevice.get();
        }

        @NonNull
        public UsbDeviceInfo getInfo() {
            return this.mInfo;
        }

        @NonNull
        public String getDeviceName() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceName() : "";
        }

        public int getDeviceId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceId() : 0;
        }

        @Nullable
        public synchronized UsbDeviceConnection getConnection() {
            return this.mConnection;
        }

        @NonNull
        public synchronized UsbDeviceConnection requireConnection() throws IllegalStateException {
            this.checkConnection();
            return this.mConnection;
        }

        public synchronized int getFileDescriptor() {
            return this.mConnection != null ? this.mConnection.getFileDescriptor() : 0;
        }

        public synchronized int requireFileDescriptor() throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.getFileDescriptor();
        }

        @Nullable
        public synchronized byte[] getRawDescriptors() {
            this.checkConnection();
            return this.mConnection != null ? this.mConnection.getRawDescriptors() : null;
        }

        @NonNull
        public synchronized byte[] requireRawDescriptors() throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.getRawDescriptors();
        }

        public int getVenderId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getVendorId() : 0;
        }

        public int getProductId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getProductId() : 0;
        }

        public String getUsbVersion() {
            return this.mInfo.usb_version;
        }

        public String getManufacture() {
            return this.mInfo.manufacturer;
        }

        public String getProductName() {
            return this.mInfo.product;
        }

        public String getVersion() {
            return this.mInfo.version;
        }

        public String getSerial() {
            return this.mInfo.serial;
        }

        public synchronized UsbInterface getInterface(int interface_id) throws IllegalStateException {
            return this.getInterface(interface_id, 0);
        }

        @SuppressLint(value={"NewApi"})
        public synchronized UsbInterface getInterface(int interface_id, int altsetting) throws IllegalStateException {
            UsbInterface intf;
            this.checkConnection();
            SparseArray intfs = (SparseArray)this.mInterfaces.get(interface_id);
            if (intfs == null) {
                intfs = new SparseArray();
                this.mInterfaces.put(interface_id, (Object)intfs);
            }
            if ((intf = (UsbInterface)intfs.get(altsetting)) == null) {
                UsbDevice device = (UsbDevice)this.mWeakDevice.get();
                int n = device.getInterfaceCount();
                for (int i = 0; i < n; ++i) {
                    UsbInterface temp = device.getInterface(i);
                    if (temp.getId() != interface_id || temp.getAlternateSetting() != altsetting) continue;
                    intf = temp;
                    break;
                }
                if (intf != null) {
                    intfs.append(altsetting, (Object)intf);
                }
            }
            return intf;
        }

        public synchronized void claimInterface(UsbInterface intf) throws IllegalStateException {
            this.claimInterface(intf, true);
        }

        public synchronized void claimInterface(UsbInterface intf, boolean force) throws IllegalStateException {
            this.checkConnection();
            this.mConnection.claimInterface(intf, force);
        }

        public synchronized void releaseInterface(UsbInterface intf) throws IllegalStateException {
            this.checkConnection();
            SparseArray intfs = (SparseArray)this.mInterfaces.get(intf.getId());
            if (intfs != null) {
                int index = intfs.indexOfValue((Object)intf);
                intfs.removeAt(index);
                if (intfs.size() == 0) {
                    this.mInterfaces.remove(intf.getId());
                }
            }
            this.mConnection.releaseInterface(intf);
        }

        @RequiresApi(value=18)
        public synchronized int bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int offset, int length, int timeout) throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.bulkTransfer(endpoint, buffer, offset, length, timeout);
        }

        public synchronized int bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int length, int timeout) throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.bulkTransfer(endpoint, buffer, length, timeout);
        }

        @RequiresApi(value=18)
        public synchronized int controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int offset, int length, int timeout) throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.controlTransfer(requestType, request, value, index, buffer, offset, length, timeout);
        }

        public synchronized int controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int length, int timeout) throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.controlTransfer(requestType, request, value, index, buffer, length, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            UsbDeviceConnection connection;
            UsbControlBlock usbControlBlock = this;
            synchronized (usbControlBlock) {
                connection = this.mConnection;
                this.mConnection = null;
            }
            if (connection != null) {
                int n = this.mInterfaces.size();
                for (int i = 0; i < n; ++i) {
                    SparseArray intfs = (SparseArray)this.mInterfaces.valueAt(i);
                    if (intfs == null) continue;
                    int m = intfs.size();
                    for (int j = 0; j < m; ++j) {
                        UsbInterface intf = (UsbInterface)intfs.valueAt(j);
                        connection.releaseInterface(intf);
                    }
                    intfs.clear();
                }
                this.mInterfaces.clear();
                connection.close();
                USBMonitor monitor = this.getMonitor();
                UsbDevice device = this.getDevice();
                if (monitor != null && device != null) {
                    monitor.callOnDisconnect(device, this);
                }
            }
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof UsbControlBlock) {
                UsbDevice device = ((UsbControlBlock)o).getDevice();
                return device == null ? this.mWeakDevice.get() == null : device.equals(this.mWeakDevice.get());
            }
            if (o instanceof UsbDevice) {
                return o.equals(this.mWeakDevice.get());
            }
            return super.equals(o);
        }

        private synchronized void checkConnection() throws IllegalStateException {
            if (this.mConnection == null) {
                throw new IllegalStateException("already closed");
            }
        }
    }

    public static interface OnDeviceConnectListener {
        public void onAttach(@NonNull UsbDevice var1);

        public void onDetach(@NonNull UsbDevice var1);

        public void onPermission(@NonNull UsbDevice var1);

        public void onConnected(@NonNull UsbDevice var1, @NonNull UsbControlBlock var2);

        public void onDisconnect(@NonNull UsbDevice var1);

        public void onCancel(@NonNull UsbDevice var1);

        public void onError(@Nullable UsbDevice var1, @NonNull Throwable var2);
    }
}

