/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@Deprecated
public final class PermissionCheck {
    private static final boolean DEBUG = false;
    private static final String TAG = PermissionCheck.class.getSimpleName();

    private PermissionCheck() {
    }

    public static final void dumpPermissions(@Nullable Context context) {
        if (context == null) {
            return;
        }
        try {
            PackageManager pm = context.getPackageManager();
            List list = pm.getAllPermissionGroups(128);
            for (PermissionGroupInfo info : list) {
                Log.d((String)TAG, (String)("dumpPermissions:" + info.name + "=" + info));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NonNull
    public static String[] requestedPermissions(@NonNull Context context) {
        PackageInfo info = null;
        try {
            info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info != null && info.requestedPermissions != null ? info.requestedPermissions : new String[]{};
    }

    public static int checkSelfPermission(@Nullable Context context, String permissionName) {
        if (context == null) {
            return -1;
        }
        int result = -1;
        try {
            result = ContextCompat.checkSelfPermission((Context)context, (String)permissionName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean hasPermission(@Nullable Context context, String permissionName) {
        if (context == null) {
            return false;
        }
        boolean result = false;
        try {
            result = ContextCompat.checkSelfPermission((Context)context, (String)permissionName) == 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @NonNull
    public static String[] hasPermission(@Nullable Context context, @NonNull String[] permissions) {
        ArrayList<String> result = new ArrayList<String>();
        if (context != null) {
            for (String permission2 : permissions) {
                if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) != 0) continue;
                result.add(permission2);
            }
        }
        return result.toArray(new String[0]);
    }

    public static boolean hasPermissionAll(@Nullable Context context, @NonNull String[] permissions) {
        boolean result = true;
        if (context != null) {
            for (String permission2 : permissions) {
                if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean hasPermissionAll(@Nullable Context context) {
        boolean result = false;
        if (context != null) {
            result = PermissionCheck.hasPermissionAll(context, PermissionCheck.requestedPermissions(context));
        }
        return result;
    }

    public static boolean hasAudio(@Nullable Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.RECORD_AUDIO");
    }

    public static boolean hasNetwork(@Nullable Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.INTERNET");
    }

    public static boolean hasNetworkState(@Nullable Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE");
    }

    public static boolean hasWriteExternalStorage(@Nullable Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean hasReadExternalStorage(@Nullable Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean hasAccessLocation(@Nullable Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION") && PermissionCheck.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    public static boolean hasAccessCoarseLocation(@Nullable Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
    }

    public static boolean hasAccessFineLocation(@Nullable Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    public static boolean hasCamera(@Nullable Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.CAMERA");
    }

    public static void openSettings(@NonNull Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
        intent.setData(uri);
        context.startActivity(intent);
    }

    @NonNull
    public static List<String> missingPermissions(@NonNull Context context) throws IllegalArgumentException, PackageManager.NameNotFoundException {
        return PermissionCheck.missingPermissions(context, PermissionCheck.requestedPermissions(context));
    }

    @NonNull
    public static List<String> missingPermissions(@NonNull Context context, @NonNull String[] expectations) throws IllegalArgumentException, PackageManager.NameNotFoundException {
        return PermissionCheck.missingPermissions(context, Arrays.asList(expectations));
    }

    @NonNull
    public static List<String> missingPermissions(@NonNull Context context, @NonNull Collection<String> expectations) throws IllegalArgumentException, PackageManager.NameNotFoundException {
        PackageManager pm = context.getPackageManager();
        PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 4096);
        ArrayList<String> result = new ArrayList<String>(expectations);
        String[] permissions = pi.requestedPermissions;
        if (permissions != null && permissions.length > 0) {
            for (String permission2 : permissions) {
                if (!PermissionCheck.hasPermission(context, permission2)) continue;
                result.remove(permission2);
            }
        }
        return result;
    }
}

