/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.graphics.Bitmap;
import android.view.Choreographer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLConst;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.GLTexture;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.math.Fraction;

public class ImageTextureSource
implements GLConst,
IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = ImageTextureSource.class.getSimpleName();
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final GLManager mManager;
    @Nullable
    private GLTexture mImageSource;
    private volatile long mFrameIntervalNs;
    private volatile boolean mReleased = false;
    private int mWidth;
    private int mHeight;
    @Nullable
    private GLDrawer2D mDrawer;
    @Nullable
    private RendererTarget mRendererTarget;
    private int mMirror = 0;
    private final Choreographer.FrameCallback mFrameCallback = new Choreographer.FrameCallback(){
        private long prevFrameTimeNs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void doFrame(long frameTimeNanos) {
            if (ImageTextureSource.this.isValid()) {
                long delayMs = (ImageTextureSource.this.mFrameIntervalNs - (frameTimeNanos - this.prevFrameTimeNs)) / 1000000L;
                this.prevFrameTimeNs = frameTimeNanos;
                if (delayMs <= 0L) {
                    ImageTextureSource.this.mManager.postFrameCallbackDelayed(this, 0L);
                } else {
                    ImageTextureSource.this.mManager.postFrameCallbackDelayed(this, delayMs);
                }
                Object object = ImageTextureSource.this.mSync;
                synchronized (object) {
                    if (ImageTextureSource.this.mImageSource != null) {
                        ImageTextureSource.this.onFrameAvailable(ImageTextureSource.this.mImageSource.getTexId(), ImageTextureSource.this.mImageSource.getTexMatrix());
                    }
                }
            }
        }
    };

    public ImageTextureSource(@NonNull GLManager manager, final @Nullable Bitmap bitmap, final @Nullable Fraction fps) {
        this.mManager = manager;
        this.mWidth = 640;
        this.mHeight = 480;
        if (bitmap != null) {
            this.mManager.runOnGLThread(new Runnable(){

                @Override
                @WorkerThread
                public void run() {
                    ImageTextureSource.this.createImageSource(bitmap, fps);
                }
            });
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public final void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            this.internalRelease();
        }
    }

    protected void internalRelease() {
        if (this.isValid()) {
            this.mManager.runOnGLThread(new Runnable(){

                @Override
                public void run() {
                    ImageTextureSource.this.releaseImageSource();
                    ImageTextureSource.this.releaseTarget();
                }
            });
        }
    }

    @NonNull
    public GLManager getGLManager() throws IllegalStateException {
        return this.mManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTexId() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isValid() || this.mImageSource == null) {
                throw new IllegalStateException("already released or image not set yet.");
            }
            return this.mImageSource != null ? this.mImageSource.getTexId() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Size(min=16L)
    @NonNull
    public float[] getTexMatrix() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isValid() || this.mImageSource == null) {
                throw new IllegalStateException("already released or image not set yet.");
            }
            return this.mImageSource.getTexMatrix();
        }
    }

    public boolean isValid() {
        return !this.mReleased && this.mManager.isValid();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSurface() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMirror(int mirror) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mMirror != mirror) {
                this.mMirror = mirror;
                this.mManager.runOnGLThread(() -> {
                    if (this.mRendererTarget != null) {
                        this.mRendererTarget.setMirror(mirror);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMirror() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mMirror;
        }
    }

    public void setSource(final @Nullable Bitmap bitmap, final @Nullable Fraction fps) {
        this.mManager.runOnGLThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ImageTextureSource.this.mSync;
                synchronized (object) {
                    if (bitmap == null) {
                        ImageTextureSource.this.releaseImageSource();
                    } else {
                        ImageTextureSource.this.createImageSource(bitmap, fps);
                    }
                }
            }
        });
    }

    public void setSurface(@Nullable Object surface) throws IllegalStateException, IllegalArgumentException {
        this.setSurface(surface, null);
    }

    public void setSurface(final @Nullable Object surface, final @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        if (!this.isValid()) {
            throw new IllegalStateException("already released?");
        }
        if (surface != null && !GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Unsupported surface type!," + surface);
        }
        this.mManager.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                ImageTextureSource.this.createTargetOnGL(surface, maxFps);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void onFrameAvailable(int texId, float[] texMatrix) {
        if (this.isValid()) {
            RendererTarget target;
            GLDrawer2D drawer;
            Object object = this.mSync;
            synchronized (object) {
                drawer = this.mDrawer;
                target = this.mRendererTarget;
            }
            if (drawer != null && target != null && target.canDraw()) {
                target.draw(drawer, 33984, texId, texMatrix);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void releaseImageSource() {
        this.mManager.removeFrameCallback(this.mFrameCallback);
        Object object = this.mSync;
        synchronized (object) {
            if (this.mImageSource != null) {
                this.mImageSource.release();
                this.mImageSource = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void createImageSource(@NonNull Bitmap bitmap, @Nullable Fraction fps) {
        this.mManager.removeFrameCallback(this.mFrameCallback);
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        boolean needResize = this.getWidth() != width || this.getHeight() != height;
        float _fps = fps != null ? fps.asFloat() : 30.0f;
        Object object = this.mSync;
        synchronized (object) {
            if (this.mImageSource == null || needResize) {
                this.releaseImageSource();
                this.mImageSource = GLTexture.newInstance(33984, width, height);
                GLUtils.checkGlError("createImageSource");
            }
            this.mImageSource.loadBitmap(bitmap);
            this.mFrameIntervalNs = Math.round(1.0E9 / (double)_fps);
            this.mWidth = width;
            this.mHeight = height;
        }
        this.mManager.postFrameCallbackDelayed(this.mFrameCallback, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void createTargetOnGL(@Nullable Object surface, @Nullable Fraction maxFps) {
        Object object = this.mSync;
        synchronized (object) {
            Object object2 = this.mSync;
            synchronized (object2) {
                if (this.mRendererTarget != null && this.mRendererTarget.getSurface() != surface) {
                    this.mRendererTarget.release();
                    this.mRendererTarget = null;
                }
                if (this.mRendererTarget == null && surface != null) {
                    this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), surface, maxFps != null ? maxFps.asFloat() : 0.0f);
                    this.mRendererTarget.setMirror(this.mMirror);
                    if (this.mDrawer == null) {
                        this.mDrawer = GLDrawer2D.create(this.mManager.isGLES3(), false);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void releaseTarget() {
        RendererTarget target;
        GLDrawer2D drawer;
        Object object = this.mSync;
        synchronized (object) {
            drawer = this.mDrawer;
            this.mDrawer = null;
            target = this.mRendererTarget;
            this.mRendererTarget = null;
        }
        if ((drawer != null || target != null) && this.mManager.isValid()) {
            try {
                this.mManager.runOnGLThread(new Runnable(){

                    @Override
                    @WorkerThread
                    public void run() {
                        if (drawer != null) {
                            drawer.release();
                        }
                        if (target != null) {
                            target.release();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

