/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.gl;

import android.opengl.GLES20;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLEffect;
import com.serenegiant.gl.ShaderConst;

public class EffectDrawer2D
extends GLDrawer2D {
    private static final boolean DEBUG = false;
    private static final String TAG = EffectDrawer2D.class.getSimpleName();
    @Nullable
    private final EffectListener mEffectListener;
    @NonNull
    private final SparseArray<float[]> mParams = new SparseArray();
    private int muParamsLoc;
    @Nullable
    private float[] mCurrentParams;
    private int mEffect;

    public EffectDrawer2D(boolean isGLES3, boolean isOES) {
        this(isGLES3, isOES, null, null, null, null, null);
    }

    public EffectDrawer2D(boolean isGLES3, boolean isOES, @Nullable EffectListener effectListener) {
        this(isGLES3, isOES, null, null, null, null, effectListener);
    }

    public EffectDrawer2D(boolean isGLES3, float[] vertices, float[] texcoord, boolean isOES) {
        this(isGLES3, isOES, vertices, texcoord, null, null, null);
    }

    public EffectDrawer2D(boolean isGLES3, float[] vertices, float[] texcoord, boolean isOES, @Nullable EffectListener effectListener) {
        this(isGLES3, isOES, vertices, texcoord, null, null, effectListener);
    }

    protected EffectDrawer2D(boolean isGLES3, boolean isOES, @NonNull @Size(min=8L) float[] vertices, @NonNull @Size(min=8L) float[] texcoord, @Nullable String vs, @Nullable String fs, @Nullable EffectListener effectListener) {
        super(isGLES3, isOES, vertices, texcoord, vs, fs);
        this.mEffectListener = effectListener;
        this.resetShader();
    }

    @Override
    public void resetShader() {
        super.resetShader();
        this.mParams.clear();
        this.mParams.put(9, (Object)new float[]{0.17f, 0.85f, 0.5f, 1.0f, 0.4f, 1.0f, 1.0f, 1.0f, 5.0f, 1.0f, 1.0f, 1.0f});
        this.mParams.put(10, (Object)new float[]{0.17f, 0.85f, 0.5f, 1.0f, 0.4f, 1.0f, 1.0f, 1.0f, 5.0f, 1.0f, 1.0f, 1.0f});
        this.mParams.put(11, (Object)new float[]{0.1f, 0.19f, 0.3f, 1.0f, 0.3f, 1.0f, 1.0f, 1.0f, 5.0f, 1.0f, 0.8f, 0.8f, 0.15f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f});
        this.mEffect = 0;
    }

    public void resetEffect() {
        this.resetShader();
    }

    public void setEffect(int effect) {
        if (this.mEffect != effect) {
            this.mEffect = effect;
            boolean handled = false;
            try {
                handled = this.mEffectListener != null && this.mEffectListener.onChangeEffect(effect, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!handled) {
                switch (effect) {
                    case 0: {
                        this.updateShader(this.isGLES3 ? ShaderConst.FRAGMENT_SHADER_EXT_ES3 : ShaderConst.FRAGMENT_SHADER_EXT_ES2);
                        break;
                    }
                    case 1: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_EXT_GRAY_ES3 : GLEffect.FRAGMENT_SHADER_EXT_GRAY_ES2);
                        break;
                    }
                    case 2: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_GRAY_EXT_REVERSE_ES3 : GLEffect.FRAGMENT_SHADER_GRAY_EXT_REVERSE_ES2);
                        break;
                    }
                    case 3: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_EXT_BIN_ES3 : GLEffect.FRAGMENT_SHADER_EXT_BIN_ES2);
                        break;
                    }
                    case 4: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_EXT_BIN_YELLOW_ES3 : GLEffect.FRAGMENT_SHADER_EXT_BIN_YELLOW_ES2);
                        break;
                    }
                    case 5: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_EXT_BIN_GREEN_ES3 : GLEffect.FRAGMENT_SHADER_EXT_BIN_GREEN_ES2);
                        break;
                    }
                    case 6: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_EXT_BIN_REVERSE_ES3 : GLEffect.FRAGMENT_SHADER_EXT_BIN_REVERSE_ES2);
                        break;
                    }
                    case 7: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_EXT_BIN_REVERSE_YELLOW_ES3 : GLEffect.FRAGMENT_SHADER_EXT_BIN_REVERSE_YELLOW_ES2);
                        break;
                    }
                    case 8: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_EXT_BIN_REVERSE_GREEN_ES3 : GLEffect.FRAGMENT_SHADER_EXT_BIN_REVERSE_GREEN_ES2);
                        break;
                    }
                    case 9: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_EXT_EMPHASIZE_RED_YELLOWS_ES3 : GLEffect.FRAGMENT_SHADER_EXT_EMPHASIZE_RED_YELLOWS_ES2);
                        break;
                    }
                    case 10: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_EXT_EMPHASIZE_RED_YELLOW_WHITE_ES3 : GLEffect.FRAGMENT_SHADER_EXT_EMPHASIZE_RED_YELLOW_WHITE_ES2);
                        break;
                    }
                    case 11: {
                        this.updateShader(this.isGLES3 ? GLEffect.FRAGMENT_SHADER_EXT_EMPHASIZE_YELLOW_WHITE_ES3 : GLEffect.FRAGMENT_SHADER_EXT_EMPHASIZE_YELLOW_WHITE_ES2);
                        break;
                    }
                    default: {
                        this.resetShader();
                    }
                }
            }
            this.muParamsLoc = this.glGetUniformLocation("uParams");
            this.mCurrentParams = (float[])this.mParams.get(effect);
            this.updateParams();
        }
    }

    public int getCurrentEffect() {
        return this.mEffect;
    }

    public void setParams(@NonNull float[] params) {
        this.setParams(this.mEffect, params);
    }

    public void setParams(int effect, @NonNull float[] params) throws IllegalArgumentException {
        if (effect < 0 || this.mEffect == effect) {
            this.mCurrentParams = params;
            this.mParams.put(this.mEffect, (Object)params);
            this.updateParams();
        } else {
            this.mParams.put(effect, (Object)params);
        }
    }

    private void updateParams() {
        int n = Math.min(this.mCurrentParams != null ? this.mCurrentParams.length : 0, 18);
        if (this.muParamsLoc >= 0 && n > 0) {
            this.glUseProgram();
            GLES20.glUniform1fv((int)this.muParamsLoc, (int)n, (float[])this.mCurrentParams, (int)0);
        }
    }

    public static interface EffectListener {
        public boolean onChangeEffect(int var1, @NonNull GLDrawer2D var2);
    }
}

