/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.dialog;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.serenegiant.common.R;
import com.serenegiant.dialog.DialogFragmentEx;
import com.serenegiant.system.BuildCheck;
import java.util.HashMap;
import java.util.Map;

public class RationalDialogV4
extends DialogFragmentEx {
    private static final boolean DEBUG = false;
    private static final String TAG = RationalDialogV4.class.getSimpleName();
    private static final String ARGS_KEY_PERMISSIONS = "permissions";
    private static final Map<String, RationalResource> mRationalResources = new HashMap<String, RationalResource>();
    @Nullable
    private DialogResultListener mDialogListener;
    private final DialogInterface.OnClickListener mOnClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            RationalDialogV4.this.callOnMessageDialogResult(which == -1);
        }
    };

    @Nullable
    public static RationalDialogV4 showDialog(@NonNull FragmentActivity parent, @NonNull String permission2) {
        RationalResource res;
        RationalResource rationalResource = res = mRationalResources.containsKey(permission2) ? mRationalResources.get(permission2) : null;
        if (res != null) {
            return RationalDialogV4.showDialog(parent, res.titleRes, res.messageRes, new String[]{permission2});
        }
        return null;
    }

    @Nullable
    public static RationalDialogV4 showDialog(@NonNull Fragment parent, @NonNull String permission2) {
        RationalResource res;
        RationalResource rationalResource = res = mRationalResources.containsKey(permission2) ? mRationalResources.get(permission2) : null;
        if (res != null) {
            return RationalDialogV4.showDialog(parent, res.titleRes, res.messageRes, new String[]{permission2});
        }
        return null;
    }

    public static RationalDialogV4 showDialog(@NonNull FragmentActivity parent, @StringRes int titleRes, @StringRes int messageRes, @NonNull String[] permissions) throws IllegalStateException {
        RationalDialogV4 dialog = RationalDialogV4.newInstance(titleRes, messageRes, permissions);
        dialog.show(parent.getSupportFragmentManager(), TAG);
        return dialog;
    }

    public static RationalDialogV4 showDialog(@NonNull Fragment parent, @StringRes int titleRes, @StringRes int messageRes, @NonNull String[] permissions) throws IllegalStateException {
        RationalDialogV4 dialog = RationalDialogV4.newInstance(titleRes, messageRes, permissions);
        dialog.setTargetFragment(parent, parent.getId());
        dialog.show(parent.getParentFragmentManager(), TAG);
        return dialog;
    }

    public static RationalDialogV4 newInstance(@StringRes int titleRes, @StringRes int messageRes, @NonNull String[] permissions) {
        RationalDialogV4 fragment = new RationalDialogV4();
        Bundle args = new Bundle();
        args.putInt("title", titleRes);
        args.putInt("message", messageRes);
        args.putStringArray(ARGS_KEY_PERMISSIONS, permissions);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(@NonNull Context context) {
        Fragment target;
        Fragment fragment;
        super.onAttach(context);
        if (context instanceof DialogResultListener) {
            this.mDialogListener = (DialogResultListener)context;
        }
        if (this.mDialogListener == null && (fragment = this.getTargetFragment()) instanceof DialogResultListener) {
            this.mDialogListener = (DialogResultListener)fragment;
        }
        if (this.mDialogListener == null && BuildCheck.isAndroid4_2() && (target = this.getParentFragment()) instanceof DialogResultListener) {
            this.mDialogListener = (DialogResultListener)target;
        }
        if (this.mDialogListener == null) {
            throw new ClassCastException(context.toString());
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = savedInstanceState != null ? savedInstanceState : this.requireArguments();
        int id_title = args.getInt("title");
        int id_message = args.getInt("message");
        FragmentActivity activity = this.requireActivity();
        return new AlertDialog.Builder((Context)activity, this.getTheme()).setIcon(17301543).setTitle(id_title).setMessage(id_message).setPositiveButton(17039370, this.mOnClickListener).setNegativeButton(0x1040000, this.mOnClickListener).create();
    }

    public void onCancel(@NonNull DialogInterface dialog) {
        super.onCancel(dialog);
        this.callOnMessageDialogResult(false);
    }

    private void callOnMessageDialogResult(boolean result) throws IllegalStateException {
        Bundle args = this.requireArguments();
        String[] permissions = args.getStringArray(ARGS_KEY_PERMISSIONS);
        try {
            this.mDialogListener.onDialogResult(this, permissions, result);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    static {
        mRationalResources.put("android.permission.CAMERA", new RationalResource(R.string.permission_title, R.string.permission_camera_reason));
        mRationalResources.put("android.permission.WRITE_EXTERNAL_STORAGE", new RationalResource(R.string.permission_title, R.string.permission_ext_storage_reason));
        mRationalResources.put("android.permission.READ_EXTERNAL_STORAGE", new RationalResource(R.string.permission_title, R.string.permission_read_ext_storage_reason));
        mRationalResources.put("android.permission.RECORD_AUDIO", new RationalResource(R.string.permission_title, R.string.permission_audio_recording_reason));
        mRationalResources.put("android.permission.ACCESS_COARSE_LOCATION", new RationalResource(R.string.permission_title, R.string.permission_location_reason));
        mRationalResources.put("android.permission.ACCESS_FINE_LOCATION", new RationalResource(R.string.permission_title, R.string.permission_location_reason));
        mRationalResources.put("android.permission.ACCESS_NETWORK_STATE", new RationalResource(R.string.permission_title, R.string.permission_network_state_reason));
        mRationalResources.put("android.permission.CHANGE_NETWORK_STATE", new RationalResource(R.string.permission_title, R.string.permission_change_network_state_reason));
    }

    private static class RationalResource {
        @StringRes
        public final int titleRes;
        @StringRes
        public final int messageRes;

        public RationalResource(@StringRes int titleRes, @StringRes int messageRes) {
            this.titleRes = titleRes;
            this.messageRes = messageRes;
        }
    }

    public static interface DialogResultListener {
        public void onDialogResult(@NonNull RationalDialogV4 var1, @NonNull String[] var2, boolean var3);
    }
}

