/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.SeekBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatSeekBar;
import com.serenegiant.common.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class OrientationSeekbar
extends AppCompatSeekBar {
    private static final boolean DEBUG = false;
    private static final String TAG = OrientationSeekbar.class.getSimpleName();
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mOrientation = 0;
    @Nullable
    private SeekBar.OnSeekBarChangeListener onChangeListener;
    @Nullable
    private Paint mDebugPaint;
    private int lastProgress = 0;

    public OrientationSeekbar(@NonNull Context context) {
        this(context, null, 0);
    }

    public OrientationSeekbar(@NonNull Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OrientationSeekbar(@NonNull Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.OrientationSeekbar, defStyleAttr, 0);
        this.mOrientation = a.getInt(R.styleable.OrientationSeekbar_android_orientation, this.mOrientation);
        a.recycle();
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
        this.requestLayout();
    }

    public void setOnSeekBarChangeListener(@Nullable SeekBar.OnSeekBarChangeListener listener) {
        super.setOnSeekBarChangeListener(listener);
        this.onChangeListener = listener;
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        if (this.mOrientation == 0) {
            super.onSizeChanged(width, height, oldWidth, oldHeight);
        } else {
            super.onSizeChanged(height, width, oldHeight, oldWidth);
        }
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean isHorizontal = this.mOrientation == 0;
        super.onMeasure(isHorizontal ? widthMeasureSpec : heightMeasureSpec, isHorizontal ? heightMeasureSpec : widthMeasureSpec);
        this.setMeasuredDimension(isHorizontal ? this.getMeasuredWidth() : this.getMeasuredHeight(), isHorizontal ? this.getMeasuredHeight() : this.getMeasuredWidth());
    }

    public void draw(Canvas canvas) {
        boolean isHorizontal = this.mOrientation == 0;
        float w = isHorizontal ? (float)this.getWidth() : (float)this.getHeight();
        float h = isHorizontal ? (float)this.getHeight() : (float)this.getWidth();
        float w2 = w / 2.0f;
        float h2 = h / 2.0f;
        if (!isHorizontal) {
            canvas.rotate(270.0f);
            canvas.translate(-w, 0.0f);
        }
        super.draw(canvas);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.mOrientation == 0) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.onChangeListener.onStartTrackingTouch((SeekBar)this);
                this.setPressed(true);
                this.setSelected(true);
                break;
            }
            case 2: {
                super.onTouchEvent(event);
                int progress = this.getMax() - (int)((float)this.getMax() * event.getY() / (float)this.getHeight());
                if (progress < 0) {
                    progress = 0;
                }
                if (progress > this.getMax()) {
                    progress = this.getMax();
                }
                this.setProgress(progress);
                if (progress != this.lastProgress) {
                    this.lastProgress = progress;
                    this.onChangeListener.onProgressChanged((SeekBar)this, progress, true);
                }
                this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                this.onChangeListener.onProgressChanged((SeekBar)this, (int)((float)this.getMax() * event.getY() / (float)this.getHeight()), true);
                this.setPressed(true);
                this.setSelected(true);
                break;
            }
            case 1: {
                this.onChangeListener.onStopTrackingTouch((SeekBar)this);
                this.setPressed(false);
                this.setSelected(false);
                break;
            }
            case 3: {
                super.onTouchEvent(event);
                this.setPressed(false);
                this.setSelected(false);
            }
        }
        return true;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

