/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.notification;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.serenegiant.common.R;
import com.serenegiant.notification.NotificationBuilder;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.ContextUtils;
import java.util.List;

public class NotificationFactory {
    private static final boolean DEBUG = false;
    private static final String TAG = NotificationFactory.class.getSimpleName();
    @NonNull
    protected final Context context;
    @NonNull
    protected final String channelId;
    @Nullable
    protected final String channelTitle;
    protected final int importance;
    @Nullable
    protected final String groupId;
    @Nullable
    protected final String groupName;
    @DrawableRes
    protected final int smallIconId;
    @DrawableRes
    protected final int largeIconId;

    @SuppressLint(value={"InlinedApi"})
    public NotificationFactory(@NonNull Context context, @NonNull String channelId, @Nullable String channelTitle, @DrawableRes int smallIconId) {
        this(context, channelId, channelId, BuildCheck.isAndroid7() ? 0 : 0, null, null, smallIconId, R.drawable.ic_notification);
    }

    @SuppressLint(value={"InlinedApi"})
    public NotificationFactory(@NonNull Context context, @NonNull String channelId, @Nullable String channelTitle, @DrawableRes int smallIconId, @DrawableRes int largeIconId) {
        this(context, channelId, channelId, BuildCheck.isAndroid7() ? 0 : 0, null, null, smallIconId, largeIconId);
    }

    public NotificationFactory(@NonNull Context context, @NonNull String channelId, @Nullable String channelTitle, int importance, @Nullable String groupId, @Nullable String groupName, @DrawableRes int smallIconId, @DrawableRes int largeIconId) throws IllegalArgumentException {
        this.context = context;
        this.channelId = channelId;
        this.channelTitle = TextUtils.isEmpty((CharSequence)channelTitle) ? channelId : channelTitle;
        this.importance = importance;
        this.groupId = groupId;
        this.groupName = TextUtils.isEmpty((CharSequence)groupName) ? groupId : groupName;
        this.smallIconId = smallIconId;
        this.largeIconId = largeIconId;
        if (!BuildCheck.isAPI21()) {
            Drawable drawable2;
            try {
                drawable2 = ContextCompat.getDrawable((Context)context, (int)smallIconId);
            }
            catch (Exception e) {
                drawable2 = VectorDrawableCompat.create((Resources)context.getResources(), (int)smallIconId, null);
            }
            if (drawable2 instanceof VectorDrawableCompat) {
                throw new IllegalArgumentException("Can't use vector drawable as small icon before API21!");
            }
        }
    }

    public boolean isForegroundService() {
        return true;
    }

    @SuppressLint(value={"NewApi"})
    @NonNull
    public Notification createNotification(@NonNull CharSequence title, @NonNull CharSequence content) {
        if (BuildCheck.isOreo()) {
            this.createNotificationChannel(this.context);
        }
        NotificationBuilder builder = this.createNotificationBuilder(this.context, title, content);
        return builder.build();
    }

    @RequiresApi(value=26)
    protected void createNotificationChannel(@NonNull Context context) {
        NotificationManager manager = ContextUtils.requireSystemService(context, NotificationManager.class);
        if (manager.getNotificationChannel(this.channelId) == null) {
            NotificationChannel channel = new NotificationChannel(this.channelId, (CharSequence)this.channelTitle, this.importance);
            if (!TextUtils.isEmpty((CharSequence)this.groupId)) {
                this.createNotificationChannelGroup(context, this.groupId, this.groupName);
                channel.setGroup(this.groupId);
            }
            channel.setLockscreenVisibility(0);
            manager.createNotificationChannel(this.setupNotificationChannel(channel));
        }
    }

    @RequiresApi(value=26)
    @NonNull
    protected NotificationChannel setupNotificationChannel(@NonNull NotificationChannel channel) {
        return channel;
    }

    @RequiresApi(value=26)
    protected void createNotificationChannelGroup(@NonNull Context context, @Nullable String groupId, @Nullable String groupName) {
        if (!TextUtils.isEmpty((CharSequence)groupId)) {
            NotificationManager manager = ContextUtils.requireSystemService(context, NotificationManager.class);
            List groups = manager.getNotificationChannelGroups();
            NotificationChannelGroup found = null;
            for (NotificationChannelGroup group : groups) {
                if (!groupId.equals(group.getId())) continue;
                found = group;
                break;
            }
            if (found == null) {
                found = new NotificationChannelGroup(groupId, (CharSequence)(TextUtils.isEmpty((CharSequence)groupName) ? groupId : groupName));
                manager.createNotificationChannelGroup(this.setupNotificationChannelGroup(found));
            }
        }
    }

    @RequiresApi(value=26)
    @NonNull
    protected NotificationChannelGroup setupNotificationChannelGroup(@NonNull NotificationChannelGroup group) {
        return group;
    }

    @SuppressLint(value={"InlinedApi"})
    @NonNull
    protected NotificationBuilder createNotificationBuilder(@NonNull Context context, @NonNull CharSequence title, @NonNull CharSequence content) {
        PendingIntent deleteIntent;
        NotificationBuilder builder = new NotificationBuilder(context, this.channelId, this.smallIconId){

            @Override
            protected PendingIntent createContentIntent() {
                return NotificationFactory.this.createContentIntent();
            }
        };
        builder.setContentTitle(title).setContentText(content).setSmallIcon(this.smallIconId).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().setBigContentTitle(title).bigText(content).setSummaryText(content));
        PendingIntent contentIntent = this.createContentIntent();
        if (contentIntent != null) {
            builder.setContentIntent(contentIntent);
        }
        if ((deleteIntent = this.createDeleteIntent()) != null) {
            builder.setDeleteIntent(deleteIntent);
        }
        if (!TextUtils.isEmpty((CharSequence)this.groupId)) {
            builder.setGroup(this.groupId);
        }
        if (this.largeIconId != 0) {
            builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIconId));
        }
        return builder;
    }

    @Nullable
    protected PendingIntent createContentIntent() {
        return null;
    }

    @Nullable
    protected PendingIntent createDeleteIntent() {
        return null;
    }
}

