/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.serenegiant.media.AbstractVideoEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.ISurfaceEncoder;
import com.serenegiant.media.MediaCodecUtils;
import com.serenegiant.media.MediaReaper;

@TargetApi(value=18)
public class SurfaceEncoder
extends AbstractVideoEncoder
implements ISurfaceEncoder {
    protected Surface mInputSurface;

    public SurfaceEncoder(IRecorder recorder, EncoderListener listener) {
        super("video/avc", recorder, listener);
    }

    @Override
    public Surface getInputSurface() {
        return this.mInputSurface;
    }

    @Override
    public int getCaptureFormat() {
        return 0;
    }

    @Override
    protected boolean internalPrepare(@NonNull MediaReaper.ReaperListener listener) throws Exception {
        this.mTrackIndex = -1;
        this.mIsCapturing = true;
        MediaCodecInfo codecInfo = MediaCodecUtils.selectVideoEncoder("video/avc");
        if (codecInfo == null) {
            return true;
        }
        boolean mayFail = this.mWidth >= 1000 || this.mHeight >= 1000;
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)this.mWidth, (int)this.mHeight);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", this.mBitRate > 0 ? this.mBitRate : this.getConfig().getBitrate(this.mWidth, this.mHeight));
        format.setInteger("frame-rate", this.mFramerate > 0 ? this.mFramerate : this.getConfig().captureFps());
        format.setInteger("i-frame-interval", this.mIFrameIntervals > 0 ? this.mIFrameIntervals : this.getConfig().calcIFrameIntervals());
        this.mMediaCodec = MediaCodec.createEncoderByType((String)"video/avc");
        this.mMediaCodec.configure(format, null, null, 1);
        this.mInputSurface = this.mMediaCodec.createInputSurface();
        this.mMediaCodec.start();
        this.mReaper = new MediaReaper.VideoReaper(this.mMediaCodec, listener, this.mWidth, this.mHeight);
        return mayFail;
    }

    @Override
    public void release() {
        super.release();
        this.mInputSurface = null;
    }

    @Override
    public void signalEndOfInputStream() {
        if (this.mMediaCodec != null) {
            this.mMediaCodec.signalEndOfInputStream();
        }
    }
}

