/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.io.ChannelHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class PostMuxCommon {
    private static final boolean DEBUG = false;
    private static final String TAG = PostMuxCommon.class.getSimpleName();
    static final int TYPE_VIDEO = 0;
    static final int TYPE_AUDIO = 1;
    static final String VIDEO_NAME = "video.raw";
    static final String AUDIO_NAME = "audio.raw";
    private static final byte[] RESERVED = new byte[40];

    static final void writeFormat(@NonNull DataOutputStream out, @NonNull MediaFormat codecFormat, @NonNull MediaFormat outputFormat) throws IOException {
        String codecFormatStr = PostMuxCommon.asString(codecFormat);
        String outputFormatStr = PostMuxCommon.asString(outputFormat);
        int size = (TextUtils.isEmpty((CharSequence)codecFormatStr) ? 0 : codecFormatStr.length()) + (TextUtils.isEmpty((CharSequence)outputFormatStr) ? 0 : outputFormatStr.length());
        PostMuxCommon.writeHeader(out, 0, 0, -1L, size, 0);
        out.writeUTF(codecFormatStr);
        out.writeUTF(outputFormatStr);
    }

    static final void writeFormat(@NonNull ByteChannel out, @NonNull MediaFormat codecFormat, @NonNull MediaFormat outputFormat) throws IOException {
        String codecFormatStr = PostMuxCommon.asString(codecFormat);
        String outputFormatStr = PostMuxCommon.asString(outputFormat);
        int size = (TextUtils.isEmpty((CharSequence)codecFormatStr) ? 0 : codecFormatStr.length()) + (TextUtils.isEmpty((CharSequence)outputFormatStr) ? 0 : outputFormatStr.length());
        PostMuxCommon.writeHeader(out, 0, 0, -1L, size, 0);
        ChannelHelper.write(out, codecFormatStr);
        ChannelHelper.write(out, outputFormatStr);
    }

    static MediaFormat readFormat(@NonNull DataInputStream in) {
        MediaFormat format = null;
        try {
            PostMuxCommon.readHeader(in);
            in.readUTF();
            format = PostMuxCommon.asMediaFormat(in.readUTF());
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"readFormat:", (Throwable)e);
        }
        return format;
    }

    static MediaFormat readFormat(@NonNull ByteChannel in) {
        MediaFormat format = null;
        try {
            PostMuxCommon.readHeader(in);
            ChannelHelper.readString(in);
            format = PostMuxCommon.asMediaFormat(ChannelHelper.readString(in));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"readFormat:", (Throwable)e);
        }
        return format;
    }

    @SuppressLint(value={"InlinedApi"})
    static final String asString(@NonNull MediaFormat format) {
        JSONObject map = new JSONObject();
        try {
            if (format.containsKey("mime")) {
                map.put("mime", (Object)format.getString("mime"));
            }
            if (format.containsKey("width")) {
                map.put("width", format.getInteger("width"));
            }
            if (format.containsKey("height")) {
                map.put("height", format.getInteger("height"));
            }
            if (format.containsKey("bitrate")) {
                map.put("bitrate", format.getInteger("bitrate"));
            }
            if (format.containsKey("color-format")) {
                map.put("color-format", format.getInteger("color-format"));
            }
            if (format.containsKey("frame-rate")) {
                map.put("frame-rate", format.getInteger("frame-rate"));
            }
            if (format.containsKey("i-frame-interval")) {
                map.put("i-frame-interval", format.getInteger("i-frame-interval"));
            }
            if (format.containsKey("repeat-previous-frame-after")) {
                map.put("repeat-previous-frame-after", format.getLong("repeat-previous-frame-after"));
            }
            if (format.containsKey("max-input-size")) {
                map.put("max-input-size", format.getInteger("max-input-size"));
            }
            if (format.containsKey("durationUs")) {
                map.put("durationUs", format.getInteger("durationUs"));
            }
            if (format.containsKey("channel-count")) {
                map.put("channel-count", format.getInteger("channel-count"));
            }
            if (format.containsKey("sample-rate")) {
                map.put("sample-rate", format.getInteger("sample-rate"));
            }
            if (format.containsKey("channel-mask")) {
                map.put("channel-mask", format.getInteger("channel-mask"));
            }
            if (format.containsKey("aac-profile")) {
                map.put("aac-profile", format.getInteger("aac-profile"));
            }
            if (format.containsKey("aac-sbr-mode")) {
                map.put("aac-sbr-mode", format.getInteger("aac-sbr-mode"));
            }
            if (format.containsKey("max-input-size")) {
                map.put("max-input-size", format.getInteger("max-input-size"));
            }
            if (format.containsKey("is-adts")) {
                map.put("is-adts", format.getInteger("is-adts"));
            }
            if (format.containsKey("what")) {
                map.put("what", format.getInteger("what"));
            }
            if (format.containsKey("csd-0")) {
                map.put("csd-0", (Object)PostMuxCommon.asString(format.getByteBuffer("csd-0")));
            }
            if (format.containsKey("csd-1")) {
                map.put("csd-1", (Object)PostMuxCommon.asString(format.getByteBuffer("csd-1")));
            }
            if (format.containsKey("csd-2")) {
                map.put("csd-2", (Object)PostMuxCommon.asString(format.getByteBuffer("csd-2")));
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"writeFormat:", (Throwable)e);
        }
        return map.toString();
    }

    @SuppressLint(value={"InlinedApi"})
    static final MediaFormat asMediaFormat(@NonNull String format_str) {
        MediaFormat format = new MediaFormat();
        try {
            JSONObject map = new JSONObject(format_str);
            if (map.has("mime")) {
                format.setString("mime", (String)map.get("mime"));
            }
            if (map.has("width")) {
                format.setInteger("width", ((Integer)map.get("width")).intValue());
            }
            if (map.has("height")) {
                format.setInteger("height", ((Integer)map.get("height")).intValue());
            }
            if (map.has("bitrate")) {
                format.setInteger("bitrate", ((Integer)map.get("bitrate")).intValue());
            }
            if (map.has("color-format")) {
                format.setInteger("color-format", ((Integer)map.get("color-format")).intValue());
            }
            if (map.has("frame-rate")) {
                format.setInteger("frame-rate", ((Integer)map.get("frame-rate")).intValue());
            }
            if (map.has("i-frame-interval")) {
                format.setInteger("i-frame-interval", ((Integer)map.get("i-frame-interval")).intValue());
            }
            if (map.has("repeat-previous-frame-after")) {
                format.setLong("repeat-previous-frame-after", ((Long)map.get("repeat-previous-frame-after")).longValue());
            }
            if (map.has("max-input-size")) {
                format.setInteger("max-input-size", ((Integer)map.get("max-input-size")).intValue());
            }
            if (map.has("durationUs")) {
                format.setInteger("durationUs", ((Integer)map.get("durationUs")).intValue());
            }
            if (map.has("channel-count")) {
                format.setInteger("channel-count", ((Integer)map.get("channel-count")).intValue());
            }
            if (map.has("sample-rate")) {
                format.setInteger("sample-rate", ((Integer)map.get("sample-rate")).intValue());
            }
            if (map.has("channel-mask")) {
                format.setInteger("channel-mask", ((Integer)map.get("channel-mask")).intValue());
            }
            if (map.has("aac-profile")) {
                format.setInteger("aac-profile", ((Integer)map.get("aac-profile")).intValue());
            }
            if (map.has("aac-sbr-mode")) {
                format.setInteger("aac-sbr-mode", ((Integer)map.get("aac-sbr-mode")).intValue());
            }
            if (map.has("max-input-size")) {
                format.setInteger("max-input-size", ((Integer)map.get("max-input-size")).intValue());
            }
            if (map.has("is-adts")) {
                format.setInteger("is-adts", ((Integer)map.get("is-adts")).intValue());
            }
            if (map.has("what")) {
                format.setInteger("what", ((Integer)map.get("what")).intValue());
            }
            if (map.has("csd-0")) {
                format.setByteBuffer("csd-0", PostMuxCommon.asByteBuffer((String)map.get("csd-0")));
            }
            if (map.has("csd-1")) {
                format.setByteBuffer("csd-1", PostMuxCommon.asByteBuffer((String)map.get("csd-1")));
            }
            if (map.has("csd-2")) {
                format.setByteBuffer("csd-2", PostMuxCommon.asByteBuffer((String)map.get("csd-2")));
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("writeFormat:" + format_str), (Throwable)e);
            format = null;
        }
        return format;
    }

    static final String asString(@NonNull ByteBuffer buffer) {
        int n;
        byte[] temp = new byte[16];
        StringBuilder sb = new StringBuilder();
        int n2 = n = buffer != null ? buffer.limit() : 0;
        if (n > 0) {
            buffer.rewind();
            int sz = Math.min(n, 16);
            n -= sz;
            while (sz > 0) {
                buffer.get(temp, 0, sz);
                for (int i = 0; i < sz; ++i) {
                    sb.append(temp[i]).append(',');
                }
                sz = Math.min(n, 16);
                n -= sz;
            }
        }
        return sb.toString();
    }

    static final ByteBuffer asByteBuffer(@NonNull String str) {
        String[] hex = str.split(",");
        int m = hex.length;
        byte[] temp = new byte[m];
        int n = 0;
        for (int i = 0; i < m; ++i) {
            if (TextUtils.isEmpty((CharSequence)hex[i])) continue;
            temp[n++] = (byte)Integer.parseInt(hex[i]);
        }
        return n > 0 ? ByteBuffer.wrap(temp, 0, n) : null;
    }

    static void writeHeader(@NonNull DataOutputStream out, int sequence, int frame_number, long presentation_time_us, int size, int flag) throws IOException {
        out.writeInt(sequence);
        out.writeInt(frame_number);
        out.writeLong(presentation_time_us);
        out.writeInt(size);
        out.writeInt(flag);
        out.write(RESERVED, 0, 40);
    }

    static void writeHeader(@NonNull ByteChannel out, int sequence, int frame_number, long presentation_time_us, int size, int flag) throws IOException {
        ChannelHelper.write(out, sequence);
        ChannelHelper.write(out, frame_number);
        ChannelHelper.write(out, presentation_time_us);
        ChannelHelper.write(out, size);
        ChannelHelper.write(out, flag);
        ChannelHelper.write(out, RESERVED);
    }

    static MediaFrameHeader readHeader(@NonNull DataInputStream in, @NonNull MediaFrameHeader header) throws IOException {
        header.size = 0;
        header.sequence = in.readInt();
        header.frameNumber = in.readInt();
        header.presentationTimeUs = in.readLong();
        header.size = in.readInt();
        header.flags = in.readInt();
        in.skipBytes(40);
        return header;
    }

    static MediaFrameHeader readHeader(@NonNull DataInputStream in) throws IOException {
        MediaFrameHeader header = new MediaFrameHeader();
        return PostMuxCommon.readHeader(in, header);
    }

    static MediaFrameHeader readHeader(@NonNull ByteChannel in, @NonNull MediaFrameHeader header) throws IOException {
        header.size = 0;
        header.sequence = ChannelHelper.readInt(in);
        header.frameNumber = ChannelHelper.readInt(in);
        header.presentationTimeUs = ChannelHelper.readLong(in);
        header.size = ChannelHelper.readInt(in);
        header.flags = ChannelHelper.readInt(in);
        ChannelHelper.readByteArray(in);
        return header;
    }

    static MediaFrameHeader readHeader(@NonNull ByteChannel in) throws IOException {
        MediaFrameHeader header = new MediaFrameHeader();
        return PostMuxCommon.readHeader(in, header);
    }

    static int readFrameSize(@NonNull DataInputStream in) throws IOException {
        MediaFrameHeader header = PostMuxCommon.readHeader(in);
        return header.size;
    }

    static int readFrameSize(@NonNull ByteChannel in) throws IOException {
        MediaFrameHeader header = PostMuxCommon.readHeader(in);
        return header.size;
    }

    static final void writeStream(@NonNull DataOutputStream out, int sequence, int frameNumber, @NonNull MediaCodec.BufferInfo info, @NonNull ByteBuffer buffer, @NonNull byte[] work) throws IOException {
        buffer.position(info.offset);
        buffer.get(work, 0, info.size);
        PostMuxCommon.writeHeader(out, sequence, frameNumber, info.presentationTimeUs, info.size, info.flags);
        out.write(work, 0, info.size);
    }

    static final void writeStream(@NonNull ByteChannel out, int sequence, int frameNumber, @NonNull MediaCodec.BufferInfo info, @NonNull ByteBuffer buffer) throws IOException {
        buffer.position(info.offset);
        buffer.limit(info.offset + info.size);
        PostMuxCommon.writeHeader(out, sequence, frameNumber, info.presentationTimeUs, info.size, info.flags);
        ChannelHelper.write(out, buffer);
    }

    static ByteBuffer readStream(@NonNull DataInputStream in, @NonNull MediaFrameHeader header, @Nullable ByteBuffer buffer, @NonNull byte[] readBuffer) throws IOException {
        int read_bytes;
        PostMuxCommon.readHeader(in, header);
        if (buffer == null || header.size > buffer.capacity()) {
            buffer = ByteBuffer.allocateDirect(header.size);
        }
        buffer.clear();
        int max_bytes = Math.min(readBuffer.length, header.size);
        for (int i = header.size; i > 0 && (read_bytes = in.read(readBuffer, 0, Math.min(i, max_bytes))) > 0; i -= read_bytes) {
            buffer.put(readBuffer, 0, read_bytes);
        }
        buffer.flip();
        return buffer;
    }

    static ByteBuffer readStream(@NonNull ByteChannel in, @NonNull MediaFrameHeader header, @Nullable ByteBuffer buffer) throws IOException {
        PostMuxCommon.readHeader(in, header);
        if (buffer == null || header.size > buffer.capacity()) {
            buffer = ByteBuffer.allocateDirect(header.size);
        }
        buffer.clear();
        ChannelHelper.readByteBuffer(in, buffer);
        return buffer;
    }

    static class MediaFrameHeader {
        public int sequence;
        public int frameNumber;
        public long presentationTimeUs;
        public int size;
        public int flags;

        MediaFrameHeader() {
        }

        @NonNull
        public MediaCodec.BufferInfo asBufferInfo() {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            info.set(0, this.size, this.presentationTimeUs, this.flags);
            return info;
        }

        @NonNull
        public MediaCodec.BufferInfo asBufferInfo(@NonNull MediaCodec.BufferInfo info) {
            info.set(0, this.size, this.presentationTimeUs, this.flags);
            return info;
        }

        public void writeTo(@NonNull DataOutputStream out) throws IOException {
            out.writeInt(this.sequence);
            out.writeInt(this.frameNumber);
            out.writeLong(this.presentationTimeUs);
            out.writeInt(this.size);
            out.writeInt(this.flags);
            out.write(RESERVED, 0, 40);
        }

        public void writeTo(@NonNull ByteChannel out) throws IOException {
            ChannelHelper.write(out, this.sequence);
            ChannelHelper.write(out, this.sequence);
            ChannelHelper.write(out, this.frameNumber);
            ChannelHelper.write(out, this.presentationTimeUs);
            ChannelHelper.write(out, this.size);
            ChannelHelper.write(out, this.flags);
            ChannelHelper.write(out, RESERVED);
        }

        @NonNull
        public String toString() {
            return String.format(Locale.US, "MediaFrameHeader(sequence=%d,frameNumber=%d,presentationTimeUs=%d,size=%d,flags=%d)", this.sequence, this.frameNumber, this.presentationTimeUs, this.size, this.flags);
        }
    }
}

