/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MediaData {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    @NonNull
    private ByteOrder mByteOrder = ByteOrder.nativeOrder();
    private int mTrackIx;
    @Nullable
    private ByteBuffer mBuffer;
    private int mFlags;
    private int mSize = 1024;
    private long mPresentationTimeUs;

    public MediaData() {
    }

    public MediaData(@NonNull ByteOrder order) {
        this.mByteOrder = order;
    }

    public MediaData(@IntRange(from=0L) int size) {
        this.resize(size);
    }

    public MediaData(@IntRange(from=0L) int size, @NonNull ByteOrder order) {
        this.mByteOrder = order;
        this.resize(size);
    }

    public MediaData(@NonNull MediaData src) {
        this.mByteOrder = src.mByteOrder;
        this.set(src.mTrackIx, src.mBuffer, 0, src.mSize, src.mPresentationTimeUs, src.mFlags);
    }

    public void set(@NonNull MediaData src) {
        this.set(0, src.mBuffer, 0, src.mSize, src.mPresentationTimeUs, src.mFlags);
    }

    public void set(@NonNull ByteBuffer buffer, @IntRange(from=0L) int size, long presentationTimeUs) {
        this.set(0, buffer, 0, size, presentationTimeUs, 0);
    }

    public void set(@Nullable ByteBuffer buffer, @IntRange(from=0L) int _offset, @IntRange(from=0L) int _size, long _presentationTimeUs, int _flags) {
        this.set(0, buffer, _offset, _size, _presentationTimeUs, _flags);
    }

    public void set(int trackIx, @Nullable ByteBuffer buffer, @IntRange(from=0L) int offset, @IntRange(from=0L) int size, long presentationTimeUs, int flags) {
        this.mTrackIx = trackIx;
        this.mPresentationTimeUs = presentationTimeUs;
        this.mSize = size;
        this.mFlags = flags;
        this.resize(size);
        if (buffer != null && size > offset) {
            buffer.clear();
            buffer.position(offset + size);
            buffer.flip();
            buffer.position(offset);
            this.mBuffer.put(buffer);
            this.mBuffer.flip();
        }
    }

    public void set(@Nullable byte[] buffer, long presentationTimeUs) {
        this.set(0, buffer, 0, buffer != null ? buffer.length : 0, presentationTimeUs, 0);
    }

    public void set(int trackIx, @Nullable byte[] buffer, @IntRange(from=0L) int offset, @IntRange(from=0L) int size, long presentationTimeUs, int flags) {
        int _size = Math.min(buffer != null ? buffer.length : 0, size);
        this.mTrackIx = trackIx;
        this.mPresentationTimeUs = presentationTimeUs;
        this.mSize = _size;
        this.mFlags = flags;
        this.resize(_size);
        if (buffer != null && _size > offset) {
            this.mBuffer.put(buffer, offset, _size);
            this.mBuffer.flip();
        }
    }

    @TargetApi(value=16)
    public void set(@Nullable ByteBuffer buffer, @NonNull MediaCodec.BufferInfo info) {
        this.set(0, buffer, info);
    }

    @TargetApi(value=16)
    public void set(int trackIx, @Nullable ByteBuffer buffer, @NonNull MediaCodec.BufferInfo info) {
        this.mTrackIx = trackIx;
        this.mPresentationTimeUs = info.presentationTimeUs;
        this.mSize = buffer != null ? info.size : 0;
        this.mFlags = info.flags;
        int offset = info.offset;
        this.resize(this.mSize);
        if (buffer != null && this.mSize > offset) {
            buffer.clear();
            buffer.position(offset + this.mSize);
            buffer.flip();
            buffer.position(offset);
            this.mBuffer.put(buffer);
            this.mBuffer.flip();
        }
    }

    public MediaData resize(@IntRange(from=0L) int newSize) {
        if (this.mBuffer == null || this.mBuffer.capacity() < newSize) {
            this.mBuffer = ByteBuffer.allocateDirect(newSize).order(this.mByteOrder);
        }
        this.mBuffer.clear();
        return this;
    }

    public void clear() {
        this.mFlags = 0;
        this.mSize = 0;
        if (this.mBuffer != null) {
            this.mBuffer.clear();
        }
    }

    public int size() {
        return this.mSize;
    }

    public MediaData size(int size) {
        this.mSize = size;
        return this;
    }

    public int trackIx() {
        return this.mTrackIx;
    }

    public int flags() {
        return this.mFlags;
    }

    public long presentationTimeUs() {
        return this.mPresentationTimeUs;
    }

    public MediaData presentationTimeUs(long pts) {
        this.mPresentationTimeUs = pts;
        return this;
    }

    public void get(byte[] buffer) throws ArrayIndexOutOfBoundsException {
        if (this.mBuffer == null || this.mSize <= 0 || buffer == null || buffer.length < this.mSize) {
            throw new ArrayIndexOutOfBoundsException("");
        }
        this.mBuffer.clear();
        this.mBuffer.position(this.mSize);
        this.mBuffer.flip();
        this.mBuffer.get(buffer);
    }

    public void get(ByteBuffer buffer) throws ArrayIndexOutOfBoundsException {
        if (this.mBuffer == null || this.mSize <= 0 || buffer == null || buffer.remaining() < this.mSize) {
            throw new ArrayIndexOutOfBoundsException("");
        }
        this.mBuffer.clear();
        this.mBuffer.position(this.mSize);
        this.mBuffer.flip();
        buffer.put(this.mBuffer);
    }

    @TargetApi(value=16)
    public void get(@NonNull MediaCodec.BufferInfo info) {
        info.set(0, this.mSize, this.mPresentationTimeUs, this.mFlags);
    }

    @NonNull
    public ByteBuffer get() {
        if (this.mBuffer != null) {
            this.mBuffer.clear();
            this.mBuffer.position(this.mSize);
            this.mBuffer.flip();
        } else {
            this.resize(this.mSize > 0 ? this.mSize : 1024);
        }
        return this.mBuffer;
    }

    @NonNull
    public ByteBuffer get(int size) {
        this.resize(size);
        return this.get();
    }

    public int capacity() {
        return this.mBuffer != null ? this.mBuffer.capacity() : 0;
    }

    @NonNull
    public ByteOrder order() {
        return this.mByteOrder;
    }

    public MediaData order(@NonNull ByteOrder order) {
        this.mByteOrder = order;
        if (this.mBuffer != null) {
            this.mBuffer.order(order);
        }
        return this;
    }
}

