/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.view.Choreographer;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.GLTexture;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.glpipeline.GLPipelineSource;
import com.serenegiant.glpipeline.ProxyPipeline;
import com.serenegiant.math.Fraction;

public class ImageSourcePipeline
extends ProxyPipeline
implements GLPipelineSource {
    private static final boolean DEBUG = false;
    private static final String TAG = ImageSourcePipeline.class.getSimpleName();
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final GLManager mManager;
    @Nullable
    private GLTexture mImageSource;
    private volatile long mFrameIntervalNs;
    private int cnt;
    private final Choreographer.FrameCallback mFrameCallback = new Choreographer.FrameCallback(){
        private long prevFrameTimeNs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void doFrame(long frameTimeNanos) {
            if (ImageSourcePipeline.this.isValid()) {
                long delayMs = (ImageSourcePipeline.this.mFrameIntervalNs - (frameTimeNanos - this.prevFrameTimeNs)) / 1000000L;
                this.prevFrameTimeNs = frameTimeNanos;
                if (delayMs <= 0L) {
                    ImageSourcePipeline.this.mManager.postFrameCallbackDelayed(this, 0L);
                } else {
                    ImageSourcePipeline.this.mManager.postFrameCallbackDelayed(this, delayMs);
                }
                Object object = ImageSourcePipeline.this.mSync;
                synchronized (object) {
                    if (ImageSourcePipeline.this.mImageSource != null) {
                        ImageSourcePipeline.this.onFrameAvailable(false, ImageSourcePipeline.this.mImageSource.getTexId(), ImageSourcePipeline.this.mImageSource.getTexMatrix());
                    }
                }
            }
        }
    };

    public ImageSourcePipeline(@NonNull GLManager manager, final @Nullable Bitmap bitmap, final @Nullable Fraction fps) {
        this.mManager = manager;
        if (bitmap != null) {
            this.mManager.runOnGLThread(new Runnable(){

                @Override
                @WorkerThread
                public void run() {
                    ImageSourcePipeline.this.createImageSource(bitmap, fps);
                }
            });
        }
    }

    @Override
    protected void internalRelease() {
        if (this.isValid()) {
            this.mManager.runOnGLThread(new Runnable(){

                @Override
                public void run() {
                    ImageSourcePipeline.this.releaseImageSource();
                }
            });
        }
        super.internalRelease();
    }

    @Override
    @NonNull
    public GLManager getGLManager() throws IllegalStateException {
        return this.mManager;
    }

    @Override
    @NonNull
    public SurfaceTexture getInputSurfaceTexture() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("");
    }

    @Override
    @NonNull
    public Surface getInputSurface() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTexId() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isValid() || this.mImageSource == null) {
                throw new IllegalStateException("already released or image not set yet.");
            }
            return this.mImageSource != null ? this.mImageSource.getTexId() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Size(min=16L)
    @NonNull
    public float[] getTexMatrix() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isValid() || this.mImageSource == null) {
                throw new IllegalStateException("already released or image not set yet.");
            }
            return this.mImageSource.getTexMatrix();
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.mManager.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isValid() || this.mImageSource == null) {
                return;
            }
        }
        super.onFrameAvailable(isOES, texId, texMatrix);
    }

    public void setSource(final @Nullable Bitmap bitmap, final @Nullable Fraction fps) {
        this.mManager.runOnGLThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ImageSourcePipeline.this.mSync;
                synchronized (object) {
                    if (bitmap == null) {
                        ImageSourcePipeline.this.releaseImageSource();
                    } else {
                        ImageSourcePipeline.this.createImageSource(bitmap, fps);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void releaseImageSource() {
        this.mManager.removeFrameCallback(this.mFrameCallback);
        Object object = this.mSync;
        synchronized (object) {
            if (this.mImageSource != null) {
                this.mImageSource.release();
                this.mImageSource = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void createImageSource(@NonNull Bitmap bitmap, @Nullable Fraction fps) {
        this.mManager.removeFrameCallback(this.mFrameCallback);
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        boolean needResize = this.getWidth() != width || this.getHeight() != height;
        float _fps = fps != null ? fps.asFloat() : 30.0f;
        Object object = this.mSync;
        synchronized (object) {
            if (this.mImageSource == null || needResize) {
                this.releaseImageSource();
                this.mImageSource = GLTexture.newInstance(33984, width, height);
                GLUtils.checkGlError("createImageSource");
            }
            this.mImageSource.loadBitmap(bitmap);
            this.mFrameIntervalNs = Math.round(1.0E9 / (double)_fps);
        }
        if (needResize) {
            this.resize(width, height);
        }
        this.mManager.postFrameCallbackDelayed(this.mFrameCallback, 0L);
    }
}

