/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.bluetooth;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.util.Log;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import androidx.fragment.app.Fragment;
import java.util.Collections;
import java.util.Set;

public class BluetoothUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = BluetoothUtils.class.getSimpleName();
    @NonNull
    private final ActivityResultLauncher<Intent> mLauncher;
    private boolean requestBluetooth;
    private static final String ACTION_REQUEST_DISABLE = "android.bluetooth.adapter.action.REQUEST_DISABLE";

    @RequiresPermission(value="android.permission.BLUETOOTH")
    public BluetoothUtils(@NonNull ComponentActivity activity, @NonNull BluetoothEnableCallback callback) {
        this.mLauncher = activity.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), result -> {
            this.requestBluetooth = false;
            callback.onChanged(BluetoothUtils.isEnabled());
        });
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    public BluetoothUtils(@NonNull Fragment fragment, @NonNull BluetoothEnableCallback callback) {
        this.mLauncher = fragment.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), result -> {
            this.requestBluetooth = false;
            callback.onChanged(BluetoothUtils.isEnabled());
        });
    }

    public boolean requestEnable() {
        if (BluetoothUtils.isAvailable() && !BluetoothUtils.isEnabled() && !this.requestBluetooth) {
            this.requestBluetooth = true;
            this.mLauncher.launch((Object)new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE"));
        }
        return BluetoothUtils.isEnabled();
    }

    public boolean requestDisable() {
        if (BluetoothUtils.isEnabled()) {
            this.requestBluetooth = true;
            this.mLauncher.launch((Object)new Intent(ACTION_REQUEST_DISABLE));
        }
        return BluetoothUtils.isEnabled();
    }

    public static boolean isAvailable() {
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            return adapter != null;
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return false;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isEnabled() {
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            return adapter != null && adapter.isEnabled();
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    @NonNull
    public static Set<BluetoothDevice> getBondedDevices() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        return adapter != null && adapter.isEnabled() ? adapter.getBondedDevices() : Collections.emptySet();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    public static boolean requestDiscoverable(@NonNull Activity activity, int duration) throws IllegalStateException {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null || !adapter.isEnabled()) {
            throw new IllegalStateException("bluetooth\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u304b\u7121\u52b9\u306b\u306a\u3063\u3066\u3044\u308b");
        }
        if (adapter.getScanMode() != 23) {
            Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
            intent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", duration);
            activity.startActivity(intent);
        }
        return adapter.getScanMode() == 23;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    public static boolean requestDiscoverable(@NonNull Fragment fragment, int duration) throws IllegalStateException {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null || !adapter.isEnabled()) {
            throw new IllegalStateException("bluetooth\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u304b\u7121\u52b9\u306b\u306a\u3063\u3066\u3044\u308b");
        }
        if (adapter.getScanMode() != 23) {
            Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
            if (duration > 0 && duration <= 300) {
                intent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", duration);
            }
            fragment.startActivity(intent);
        }
        return adapter.getScanMode() == 23;
    }

    public static interface BluetoothEnableCallback {
        public void onChanged(boolean var1);
    }
}

