/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import com.serenegiant.dialog.AppDialogFragmentEx;

public class MessageDialogAppFragment
extends AppDialogFragmentEx {
    private static final String TAG = MessageDialogAppFragment.class.getSimpleName();
    private static final String ARGS_KEY_PERMISSIONS = "permissions";
    private MessageDialogListener mDialogListener;
    private final DialogInterface.OnClickListener mOnClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            MessageDialogAppFragment.this.callOnMessageDialogResult(which == -1);
        }
    };

    public static MessageDialogAppFragment showDialog(@NonNull Activity parent, int requestCode, @StringRes int id_title, @StringRes int id_message, @NonNull String[] permissions) throws IllegalStateException {
        MessageDialogAppFragment dialog = MessageDialogAppFragment.newInstance(requestCode, id_title, id_message, permissions);
        dialog.show(parent.getFragmentManager(), TAG);
        return dialog;
    }

    public static MessageDialogAppFragment showDialog(@NonNull Fragment parent, int requestCode, @StringRes int id_title, @StringRes int id_message, @NonNull String[] permissions) throws IllegalStateException {
        MessageDialogAppFragment dialog = MessageDialogAppFragment.newInstance(requestCode, id_title, id_message, permissions);
        dialog.setTargetFragment(parent, parent.getId());
        dialog.show(parent.getFragmentManager(), TAG);
        return dialog;
    }

    public static MessageDialogAppFragment newInstance(int requestCode, @StringRes int id_title, @StringRes int id_message, @NonNull String[] permissions) {
        MessageDialogAppFragment fragment = new MessageDialogAppFragment();
        Bundle args = new Bundle();
        args.putInt("requestCode", requestCode);
        args.putInt("title_id", id_title);
        args.putInt("message_id", id_message);
        args.putStringArray(ARGS_KEY_PERMISSIONS, permissions);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(@NonNull Context context) {
        Fragment target;
        Fragment fragment;
        super.onAttach(context);
        if (context instanceof MessageDialogListener) {
            this.mDialogListener = (MessageDialogListener)context;
        }
        if (this.mDialogListener == null && (fragment = this.getTargetFragment()) instanceof MessageDialogListener) {
            this.mDialogListener = (MessageDialogListener)fragment;
        }
        if (Build.VERSION.SDK_INT >= 17 && this.mDialogListener == null && (target = this.getParentFragment()) instanceof MessageDialogListener) {
            this.mDialogListener = (MessageDialogListener)target;
        }
        if (this.mDialogListener == null) {
            throw new ClassCastException(context.toString());
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = savedInstanceState != null ? savedInstanceState : this.getArguments();
        int id_title = args.getInt("title_id");
        int id_message = args.getInt("message_id");
        Activity activity = this.getActivity();
        return new AlertDialog.Builder((Context)activity, this.getTheme()).setIcon(17301543).setTitle(id_title).setMessage(id_message).setPositiveButton(17039370, this.mOnClickListener).setNegativeButton(0x1040000, this.mOnClickListener).create();
    }

    public void onCancel(@NonNull DialogInterface dialog) {
        super.onCancel(dialog);
        this.callOnMessageDialogResult(false);
    }

    private void callOnMessageDialogResult(boolean result) throws IllegalStateException {
        Bundle args = this.getArguments();
        int requestCode = args.getInt("requestCode");
        String[] permissions = args.getStringArray(ARGS_KEY_PERMISSIONS);
        try {
            this.mDialogListener.onMessageDialogResult(this, requestCode, permissions, result);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    public static interface MessageDialogListener {
        public void onMessageDialogResult(@NonNull MessageDialogAppFragment var1, int var2, @NonNull String[] var3, boolean var4);
    }
}

