/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.graphics.SurfaceTexture;
import android.opengl.Matrix;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.ISurfacePreview;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.media.PreviewDecoder;
import com.serenegiant.usb.uvc.IPipeline;
import java.nio.ByteBuffer;

@Keep
public class GLPreviewPipeline
extends IPipeline
implements ISurfacePreview,
IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = GLPreviewPipeline.class.getSimpleName();
    @NonNull
    private final Object mDecoderSync = new Object();
    @NonNull
    private final float[] mMvpMatrix = new float[16];
    @Nullable
    private PreviewDecoder mDecoder;
    @Nullable
    private Surface mSurface;
    private int mMirror = 0;
    private static final int OFFSET = 0;

    public GLPreviewPipeline(@IntRange(from=2L, to=3L) int glVersion, boolean keepLastFrame) {
        this(glVersion, keepLastFrame, false);
    }

    public GLPreviewPipeline(@IntRange(from=2L, to=3L) int glVersion, boolean keepLastFrame, boolean enable_hw_buffer) {
        super(530);
        this.mNativePtr = this.nativeCreate(glVersion, keepLastFrame, enable_hw_buffer);
        Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
    }

    @Override
    public int getState() {
        return this.nativeGetState(this.mNativePtr);
    }

    @Override
    public void setPipeline(@Nullable IPipeline nextPipeline) {
        if (this.getState() < 20) {
            throw new IllegalStateException("already released");
        }
        this.nativeSetPipeline(this.mNativePtr, nextPipeline);
    }

    @Override
    public void start() {
        int result;
        if (this.mSurface != null) {
            this.createDecoder(this.mSurface);
        }
        if ((result = GLPreviewPipeline.nativeStart(this.mNativePtr)) != 0) {
            throw new IllegalStateException(Integer.toString(result));
        }
    }

    @Override
    public void stop() {
        this.stopDecoder();
        int result = GLPreviewPipeline.nativeStop(this.mNativePtr);
        this.releaseDecoder();
        if (result != 0) {
            Log.w((String)TAG, (String)("nativeStop returned " + result));
        }
    }

    @Override
    public void release() {
        this.nativeDestroy(this.mNativePtr);
        this.mNativePtr = 0L;
        this.releaseDecoder();
    }

    public void setPreviewSurface(SurfaceHolder holder) {
        Surface surface = holder != null ? holder.getSurface() : null;
        this.setPreviewSurface(surface);
    }

    public void setPreviewSurface(SurfaceTexture texture) {
        Surface surface = texture != null ? new Surface(texture) : null;
        this.setPreviewSurface(surface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviewSurface(Surface surface) {
        Object object = this.mDecoderSync;
        synchronized (object) {
            if (surface != this.mSurface) {
                this.releaseDecoder();
            }
            this.mSurface = surface;
        }
        GLPreviewPipeline.nativeSetPreviewSurface(this.mNativePtr, surface);
    }

    public void setMaxFps(int maxFps) {
        if (this.mNativePtr != 0L) {
            GLPreviewPipeline.nativeSetMaxFps(this.mNativePtr, maxFps);
        }
    }

    public void setMirror(int mirror) {
        if (this.mMirror != mirror) {
            Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
            GLUtils.setMirror((float[])this.mMvpMatrix, (int)mirror);
            GLPreviewPipeline.nativeSetMvpMatrix(this.mNativePtr, this.mMvpMatrix, 0);
            this.mMirror = mirror;
        }
    }

    public int getMirror() {
        return this.mMirror;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    protected synchronized void onFrame(ByteBuffer frame, int width, int height, long presentationTimeUs, int frame_format, int flags) {
        if (this.mDecoder == null && this.mSurface != null) {
            this.createDecoder(this.mSurface);
        }
        Object object = this.mDecoderSync;
        synchronized (object) {
            if (this.mDecoder != null) {
                this.mDecoder.onFrame(frame, width, height, presentationTimeUs, frame_format, flags);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDecoder(@NonNull Surface surface) {
        Object object = this.mDecoderSync;
        synchronized (object) {
            if (this.mDecoder == null) {
                this.mDecoder = PreviewDecoder.createDecoder(surface);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDecoder() {
        Object object = this.mDecoderSync;
        synchronized (object) {
            if (this.mDecoder != null) {
                this.mDecoder.stop();
            }
            this.mDecoderSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDecoder() {
        this.stopDecoder();
        Object object = this.mDecoderSync;
        synchronized (object) {
            if (this.mDecoder != null) {
                this.mDecoder.release();
            }
            this.mDecoder = null;
            this.mSurface = null;
        }
    }

    private final native long nativeCreate(int var1, boolean var2, boolean var3);

    private final native void nativeDestroy(long var1);

    private final native int nativeGetState(long var1);

    private final native int nativeSetPipeline(long var1, IPipeline var3);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);

    private static final native int nativeSetPreviewSurface(long var0, Surface var2);

    private static final native int nativeSetMaxFps(long var0, int var2);

    private static final native int nativeSetMvpMatrix(long var0, @Nullable float[] var2, int var3);
}

