/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;

public class ContentLoadingProgressBar
extends ProgressBar {
    private static final int MIN_SHOW_TIME_MS = 500;
    private static final int MIN_DELAY_MS = 500;
    long mStartTime = -1L;
    boolean mPostedHide = false;
    boolean mPostedShow = false;
    boolean mDismissed = false;
    private final Runnable mDelayedHide = () -> {
        this.mPostedHide = false;
        this.mStartTime = -1L;
        this.setVisibility(8);
    };
    private final Runnable mDelayedShow = () -> {
        this.mPostedShow = false;
        if (!this.mDismissed) {
            this.mStartTime = System.currentTimeMillis();
            this.setVisibility(0);
        }
    };

    public ContentLoadingProgressBar(@NonNull Context context) {
        this(context, null);
    }

    public ContentLoadingProgressBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs, 0);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.removeCallbacks();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks();
    }

    private void removeCallbacks() {
        this.removeCallbacks(this.mDelayedHide);
        this.removeCallbacks(this.mDelayedShow);
    }

    public void hide() {
        this.post(this::hideOnUiThread);
    }

    @UiThread
    private void hideOnUiThread() {
        this.mDismissed = true;
        this.removeCallbacks(this.mDelayedShow);
        this.mPostedShow = false;
        long diff = System.currentTimeMillis() - this.mStartTime;
        if (diff >= 500L || this.mStartTime == -1L) {
            this.setVisibility(8);
        } else if (!this.mPostedHide) {
            this.postDelayed(this.mDelayedHide, 500L - diff);
            this.mPostedHide = true;
        }
    }

    public void show() {
        this.post(this::showOnUiThread);
    }

    @UiThread
    private void showOnUiThread() {
        this.mStartTime = -1L;
        this.mDismissed = false;
        this.removeCallbacks(this.mDelayedHide);
        this.mPostedHide = false;
        if (!this.mPostedShow) {
            this.postDelayed(this.mDelayedShow, 500L);
            this.mPostedShow = true;
        }
    }
}

